TITLE  WinMem assembly language library routines   



WINMEM1 SEGMENT PARA PUBLIC 'CODE'
       ASSUME CS:WINMEM1,DS:NOTHING

;------------------------------------------------------------------------------
;    _FarCharIndex: 
;    Routine to find the position of a character within a character string.
;    This routine accepts a far pointer to the input character string, therefore
;    allowing a small or medium model program to use global memory for the
;    character string.
;
;    Syntax:
;       WORD FAR FarCharIndex(char far *buffer,char c, WORD count)
;       The FarCharIndex function searches the first 'count' bytes of 'buffer'
;       for the first occurence of the character 'c'.
;
;    Return Value:
;       The function returns the character position (0 to count-1) of the 
;       character 'c'.  It returns 'count' if the character is not within
;       first 'count' bytes of the buffer.  When a pointer to the located
;       character is desired, use the following construct:
;          pointer = &buffer[return value];
;------------------------------------------------------------------------------            

_FarCharIndex         PROC FAR
       PUBLIC  _FarCharIndex
       push    bp
       mov     bp,sp
       push    ds
       push    es
       push    si
       push    di

;****************** define the argument list **********************************
fci_frame   struc
fci_bptr        dw  ?
fci_ret_off     dw  ?
fci_ret_seg     dw  ?
fci_soff        dw  ?
fci_sseg        dw  ?
fci_char        dw  ?
fci_count       dw  ?
fci_frame   ends

fci_stack   equ     [bp]
;****************** initial logic - stuff registers ***************************
fci_init:

       mov     ax,fci_stack.fci_sseg
       mov     es,ax
       mov     di,fci_stack.fci_soff   ;  load the buffer address into es/di registers

       mov     cx,fci_stack.fci_count
       mov     ax,fci_stack.fci_char
       cld                             ; clear the direction bit

       repne   scasb                   ; repeat until the character is located or cx = 0

       jnz    fci_not_found

       mov    ax,fci_stack.fci_count   ; return value = count - CX - 1
       sub    ax,cx
       dec    ax
       jmp    fci_end

fci_not_found:
       mov     ax,fci_stack.fci_count  ; not found, return 'count'

fci_end:
       pop     di
       pop     si
       pop     es
       pop     ds
       mov     sp,bp
       pop     bp

               RET
_FarCharIndex  ENDP

;------------------------------------------------------------------------------
;    _FarFill: 
;    Routine to fill the requested memory location by a given character.
;    This routine accepts a far pointer to the input string, therefore
;    allowing a small or medium model program to use global memory for the
;    character string.
;
;    Syntax:
;       void FAR FarFill(char far *buffer,char c, WORD count)
;       The FarFill function fills the 'buffer' with 'count' of the
;       character 'c'.
;
;    Return Value:
;       None;
;------------------------------------------------------------------------------            

_FarFill         PROC FAR
       PUBLIC  _FarFill
       push    bp
       mov     bp,sp
       push    ds
       push    es
       push    si
       push    di

;****************** define the argument list **********************************
ff_frame   struc
ff_bptr        dw  ?
ff_ret_off     dw  ?
ff_ret_seg     dw  ?
ff_soff        dw  ?
ff_sseg        dw  ?
ff_char        dw  ?
ff_count       dw  ?
ff_frame   ends

ff_stack   equ     [bp]
;****************** initial logic - stuff registers ***************************
ff_init:

       mov     ax,ff_stack.ff_sseg
       mov     es,ax
       mov     di,ff_stack.ff_soff   ;  load the buffer address into es/di registers

       mov     cx,ff_stack.ff_count
       mov     ax,ff_stack.ff_char
       cld                             ; clear the direction bit

       rep     stosb                   ; repeat until the buffer if full

ff_end:
       pop     di
       pop     si
       pop     es
       pop     ds
       mov     sp,bp
       pop     bp

               RET
_FarFill  ENDP

;------------------------------------------------------------------------------
;    _FarComp: 
;    Routine to compare two strings.
;    This routine accepts far pointers to the input strings, therefore
;    allowing a small or medium model program to use global memory for the
;    character string.
;
;    Syntax:
;       int FAR FarComp(char far *buffer1,char far *buffer2, WORD count)
;       The FarComp function compares first 'count' characters of the strings
;       buffer1 and buffer2.
;
;    Return Value:
;       -1   :   buffer1 less than buffer 2
;        0   :   buffer1 equal to buffer2
;       +1   :   buffer1 greater than buffer2
;------------------------------------------------------------------------------            

_FarComp         PROC FAR
       PUBLIC  _FarComp
       push    bp
       mov     bp,sp
       push    ds
       push    es
       push    si
       push    di

;****************** define the argument list **********************************
fco_frame   struc
fco_bptr        dw  ?
fco_ret_off     dw  ?
fco_ret_seg     dw  ?
fco_off1        dw  ?
fco_seg1        dw  ?
fco_off2        dw  ?
fco_seg2        dw  ?
fco_count       dw  ?
fco_frame   ends

fco_stack   equ     [bp]
;****************** initial logic - stuff registers ***************************
fco_init:

       mov     ax,fco_stack.fco_seg1
       mov     ds,ax
       mov     si,fco_stack.fco_off1   ;  load buffer1 address into ds/si registers

       mov     ax,fco_stack.fco_seg2
       mov     es,ax
       mov     di,fco_stack.fco_off2   ;  load buffer2 address into es/si registers

       mov     cx,fco_stack.fco_count
       cld                             ; clear the direction bit

       repe   cmpsb                    ; repeat until the character is located or cx = 0

       je     equal_strings

       dec    si                       ; position at the first non-match
       dec    di

       mov    bl,byte ptr ds:[si]
       mov    cl,byte ptr es:[di]

       mov    ax,1                     ; set to buffer1>buffer2
       cmp    bl,cl
       ja     fco_end
       
       mov    ax,-1                    ; buffer1<buffer2
       jmp    fco_end

equal_strings:
       mov     ax,0                   ; return 0 to indicate an equal match

fco_end:
       pop     di
       pop     si
       pop     es
       pop     ds
       mov     sp,bp
       pop     bp

               RET
_FarComp  ENDP

;------------------------------------------------------------------------------
;    _FarMoveRev: 
;    Routine to move a memory block in the reverse order, i.e the last byte of
;    the source block will be moved first and so on.  This routine is internally
;    used by FarMoveOl function. 
;
;    Syntax:
;       int FAR FarMoveRev(LPSTR Source,LPSTR Dest, WORD count)
;
;    Return Value:
;       None.
;------------------------------------------------------------------------------            

_FarMoveRev PROC FAR
       PUBLIC  _FarMoveRev
       push    bp
       mov     bp,sp
       push    ds
       push    es
       push    si
       push    di

;****************** define the argument list **********************************
rmm_frame   struc
rmm_bptr        dw  ?
rmm_ret_off     dw  ?
rmm_ret_seg     dw  ?
rmm_off1        dw  ?
rmm_seg1        dw  ?
rmm_off2        dw  ?
rmm_seg2        dw  ?
rmm_count       dw  ?
rmm_frame   ends

rmm_stack   equ     [bp]
;****************** initial logic - stuff registers ***************************
rmm_init:

       mov     ax,rmm_stack.rmm_seg1
       mov     ds,ax
       mov     si,rmm_stack.rmm_off1   ;  load buffer1 address into ds/si registers

       mov     ax,rmm_stack.rmm_seg2
       mov     es,ax
       mov     di,rmm_stack.rmm_off2   ;  load buffer2 address into es/si registers

       mov     cx,rmm_stack.rmm_count
       add     si,cx                   ; start from the tail end of the memory
       add     di,cx          
       dec     si
       dec     di

       std                             ; set reverse direction

       rep    movsb                    ; move characters in the reverse order

       cld                             

rmm_end:
       pop     di
       pop     si
       pop     es
       pop     ds
       mov     sp,bp
       pop     bp

               RET
_FarMoveRev  ENDP

WINMEM1        ENDS
               END
