#include <windows.h>
#include <commdlg.h>
#include <stdlib.h>
#include "screen.h"

extern char cInvertedArray[1920];
HSCREEN ScreenList;
HINSTANCE hInst;
HDC hDC;
char               gszAllocErrorMsg[]="Error Allocating Memory!";
char               gszLockErrorMsg[]="Error Locking Memory!";
char               gszLoadStrFail[]="LoadString failed!";

int bDoubleClick=FALSE;
extern LOGFONT lf;
extern HFONT hFont;
extern int bMouseDown;
extern int bSelection;

char szScreenClass[]="ScreenWClass";
char szScreenMenu[]="ScreenMenu";
char tmpStr[256];
char strTmp[256];
/* for debugging purposes */
OFSTRUCT ofFile;
HFILE fh;

#ifdef WINMEM
CATCHBUF EndRtn;              /* error return buffer (required by WinMem)*/
#endif

//#define FILE_DEBUG

int FAR PASCAL LibMain(HANDLE hInstance,WORD wDataSeg,WORD wHeapSize,
    LPSTR lpszCmdLine) {
    WNDCLASS    wc;

    if (wHeapSize>0) UnlockData(0);
    hInst=hInstance;
    
//    wsprintf(strTmp,"hInst= %d \r\n",hInst);
//    OutputDebugString(strTmp);
    
    ScreenList=NULL;

    wc.style = CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS|CS_GLOBALCLASS;       /* Class style(s).                    */
    wc.lpfnWndProc = ScreenWndProc;         /* Function to retrieve messages for  */
                                            /* windows of this class.             */
    wc.cbClsExtra = 0;                      /* No per-class extra data.           */
    wc.cbWndExtra = sizeof(HGLOBAL);        /* Only extra data is handle to screen*/
    wc.hInstance = hInstance;               /* Application that owns the class.   */
    wc.hIcon = LoadIcon(hInstance, "TERMINAL");
    wc.hCursor = LoadCursor(NULL, IDC_IBEAM);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  szScreenMenu;        /* Name of menu resource in .RC file. */
    wc.lpszClassName = szScreenClass;      /* Name used in call to CreateWindow. */

    /* Register the window class and return success/failure code. */
    if (!RegisterClass(&wc))
    	MessageBox(NULL,"Couldn't register Class!",NULL,MB_OK);
    return(1);
}

void FAR PASCAL Wep(int ExitCode) {
//	OutputDebugString("Closing Screen DLL!!!! \r\n");
}

int GetNewScreen(void) {
    HGLOBAL ghScr;
    SCREEN far *fpScr, far *fpTmp,far *fpTmp2;
    static int id=0;

    if (ScreenList==NULL) {
        ghScr = GlobalAlloc(GHND,sizeof(SCREEN));
        if (ghScr==NULL) return -1;
        fpScr = (SCREEN far *)GlobalLock(ghScr);
        if (fpScr==NULL) return -1;
        fpScr->next=NULL;
        fpScr->prev=NULL;
        GlobalUnlock(ghScr);
        ScreenList=ghScr;
        return(id++);
    } else {
        ghScr = GlobalAlloc(GHND,sizeof(SCREEN));
        if (ghScr==NULL) return -1;
        fpScr = (SCREEN far *)GlobalLock(ghScr);
        if (fpScr==NULL) return -1;
        fpScr->next=ScreenList;
        fpTmp = (SCREEN far *)GlobalLock(ScreenList);
        if (fpTmp->next==NULL) {
            fpScr->next=ScreenList;
            fpScr->prev=ScreenList;
            fpTmp->next=ghScr;
            fpTmp->prev=ghScr;
        } else {
            fpScr->next=ScreenList;
            fpScr->prev=fpTmp->prev;
            fpTmp2 = (SCREEN far *)GlobalLock(fpTmp->prev);
            fpTmp2->next=ghScr;
            GlobalUnlock(fpTmp->prev);
            fpTmp->prev=ghScr;
        }
        GlobalUnlock(fpScr->next);
        GlobalUnlock(ghScr);
        ScreenList=ghScr;
        return(id++);
    }
}

HSCREENLINE ScreenNewLine()
{
    HSCREENLINE hgScrLine;
    SCREENLINE FAR *fpScrLine;
    int idx;
    
    hgScrLine=LINE_MEM_ALLOC(sizeof(SCREENLINE));
    if (hgScrLine==NULL) return (NULL);
    fpScrLine=LINE_MEM_LOCK(hgScrLine);
    if (fpScrLine==NULL) return (NULL);
    for (idx=0; idx<132; idx++) {
        fpScrLine->text[idx]=0;
        fpScrLine->attrib[idx]=0;
        }
    fpScrLine->next=fpScrLine->prev=NULL;
    LINE_MEM_UNLOCK(hgScrLine);
    return(hgScrLine);
}  

HSCREEN FAR PASCAL InitNewScreen(CONFIG FAR *Config) {   
    TEXTMETRIC  tm;
    HMENU hMenu=NULL;
    SCREEN far *scr=NULL;
    HSCREENLINE hgScrLine,hgScrLineTmp,hgScrLineLast;
    SCREENLINE FAR *fpScrLine;
    int id,idx=0;
    char strTmp[256];
	 
    id=GetNewScreen();
    if (id == -1) return(0);
    scr=(SCREEN far *) GlobalLock(ScreenList);
    if (scr==NULL) OutputDebugString("Scr is NULL!\r\n");
	        
    hMenu = LoadMenu(hInst,szScreenMenu);
    if (hMenu==NULL) OutputDebugString("hMenu is NULL! \r\n");
    
    scr->hWnd = CreateWindow((char far *)szScreenClass,Config->title,WS_OVERLAPPEDWINDOW |WS_VSCROLL,
        CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,NULL,hMenu,hInst,NULL);
    
	if (!(scr->hWnd)) {
		OutputDebugString("Couldn't Create Window!! \r\n");
		return(0); 
	}
    scr->hwndTel=Config->hwndTel;  /* save HWND of calling window */
	
	if (Config->backspace) {
        CheckMenuItem(hMenu,IDM_BACKSPACE,MF_CHECKED);
        CheckMenuItem(hMenu,IDM_DELETE,MF_UNCHECKED);
    } else {
        CheckMenuItem(hMenu,IDM_BACKSPACE,MF_UNCHECKED);
        CheckMenuItem(hMenu,IDM_DELETE,MF_CHECKED);
    }    
    SetWindowWord(scr->hWnd,SCREEN_HANDLE,(WORD)ScreenList);
    hDC = GetDC(scr->hWnd);

    scr->lf.lfPitchAndFamily=FIXED_PITCH;
    GetPrivateProfileString("FONT","FaceName","Courier",scr->lf.lfFaceName,
        LF_FACESIZE,"ncsa_net.ini");
    scr->lf.lfHeight=(int)GetPrivateProfileInt("FONT","Height",0,"ncsa_net.ini");
    scr->lf.lfWidth=(int)GetPrivateProfileInt("FONT","Width",0,"ncsa_net.ini");
    scr->lf.lfPitchAndFamily=(BYTE)GetPrivateProfileInt("FONT","PitchAndFamily",0,"ncsa_net.ini");
    scr->lf.lfCharSet=(BYTE)GetPrivateProfileInt("FONT","CharSet",0,"ncsa_net.ini");
    scr->lf.lfEscapement=(BYTE)GetPrivateProfileInt("FONT","Escapement",0,"ncsa_net.ini");
    scr->lf.lfQuality=PROOF_QUALITY;
    scr->ghSelectedFont = CreateFontIndirect((LPLOGFONT)&(scr->lf));
    
    SelectObject(hDC,scr->ghSelectedFont);
                
    GetTextMetrics(hDC,(LPTEXTMETRIC)&tm);
    scr->cxChar = tm.tmAveCharWidth;
    scr->cyChar = tm.tmHeight + tm.tmExternalLeading;

    ReleaseDC(scr->hWnd,hDC);    
    scr->width=Config->width;
    scr->height=Config->height;
    scr->ID=id;
    scr->x=0;    
    scr->y=0;
    scr->Oldx=0;
    scr->Oldy=0;
    scr->attrib=0;
    scr->Rtop=0;
    scr->Rbottom=23;
    scr->Rleft=0;
    scr->Rright=79;
    scr->DECAWM=0;  
    scr->maxwidth=80;
    scr->allwidth=132;         
    scr->top=0;
    scr->bottom=23;
    scr->parmptr=0;
    scr->escflg=0;
    scr->bAlert=FALSE;
    scr->numlines=0;
    scr->maxlines=150;

    hgScrLineLast=NULL;    
    scr->screen_top=scr->buffer_top=hgScrLine=ScreenNewLine();
    for (idx=0; idx<24; idx++) {
        fpScrLine=LINE_MEM_LOCK(hgScrLine);
        if (fpScrLine==NULL) return (NULL);    
        fpScrLine->prev=hgScrLineLast;
        hgScrLineTmp=ScreenNewLine();
        fpScrLine->next=hgScrLineTmp;
        hgScrLineLast=hgScrLine;
        LINE_MEM_UNLOCK(hgScrLine);
        hgScrLine=hgScrLineTmp;
    }        
    scr->screen_bottom=scr->buffer_bottom=hgScrLine;

    SetWindowPos(scr->hWnd,NULL,0,0,scr->cxChar * scr->width + FRAME_WIDTH,
         scr->cyChar * scr->height + FRAME_HEIGHT, SWP_NOMOVE|SWP_NOZORDER);
            
    GlobalUnlock(ScreenList);
    return(ScreenList);
}

void DeleteTopLine(SCREEN far *fpScr) {
    HSCREENLINE hsTop;
    SCREENLINE far *fpScrLine;
    
    fpScrLine=(SCREENLINE far *) LINE_MEM_LOCK(fpScr->buffer_top);
    if (fpScrLine==NULL) OutputDebugString("Hosed in DeleteTopLine.\r\n");
    hsTop=fpScrLine->next;
    LINE_MEM_FREE(fpScr->buffer_top);
    fpScr->buffer_top=hsTop;
    fpScrLine=(SCREENLINE far *) LINE_MEM_LOCK(fpScr->buffer_top);
    if (fpScrLine==NULL) OutputDebugString("Hosed in DeleteTopLine.\r\n");
    fpScrLine->prev=NULL;
    LINE_MEM_UNLOCK(fpScr->buffer_top);
    fpScr->numlines--;
}

int ScreenScroll(SCREEN far *fpScr) {
    HSCREENLINE hgScrLine,hScrollTop,hPrev,hNext;
    SCREENLINE far *fpScrLine,far *fpScrLineTmp;
    SCREENLINE far *fpPrev, far *fpNext;
    SCREENLINE far *fpScrollTop,far *fpScreenTop;
    BOOL bFullScreen=TRUE;
    HDC hDC;
    RECT rc;

    Edit_ClearSelection(fpScr);

    hScrollTop=(HSCREENLINE)GetScreenLineFromY(fpScr,fpScr->top);
    fpScrollTop=(SCREENLINE FAR *)GlobalLock(hScrollTop);
    fpScreenTop=(SCREENLINE FAR *)GlobalLock(fpScr->screen_top);

    if (fpScrollTop != fpScreenTop) {
        bFullScreen=FALSE;        
        GlobalUnlock(fpScr->screen_top);            
//        OutputDebugString("Not A FULL screen Scroll! ");
        wsprintf(strTmp,"Scroll: top=%d bottom=%d \r\n",fpScr->top,fpScr->bottom);
//        OutputDebugString(strTmp);
        rc.left=0;
        rc.right=fpScr->cxChar*fpScr->width;
        rc.top=fpScr->cyChar*(fpScr->top);
        rc.bottom=fpScr->cyChar*(fpScr->bottom+1);
        hPrev=fpScrollTop->prev;
        hNext=fpScrollTop->next;
        fpPrev=(SCREENLINE FAR *)GlobalLock(hPrev);
        fpPrev->next=hNext;        
        fpNext=(SCREENLINE FAR *)GlobalLock(hNext);
        fpNext->prev=hPrev;
        GlobalUnlock(hPrev);
        GlobalUnlock(hNext);
        hgScrLine=hScrollTop;
        GlobalUnlock(hScrollTop);
    } else {
        hgScrLine=ScreenNewLine(); 
        if (hgScrLine==NULL) return (0);
        fpScr->numlines++;                
    }    
        
    fpScrLine=(SCREENLINE far *) LINE_MEM_LOCK(hgScrLine);
    if (fpScrLine==NULL) return (0);

    fpScrLine->next = NULL;
    fpScrLine->prev = fpScr->buffer_bottom;
    fpScrLineTmp=(SCREENLINE far *) LINE_MEM_LOCK(fpScr->buffer_bottom);
    fpScrLineTmp->next=hgScrLine;
    LINE_MEM_UNLOCK(fpScr->buffer_bottom);
    fpScr->buffer_bottom=hgScrLine;
    fpScr->y++;
    if (fpScr->y >= fpScr->height) {
        fpScr->y = fpScr->height - 1;
        if (fpScrLine->prev == fpScr->screen_bottom) {
            fpScr->screen_bottom=hgScrLine;
            hDC=GetDC(fpScr->hWnd);
            if (bFullScreen)
                ScrollDC(hDC,0,-fpScr->cyChar,NULL,NULL,NULL,NULL);
            else 
                ScrollDC(hDC,0,-fpScr->cyChar,(LPRECT)&rc,(LPRECT)&rc,NULL,NULL);
            PatBlt(hDC,0,23*fpScr->cyChar,fpScr->width*fpScr->cxChar,fpScr->cyChar,
               WHITENESS);                            
                
            ReleaseDC(fpScr->hWnd,hDC);
        } else {
//            OutputDebugString(".");
            fpScr->screen_bottom=hgScrLine;
            InvalidateRect(fpScr->hWnd,NULL,TRUE);
            SendMessage(fpScr->hWnd,WM_PAINT,0,0L);
        }
    }
    LINE_MEM_UNLOCK(hgScrLine);

    if (fpScr->top==0) {
        hgScrLine=fpScr->screen_top;
        fpScrLine=LINE_MEM_LOCK(hgScrLine);
        fpScr->screen_top=fpScrLine->next;
        LINE_MEM_UNLOCK(hgScrLine);
    }
    if (fpScr->numlines == fpScr->maxlines) DeleteTopLine(fpScr);
    else {
        SetScrollRange(fpScr->hWnd,SB_VERT,0,fpScr->numlines,TRUE);
        SetScrollPos(fpScr->hWnd,SB_VERT,fpScr->numlines,TRUE);
        }
    return(1);
}


void DrawCursor(SCREEN far *fpScr) {
#ifdef NOT
    HDC hDC;
    char ch=95;

    hDC=GetDC(fpScr->hWnd);
    SelectObject(hDC,fpScr->ghSelectedFont);
    SetTextColor(hDC,RGB(255,255,255));
    TextOut(hDC,fpScr->Oldx*fpScr->cxChar,fpScr->Oldy*fpScr->cyChar,&ch,1);
    fpScr->Oldx=fpScr->x;
    fpScr->Oldy=fpScr->y;
    SetTextColor(hDC,RGB(0,0,0));
    TextOut(hDC,fpScr->x*fpScr->cxChar,fpScr->y*fpScr->cyChar,&ch,1);
    ReleaseDC(fpScr->hWnd,hDC);                
#endif    
}

int DrawTextScreen(RECT rcInvalid, SCREEN far * fpScr, HDC hDC) {
    HSCREENLINE hgScrLine,hgScrLineTmp;
    SCREENLINE far *fpScrLine;
    int x=0,y=0;
    int left=0,right=0;
    
#define YPOS (y*fpScr->cyChar)

//    hgScrLine=fpScr->screen_top;
    hgScrLine=GetScreenLineFromY(fpScr,fpScr->top);
//    wsprintf(strTmp,"{DTS: (%d)=%X }",fpScr->top,hgScrLine);
//    OutputDebugString(strTmp);

    for (y=fpScr->top; y<((fpScr->bottom)+1); y++) {
        fpScrLine=LINE_MEM_LOCK(hgScrLine);
        if (!fpScrLine) continue;
        if ((YPOS >= rcInvalid.top-(fpScr->cyChar)) && 
                (YPOS<=rcInvalid.bottom+(fpScr->cyChar))) {
            if (y<fpScr->top) y=fpScr->top;
            if (y>fpScr->bottom) y=fpScr->bottom;
            left=(int)(rcInvalid.left/fpScr->cxChar)-1;
            right=(int)(rcInvalid.right/fpScr->cxChar)+1;
            if (left<0) left=0;
            if (right>79) right=79;
            for (x=left; x <= right  ; x++) {
                if (SCR_isrev(fpScrLine->attrib[x])) {
                    SelectObject(hDC,fpScr->ghSelectedFont);                
                    SetTextColor(hDC,RGB(255,255,255));
                    SetBkColor(hDC,RGB(0,0,0));
                    }
                else if (SCR_isblnk(fpScrLine->attrib[x])) {
                    SelectObject(hDC,fpScr->ghSelectedFont);                
                    SetTextColor(hDC,RGB(255,0,0));
                    SetBkColor(hDC,RGB(255,255,255));
                    }
                else if (SCR_isundl(fpScrLine->attrib[x])) {
                    SetTextColor(hDC,RGB(255,0,0));
                    SetBkColor(hDC,RGB(255,255,255));
                    SelectObject(hDC,fpScr->ghSelectedULFont);
                } else {
                    SelectObject(hDC,fpScr->ghSelectedFont);
                    SetTextColor(hDC,RGB(0,0,0));
                    SetBkColor(hDC,RGB(255,255,255));
                }
                if (fpScrLine->text[x])
                    TextOut(hDC,x*fpScr->cxChar,y*fpScr->cyChar,&fpScrLine->text[x],1);
                }
        }                
        hgScrLineTmp=fpScrLine->next;
        LINE_MEM_UNLOCK(hgScrLine);
        hgScrLine=hgScrLineTmp;
    }            
    return(0);
}


long FAR PASCAL ScreenWndProc(hWnd, message, wParam, lParam)
HWND hWnd;                /* window handle           */
UINT message;                 /* type of message         */
WPARAM wParam;                  /* additional information          */
LPARAM lParam;                  /* additional information          */
{
    LPPOINT MMI;    
    SCREEN far *fpScr;                              
    HGLOBAL hgScr;
    HMENU hMenu;
    PAINTSTRUCT ps;    
    int x=0,
        y=0,
        ScrollPos,tmpScroll=0,
        idx,
        iTmp;
    HSCREENLINE hslLine,
                hslLine2;
    SCREENLINE far *fpScrLine;
    SCREENLINE far *fpScrLine2;
         
    switch (message) {

    case WM_COMMAND:
        switch (wParam) {               
            case IDM_BACKSPACE:
                hMenu=GetMenu(hWnd);
                CheckMenuItem(hMenu,IDM_BACKSPACE,MF_CHECKED);
                CheckMenuItem(hMenu,IDM_DELETE,MF_UNCHECKED);
                hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
                if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
	            fpScr=(SCREEN far *)GlobalLock(hgScr);
	            if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");
                SendMessage(fpScr->hwndTel,WM_MYSCREENCHANGEBKSP,VK_BACK,(HSCREEN)hgScr);                                
		        GlobalUnlock(hgScr);
                break;
            case IDM_DELETE:
                hMenu=GetMenu(hWnd);
                CheckMenuItem(hMenu,IDM_BACKSPACE,MF_UNCHECKED);
                CheckMenuItem(hMenu,IDM_DELETE,MF_CHECKED);
                hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
                if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
	            fpScr=(SCREEN far *)GlobalLock(hgScr);
	            if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");
                SendMessage(fpScr->hwndTel,WM_MYSCREENCHANGEBKSP,0x7f,(HSCREEN)hgScr);                                
		        GlobalUnlock(hgScr);
                break;    
            case IDM_FONT:
                ProcessFontChange(hWnd);
                break;
            case IDM_COPY:
                hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
                if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
                fpScr=(SCREEN far *)GlobalLock(hgScr);
                if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");
            
                Edit_Copy(hWnd);
                hMenu=GetMenu(hWnd);
                Edit_ClearSelection(fpScr);                
                GlobalUnlock(hgScr);
                break;
            case IDM_PASTE:
                Edit_Paste(hWnd);
                break;        
        }        
        break;

    case WM_CREATE:
//        OutputDebugString("WM_CREATE\r\n");
        SetWindowWord(hWnd,SCREEN_HANDLE,NULL);
        SetScrollRange(hWnd,SB_VERT,0,0,TRUE);
        ShowWindow(hWnd,SW_SHOW);
        for (iTmp=0; iTmp < 1920; iTmp++) cInvertedArray[iTmp]=0;
#ifdef FILE_DEBUG
        fh=OpenFile("d:\\debug.txt",&ofFile,OF_CREATE|OF_WRITE);
#endif
        break;
        
    case WM_VSCROLL:
        switch(wParam) {
            case SB_LINEDOWN:
                hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
                if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
                fpScr=(SCREEN far *)GlobalLock(hgScr);
                if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");

                if (fpScr->screen_bottom==fpScr->buffer_bottom) break;
                fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(fpScr->screen_top);
                hslLine=fpScrLine->next;
                LINE_MEM_UNLOCK(fpScr->screen_top);
                if (hslLine==NULL) break;
                fpScrLine2=(SCREENLINE far *)LINE_MEM_LOCK(fpScr->screen_bottom);
                hslLine2=fpScrLine2->next;
                LINE_MEM_UNLOCK(fpScr->screen_bottom);
                if (hslLine2==NULL) break;
                fpScr->screen_top=hslLine;
                fpScr->screen_bottom=hslLine2;
                ScrollWindow(hWnd,0,-(fpScr->cyChar),NULL,NULL);
                ScrollPos=GetScrollPos(fpScr->hWnd,SB_VERT);
                SetScrollPos(fpScr->hWnd,SB_VERT,ScrollPos+1,TRUE);
                GlobalUnlock(hgScr);
                break;
            case SB_LINEUP:
                hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
                if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
                fpScr=(SCREEN far *)GlobalLock(hgScr);
                if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");

                if (fpScr->screen_top==fpScr->buffer_top) break;
                fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(fpScr->screen_top);
                hslLine=fpScrLine->prev;
                LINE_MEM_UNLOCK(fpScr->screen_top);
                if (hslLine==NULL) break;
                fpScrLine2=(SCREENLINE far *)LINE_MEM_LOCK(fpScr->screen_bottom);
                hslLine2=fpScrLine2->prev;
                LINE_MEM_UNLOCK(fpScr->screen_bottom);
                if (hslLine2==NULL) break;
                fpScr->screen_top=hslLine;
                fpScr->screen_bottom=hslLine2;
                ScrollWindow(hWnd,0,(fpScr->cyChar),NULL,NULL);
                ScrollPos=GetScrollPos(fpScr->hWnd,SB_VERT);
                SetScrollPos(fpScr->hWnd,SB_VERT,ScrollPos-1,TRUE);
                GlobalUnlock(hgScr);
                break;
            case SB_PAGEDOWN:
                hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
                if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
                fpScr=(SCREEN far *)GlobalLock(hgScr);
                if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");
//                for (idx=0; idx<fpScr->height; idx++) 
//                    SendMessage(fpScr->hWnd,WM_VSCROLL,SB_LINEDOWN,NULL);

//#ifdef FAST
                for (idx=0; idx<24; idx++) {
                    if (fpScr->screen_bottom==fpScr->buffer_bottom) break;
                    fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(fpScr->screen_top);
                    hslLine=fpScrLine->next;
                    LINE_MEM_UNLOCK(fpScr->screen_top);
                    if (hslLine==NULL) break;
                    fpScrLine2=(SCREENLINE far *)LINE_MEM_LOCK(fpScr->screen_bottom);
                    hslLine2=fpScrLine2->next;
                    LINE_MEM_UNLOCK(fpScr->screen_bottom);
                    if (hslLine2==NULL) break;
                    fpScr->screen_top=hslLine;
                    fpScr->screen_bottom=hslLine2;
                    
                }
                ScrollWindow(hWnd,0,idx*(-fpScr->cyChar),NULL,NULL);
                ScrollPos=GetScrollPos(fpScr->hWnd,SB_VERT);
                SetScrollPos(fpScr->hWnd,SB_VERT,ScrollPos+idx,TRUE);
//#endif                
                GlobalUnlock(hgScr);
                break;
            case SB_PAGEUP:

                hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);                
                if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
                fpScr=(SCREEN far *)GlobalLock(hgScr);
                if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");
//                for (idx=0; idx<fpScr->height; idx++) 
//                    SendMessage(fpScr->hWnd,WM_VSCROLL,SB_LINEUP,NULL);

//#ifdef FAST
                for (idx=0; idx<fpScr->height; idx++) {
                    if (fpScr->screen_top==fpScr->buffer_top) break;
                    fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(fpScr->screen_top);
                    hslLine=fpScrLine->prev;
                    LINE_MEM_UNLOCK(fpScr->screen_top);
                    if (hslLine==NULL) break;
                    fpScrLine2=(SCREENLINE far *)LINE_MEM_LOCK(fpScr->screen_bottom);
                    hslLine2=fpScrLine2->prev;
                    LINE_MEM_UNLOCK(fpScr->screen_bottom);
                    if (hslLine2==NULL) break;
                    fpScr->screen_top=hslLine;
                    fpScr->screen_bottom=hslLine2;                    
                }
                ScrollWindow(hWnd,0,(idx)*(fpScr->cyChar),NULL,NULL);
                ScrollPos=GetScrollPos(fpScr->hWnd,SB_VERT);
                SetScrollPos(fpScr->hWnd,SB_VERT,ScrollPos-idx,TRUE);
//#endif                
                GlobalUnlock(hgScr);
                break;
            case SB_THUMBPOSITION:
                hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
                if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
                fpScr=(SCREEN far *)GlobalLock(hgScr);
                if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");
                ScrollPos=GetScrollPos(fpScr->hWnd,SB_VERT);
                tmpScroll=LOWORD(lParam);
                if ((ScrollPos-tmpScroll)>0) 
                    for (idx=0; idx<(ScrollPos-tmpScroll); idx++) 
                        SendMessage(fpScr->hWnd,WM_VSCROLL,SB_LINEUP,NULL);
                else
                    for (idx=0; idx<(-(ScrollPos-tmpScroll)); idx++) 
                        SendMessage(fpScr->hWnd,WM_VSCROLL,SB_LINEDOWN,NULL);
                 
                SetScrollPos(fpScr->hWnd,SB_VERT,tmpScroll,TRUE);
                GlobalUnlock(hgScr);
                break;                    
        case SB_THUMBTRACK:
                hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
                if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
                fpScr=(SCREEN far *)GlobalLock(hgScr);
                if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");
                ScrollPos=GetScrollPos(fpScr->hWnd,SB_VERT);
                tmpScroll=LOWORD(lParam);
                if ((ScrollPos-tmpScroll)>0) 
                    for (idx=0; idx<(ScrollPos-tmpScroll); idx++) 
                        SendMessage(fpScr->hWnd,WM_VSCROLL,SB_LINEUP,NULL);
                else
                    for (idx=0; idx<(-(ScrollPos-tmpScroll)); idx++) 
                        SendMessage(fpScr->hWnd,WM_VSCROLL,SB_LINEDOWN,NULL);
                 
                SetScrollPos(fpScr->hWnd,SB_VERT,tmpScroll,TRUE);
                GlobalUnlock(hgScr);
                break;                  default:
                break;
        }
        break;                    
                
    
    case WM_KEYDOWN:
        if (wParam==VK_INSERT) {
            if (GetKeyState(VK_SHIFT)<0) 
                PostMessage(hWnd,WM_COMMAND,IDM_PASTE,NULL);
            else if (GetKeyState(VK_CONTROL)<0)
                PostMessage(hWnd,WM_COMMAND,IDM_COPY,NULL);
            break;
        }        
        if ((wParam < 0x21)||(wParam > 0x28)) break;
        hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
        if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
        fpScr=(SCREEN far *)GlobalLock(hgScr);
        if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");
        switch (wParam) {
            case 0x22: /* Page up   */
                SendMessage(fpScr->hWnd,WM_VSCROLL,SB_PAGEUP,NULL);               
                break;
            case 0x21: /* Page down */
                SendMessage(fpScr->hWnd,WM_VSCROLL,SB_PAGEDOWN,NULL);
                break;
/* redo arrows to use ScrollDC() !! */
            case 0x28: /* line up   */
                SendMessage(fpScr->hWnd,WM_VSCROLL,SB_LINEUP,NULL);
                break;
            case 0x26: /* line down */
                SendMessage(fpScr->hWnd,WM_VSCROLL,SB_LINEDOWN,NULL);
                break;
        }
        UpdateWindow(hWnd);
        GlobalUnlock(hgScr);
        break;
        
    case WM_CHAR:
        hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
        if (hgScr == NULL) {
        	OutputDebugString("Hosed #1.\r\n");
        	break;
        }	
        fpScr=(SCREEN far *)GlobalLock(hgScr);
        if (fpScr == NULL) {
        	OutputDebugString("Hosed #2.\r\n");
        	break;
        }	
        SendMessage(fpScr->hwndTel,WM_MYSCREENCHAR,wParam,(HSCREEN)hgScr);
        GlobalUnlock(hgScr);
        break;

    case WM_SYSCHAR:
        if ((wParam=='c')||(wParam=='e'))
            return (DefWindowProc(hWnd, message, wParam, lParam));
        hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
        if (hgScr == NULL) {
        	OutputDebugString("Hosed #1.\r\n");
        	break;
        }	
        fpScr=(SCREEN far *)GlobalLock(hgScr);
        if (fpScr == NULL) {
        	OutputDebugString("Hosed #2.\r\n");
        	break;
        }
        SendMessage(fpScr->hwndTel,WM_MYSYSCHAR,wParam,(HSCREEN)hgScr);
        GlobalUnlock(hgScr);
        break;

    case WM_INITMENU:
        if (IsClipboardFormatAvailable(CF_TEXT))
            EnableMenuItem((HMENU) wParam,IDM_PASTE,MF_ENABLED);
        else EnableMenuItem((HMENU) wParam,IDM_PASTE,MF_GRAYED);
        if (bSelection) EnableMenuItem((HMENU) wParam,IDM_COPY,MF_ENABLED);
        else EnableMenuItem((HMENU) wParam,IDM_COPY,MF_GRAYED);
        break;
                              
    case WM_GETMINMAXINFO:
//        OutputDebugString("WM_GETMINMAX_INFO\r\n");
        hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
        if (hgScr == NULL) break;
        fpScr=(SCREEN far *)GlobalLock(hgScr);
        if (fpScr == NULL) OutputDebugString("Hosed in GetMinMaxInfo.\r\n");
        wsprintf(strTmp,"cx=%d cy=%d width=%d height=%d",fpScr->cxChar,fpScr->cyChar,fpScr->width,fpScr->height);
//        OutputDebugString(strTmp);
        MMI= (LPPOINT) lParam;
        MMI[1].x= fpScr->cxChar*fpScr->width  + FRAME_WIDTH;
        MMI[1].y= fpScr->cyChar*fpScr->height + FRAME_HEIGHT;
        MMI[4].x= fpScr->cxChar*fpScr->width  + FRAME_WIDTH;
        MMI[4].y= fpScr->cyChar*fpScr->height + FRAME_HEIGHT;
        GlobalUnlock(hgScr);
        break;
    
    case WM_LBUTTONDOWN: 
        if (bDoubleClick) Edit_TripleClick(hWnd,lParam);
        else Edit_LbuttonDown(hWnd,lParam);
        break;
    
    case WM_LBUTTONUP:
        Edit_LbuttonUp(hWnd,lParam);
        break;

    case WM_LBUTTONDBLCLK:
        bDoubleClick=TRUE;
        SetTimer(hWnd,TIMER_TRIPLECLICK,GetDoubleClickTime(),NULL);
        Edit_LbuttonDblclk(hWnd,lParam);
        break;

    case WM_TIMER:
        if (wParam==TIMER_TRIPLECLICK) bDoubleClick=FALSE;
        break;

    case WM_RBUTTONUP:
        hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
        if (hgScr == NULL) {
        	OutputDebugString("Hosed #1.\r\n");
        	break;
        }	
        fpScr=(SCREEN far *)GlobalLock(hgScr);
        if (fpScr == NULL) {
        	OutputDebugString("Hosed #2.\r\n");
        	break;
        }
        Edit_Copy(hWnd);
        Edit_ClearSelection(fpScr);                
        Edit_Paste(hWnd);
        GlobalUnlock(hgScr);
        break;
                            
    case WM_MOUSEMOVE:
        if (bMouseDown) Edit_MouseMove(hWnd,lParam);
        break;
        
    case WM_RBUTTONDOWN: {
        HSCREENLINE hgScrLine;
        SCREENLINE FAR *fpScrLine;
        
        hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
        if (hgScr == NULL) {
        	OutputDebugString("Hosed #1.\r\n");
        	break;
        }	
        fpScr=(SCREEN far *)GlobalLock(hgScr);
        if (fpScr == NULL) {
        	OutputDebugString("Hosed #2.\r\n");
        	break;
        }
        hgScrLine=fpScr->screen_top;
        fpScrLine=LINE_MEM_LOCK(hgScrLine);

        wsprintf(strTmp,"fp->x=%d fp->y=%d text=%s \r\n",fpScr->x,fpScr->y,fpScrLine->text);
//        OutputDebugString(strTmp);
        LINE_MEM_LOCK(hgScrLine);
        }        
        break;
            
    case WM_PAINT:        
        hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
        if (hgScr == NULL) {
        	OutputDebugString("Hosed #1.\r\n");
        	break;
        }	
        fpScr=(SCREEN far *)GlobalLock(hgScr);
        if (fpScr == NULL) {
        	OutputDebugString("Hosed #2.\r\n");
        	break;
        }
        BeginPaint (hWnd,&ps);
        SelectObject(ps.hdc,fpScr->ghSelectedFont);
        hslLine=fpScr->screen_bottom;
        if (hslLine==NULL) {
            OutputDebugString("screen_bottom is NULL.\r\n");
            EndPaint(hWnd,&ps);                
            GlobalUnlock(hgScr);
            break;
        }
        DrawTextScreen(ps.rcPaint, fpScr, ps.hdc);
        EndPaint(hWnd,&ps);                
        DrawCursor(fpScr);
        GlobalUnlock(hgScr);
        break;         

    case WM_CLOSE:
#ifdef FILE_DEBUG
        _lclose(fh);
#endif
        if (MessageBox(hWnd,"Terminate this connection?","WinTelnet",MB_OKCANCEL) == IDOK) {
            hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
            if (hgScr == NULL) OutputDebugString("Hosed #1.\r\n");
            fpScr=(SCREEN far *)GlobalLock(hgScr);
            if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");
            SendMessage(fpScr->hwndTel,WM_MYSCREENCLOSE,NULL,(HSCREEN)hgScr);
            return (DefWindowProc(hWnd, message, wParam, lParam));
        }    
        break;

    case WM_DESTROY:
        return (DefWindowProc(hWnd, message, wParam, lParam));
        break;

    case WM_ACTIVATE:
        if (wParam!=WA_INACTIVE) {
            hgScr=(HGLOBAL)GetWindowWord(hWnd,SCREEN_HANDLE);
            if (hgScr == NULL) return (DefWindowProc(hWnd, message, wParam, lParam));
            fpScr=(SCREEN far *)GlobalLock(hgScr);
            if (fpScr == NULL) OutputDebugString("Hosed #2.\r\n");
            if (fpScr->bAlert) {
                char strTitle[80];
                int idx;

                GetWindowText(hWnd,strTitle,80);
                if (strTitle[0] == ALERT) {
                    idx=lstrlen(strTitle);
                    strTitle[idx-2]=0;
                    SetWindowText(hWnd,&strTitle[2]);
                    fpScr->bAlert=FALSE;
                }
            }
            GlobalUnlock(hgScr);
        }  /* Allow control to drop down to DefWindowProc() */
        return (DefWindowProc(hWnd, message, wParam, lParam));
        break;

    default:              /* Passes it on if unproccessed    */
        return (DefWindowProc(hWnd, message, wParam, lParam));
    }

    return (NULL);
}

/**************************************************************************
*                                                                         *
*  Function:  ReportError(WORD)                                           *
*                                                                         *
*   Purpose:  To report an error that has occurred while allocating       *
*             memory for the CD struct, locking the memory or while       *
*             trying to load a resource string.                           *
*                                                                         *
*   Returns:  void                                                        *
*                                                                         *
*  Comments:                                                              *
*                                                                         *
*   History:  Date      Reason                                            *
*             --------  -----------------------------------               *
*                                                                         *
*             10/01/91  Created                                           *
*                                                                         *
**************************************************************************/
void FAR ReportError(WORD wErrorType){
   LPSTR lpszErrorMsg;

   switch( wErrorType )
      {
         case IDC_ALLOCFAIL:

            lpszErrorMsg=gszAllocErrorMsg;
            break;

         case IDC_LOCKFAIL:

            lpszErrorMsg=gszLockErrorMsg;
            break;

         case IDC_LOADSTRINGFAIL:

            lpszErrorMsg=gszLoadStrFail;
            break;

         default:    //let's hope we never get here!
            return;
      }

   MessageBox(NULL, (LPSTR)lpszErrorMsg, NULL, MB_OK);

   return;
}

void ScreenBell(SCREEN FAR *fpScr) {
    MessageBeep(MB_ICONEXCLAMATION);
    if (fpScr->hWnd != GetActiveWindow()) {
        char strTitle[80];
        int idx;

        FlashWindow(fpScr->hWnd,TRUE);
        if (!fpScr->bAlert) {
            strTitle[0]=ALERT;
            strTitle[1]=SPACE;
            GetWindowText(fpScr->hWnd,&strTitle[2],78);
            idx=lstrlen(strTitle);
            strTitle[idx]=SPACE;
            strTitle[idx+1]=ALERT;
            strTitle[idx+2]=0;
            SetWindowText(fpScr->hWnd,strTitle);
        }
        FlashWindow(fpScr->hWnd,FALSE);
        fpScr->bAlert=TRUE;
    }
}

void ScreenBackspace(SCREEN FAR * fpScr) {
    RECT rc;
    
//    hDC=GetDC(fpScr->hWnd);
//    SelectObject(hDC,fpScr->ghSelectedFont);
//    TextOut(hDC,fpScr->x*fpScr->cxChar,fpScr->y*fpScr->cyChar," ",1);
//    ReleaseDC(fpScr->hWnd,hDC);
    rc.left=fpScr->x*fpScr->cxChar;
    rc.right=((fpScr->x+1)*fpScr->cxChar);
    rc.top=(fpScr->cyChar*fpScr->y);    
    rc.bottom=(fpScr->cyChar*fpScr->y+1);
    InvalidateRect(fpScr->hWnd,&rc,TRUE);
    fpScr->x--;
    if (fpScr->x < 0) fpScr->x=0;
//    DrawCursor(fpScr);
    UpdateWindow(fpScr->hWnd);
    
}

void ScreenTab(SCREEN FAR *fpScr) {
    int num_spaces,idx;
    HSCREENLINE hgScrLine;
    SCREENLINE FAR *fpScrLine;
    int iTest=0;
    
    num_spaces = TAB_SPACES - (fpScr->x % TAB_SPACES);
    if ((fpScr->x + num_spaces) >= fpScr->width) {
       ScreenScroll(fpScr);
       num_spaces -= fpScr->width - fpScr->x;
       fpScr->x=0;
    }
//    hgScrLine=fpScr->buffer_bottom;
    hgScrLine=GetScreenLineFromY(fpScr,fpScr->y);
    if (hgScrLine==NULL) return;
    fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(hgScrLine);
    if (fpScrLine==NULL) return;
    for (idx=0; idx<num_spaces; idx++,fpScr->x++) {
        if (!fpScrLine->text[fpScr->x])
            iTest=1;
        if (iTest)
            fpScrLine->text[fpScr->x]=SPACE;
    }
//    fpScrLine->text[fpScr->x]=0;
    hDC=GetDC(fpScr->hWnd);
    SelectObject(hDC,fpScr->ghSelectedFont);
    TextOut(hDC,(fpScr->x-num_spaces)*fpScr->cxChar,fpScr->y*fpScr->cyChar,
        fpScrLine->text+fpScr->x-num_spaces,num_spaces);
    ReleaseDC(fpScr->hWnd,hDC);                
    LINE_MEM_UNLOCK(hgScrLine);
    DrawCursor(fpScr);
}

void ScreenCarriageFeed(SCREEN FAR *fpScr) {
    DrawCursor(fpScr);
    fpScr->x=0;    
}

