#include "windows.h"
#include "screen.h"
#define ScreenClearAttrib 0

char strTmp[256];

HSCREENLINE GetScreenLineFromY(SCREEN FAR *fpScr,int y){
    HSCREENLINE hgScrLine,hgScrLineTmp;
    SCREENLINE FAR *fpScrLine;
    int idx=0;

    if (y==24) return(fpScr->screen_bottom);    
    hgScrLine=fpScr->screen_top;
    for (idx=0; idx<24; idx++) {
        if (idx==y) return(hgScrLine);
        fpScrLine=LINE_MEM_LOCK(hgScrLine);
        if (fpScrLine==NULL) return (NULL);    
        hgScrLineTmp=fpScrLine->next;        
        LINE_MEM_UNLOCK(hgScrLine);
        hgScrLine=hgScrLineTmp;
    }
    return(NULL);
}    

HSCREENLINE ScreenClearLine(SCREEN FAR *fpScr,HSCREENLINE hgScrLine) {
    SCREENLINE FAR *fpScrLine;
    char *ta,*tt;
    int i;
      
    fpScrLine=LINE_MEM_LOCK(hgScrLine);
    ta=&fpScrLine->attrib[0];
    tt=&fpScrLine->text[0];
    for(i=0; i<=fpScr->allwidth; i++) {
        *ta++=ScreenClearAttrib;
        *tt++=' ';
      } /* end for */
    LINE_MEM_UNLOCK(hgScrLine);
    return(hgScrLine);
}
    
int ScreenClip(SCREEN FAR *fpScr, int *x1,int *y1,int *x2,int *y2,int *n,int *offset)
{
    if(*n>=0) {     /* set the requested right edge of the window */
        *x2=*x1+*n-1; 
        *y2=*y1; 
    } /* end if */
    if((*x1>fpScr->Rright) || (*y2<fpScr->Rtop))      /* check for invalid invalid left and bottom edges */
        return(-1);
    if(*x2>fpScr->Rright)     /* clip the right edge to the right edge of the virtual screen */
        *x2=fpScr->Rright;
    if(*y2>fpScr->Rbottom)     /* clip the bottom edge to the bottom edge of the virtual screen */
        *y2=fpScr->Rbottom;

    *x1-=fpScr->Rleft;       /* adjust to represent actual screen coor. */
    *x2-=fpScr->Rleft;
    *y1-=fpScr->Rtop; 
    *y2-=fpScr->Rtop;

    *offset=-*x1; 
    if(*offset<0)
        *offset=0;
    if(*x1<0)       /* clip left edge to top of virtual screen */
        *x1=0;
    if(*y1<0)       /* clip top edge to top of virtual screen */
        *y1=0;
    *n=*x2-*x1+1;   /* set the width of the clipped region */
    if((*n<=0) || (*y2-*y1<0)) /* check whether the clipped region really exists */
        return(-1);
    return(0);
}

int Screencdellines(SCREEN FAR *fpScr,int w,int top,int bottom,int n,int scrolled)
{
    int x1=0,
        x2=fpScr->maxwidth,
        tn=(-1),
        offset;

    if(ScreenClip(fpScr,&x1,&top,&x2,&bottom,&tn,&offset))
        return(-1);
    tn=bottom-top;
    if(tn<n) 
        n=tn;
//    RSdellines(w,top,bottom,n,scrolled);
    return(0);              /* I delete the whole thing! */
}

int Screencinslines(SCREEN FAR *fpScr,int w,int top,int bottom,int n,int scrolled)
{
    int x1=0,
        x2=fpScr->maxwidth,
        tn=(-1),
        offset;

    if(ScreenClip(fpScr,&x1,&top,&x2,&bottom,&tn,&offset))
        return(-1);
    tn=bottom-top;
    if(tn<n) 
        n=tn;
//    RSinslines(w,top,bottom,n,scrolled);
    return(0);
}

void ScreenCursorOn(SCREEN FAR *fpScr,int x,int y,int ForceMove)
{
    HDC hDC;
    char ch=95;

    hDC=GetDC(fpScr->hWnd);
    SelectObject(hDC,fpScr->ghSelectedFont);
    SetTextColor(hDC,RGB(0,0,0));
    SetBkMode(hDC,TRANSPARENT);
    TextOut(hDC,fpScr->x*fpScr->cxChar,fpScr->y*fpScr->cyChar,&ch,1);
    ReleaseDC(fpScr->hWnd,hDC);                

#ifdef NOT
    if(!VSIclip(&x,&y,&x2,&y2,&n,&offset)) 
        RScurson(w,x,y);
    else 
        if(ForceMove) {
            x2=fpScr->Rbottom-fpScr->Rtop;
            if(x2>=VSPBOTTOM)
                VSsetrgn(fpScrn,fpScr->Rleft,VSPBOTTOM-x2,fpScr->Rright,VSPBOTTOM);
            else {
                if(y>0) 
                    VSscrolforward(fpScrn,y);
                else     
                    VSscrolback(fpScrn,-y);
              } /* end else */
          } /* end if */
#endif          
}

void ScreenCursorOff(SCREEN FAR *fpScr)
{
    HDC hDC;
    char ch=95;

    hDC=GetDC(fpScr->hWnd);
    SelectObject(hDC,fpScr->ghSelectedFont);
    SetTextColor(hDC,RGB(255,255,255));
    SetBkMode(hDC,TRANSPARENT);
    TextOut(hDC,fpScr->x*fpScr->cxChar,fpScr->y*fpScr->cyChar,&ch,1);
    ReleaseDC(fpScr->hWnd,hDC);                
}

#ifdef NOT
void ScreenListndx(SCREENLINE FAR *ts,SCREENLINE FAR *as){
    int i;

    for(i=0; i<=VSPBOTTOM; i++) {
        hgScrLine=GetScreenLineFromY(fpScr,i);
        fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(hgScrLine);
        fpScr->attrst[i]=as;
        fpScr->linest[i]=ts;
        ts=ts->next;
        as=as->next;
        LINE_MEM_UNLOCK(hgScrLine);
      } /* end for */
}

void VSIscroff(void)
{
    VSline *tmp;
    int i;

    if(fpScr->linest[VSPBOTTOM)->next !=NULL) {
        for(i=0; i<=VSPBOTTOM; i++) {
            if(fpScr->linest[VSPBOTTOM)->next==fpScr->buftop)
                fpScr->buftop=fpScr->buftop->next;    /* if we are in old terr. loop */
            fpScr->scrntop=fpScr->scrntop->next;
            VSIlistndx(fpScr->scrntop,fpScr->attrst[1));
          }
      }
    else {
        for(i=0; i<=VSPBOTTOM; i++) {
            if((fpScr->numlines<fpScr->maxlines)&&(tmp=VSInewline()) !=NULL ) {
                    fpScr->linest[VSPBOTTOM)->next=tmp;            /* ADD A LINE */
                    tmp->prev=fpScr->linest[VSPBOTTOM);
                    fpScr->numlines++;
              }
            else {
                if(fpScr->linest[VSPBOTTOM)->next==NULL) {
                    fpScr->linest[VSPBOTTOM)->next=fpScr->buftop;   /* Make it circular */
                    fpScr->buftop->prev=fpScr->linest[VSPBOTTOM);
                  }
                if(fpScr->linest[VSPBOTTOM)->next==fpScr->buftop)
                    fpScr->buftop=fpScr->buftop->next;/* if we are in old terr. loop*/
              }
            fpScr->scrntop=fpScr->scrntop->next;
            VSIlistndx(fpScr->scrntop,fpScr->attrst[1));
          }
        RSbufinfo(fpScrn,fpScr->numlines,fpScr->Rtop,fpScr->Rbottom);
      } /* end else */
}

#endif

void ScreenELO(SCREEN FAR *fpScr,int s)
{
    char *tt,*ta;
    int i;
    HSCREENLINE hgScrLine;
    SCREENLINE FAR *fpScrLine;
    RECT rc;
            
/*  fpScrrapnow(&i,&j); */
    if(s<0) 
        s=fpScr->y;
    
    hgScrLine=GetScreenLineFromY(fpScr,s);
    fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(hgScrLine);
        
    ta=&fpScrLine->attrib[0];
    tt=&fpScrLine->text[0];
    for(i=0; i<=fpScr->allwidth; i++) {
        *ta++=ScreenClearAttrib;
        *tt++=' ';
      } /* end for */
    LINE_MEM_UNLOCK(hgScrLine);
    rc.left=0;
    rc.right=(fpScr->allwidth*fpScr->cxChar);
    rc.top=(fpScr->cyChar*s);    
    rc.bottom=(fpScr->cyChar*(s+1));
    InvalidateRect(fpScr->hWnd,&rc,TRUE);
}

void ScreenEraseScreen(SCREEN FAR *fpScr) 
{
    int i;
    int x1=0,y1=0,
        x2=fpScr->maxwidth,y2=VSPBOTTOM,
        n=(-1),
        offset;
            
    for(i=0; i<=VSPBOTTOM; i++)
        ScreenELO(fpScr,i);
#ifdef LATER
    if(!VSIclip(&x1,&y1,&x2,&y2,&n,&offset)) 
        RSerase(fpScrn,x1,y1,x2,y2);
#endif
    InvalidateRect(fpScr->hWnd,NULL,TRUE);
    UpdateWindow(fpScr->hWnd);
}

void ScreenTabClear(SCREEN FAR *fpScr)
{
    int x=0;

    while(x<=fpScr->allwidth) {
        fpScr->tabs[x]=' ';
        x++;
      } /* end while */
}

void ScreenTabInit(SCREEN FAR *fpScr)
{
    int x=0;

    ScreenTabClear(fpScr);

    while(x<=fpScr->allwidth) { 
        fpScr->tabs[x]='x';
        x+=8;
      } /* end while */
    fpScr->tabs[fpScr->allwidth]='x';
}

void ScreenReset(SCREEN FAR *fpScr)
{
    fpScr->top=0;
    fpScr->bottom=VSPBOTTOM;
    fpScr->parmptr=0;
    fpScr->escflg=0;
    fpScr->DECAWM=0;
    fpScr->DECCKM=0;
    fpScr->DECPAM=0;
/*  fpScr->DECORG=0;     */
/*  fpScr->Pattrib=-1;   */
    fpScr->IRM=0;
    fpScr->attrib=0;
    fpScr->x=0;
    fpScr->y=0;
//    fpScr->charset=0;
    ScreenEraseScreen(fpScr);
    ScreenTabInit(fpScr);
//    set_vtwrap(fpScrn,fpScr->DECAWM);     /* QAK - 7/27/90: added because resetting the virtual screen's wrapping flag doesn't reset telnet window's wrapping */
}


void ScreenListMove(HSCREENLINE hTD,HSCREENLINE hBD,HSCREENLINE hTI,HSCREENLINE hBI)
{
    HSCREENLINE hTmpLine;
    SCREENLINE FAR *TD,FAR *BD,FAR *TI,FAR *BI,FAR *tmpLine;
    
//    OutputDebugString("ScreenListMove");
    TD= (SCREENLINE FAR *)GlobalLock(hTD);
    BD= (SCREENLINE FAR *)GlobalLock(hBD);
    TI= (SCREENLINE FAR *)GlobalLock(hTI);
    BI= (SCREENLINE FAR *)GlobalLock(hBI);
    
    if(TD->prev!=NULL) {
        hTmpLine=TD->prev;
        tmpLine=(SCREENLINE FAR *)GlobalLock(hTmpLine);
        tmpLine->next=BD->next;    /* Maintain circularity */
        GlobalUnlock(hTmpLine);
    }        
    if(BD->next!=NULL) {
        hTmpLine=BD->next;
        tmpLine=(SCREENLINE FAR *)GlobalLock(hTmpLine);
        tmpLine->prev=TD->prev;
        GlobalUnlock(hTmpLine);
    }
    TD->prev=hTI;                    /* Place the node in its new home */
    BD->next=hBI;
    if(TI!=NULL) 
        TI->next=hTD;                /* Ditto prev->prev */
    if(BI!=NULL) 
        BI->prev=hBD;
        
    GlobalUnlock(hTD);
    GlobalUnlock(hBD);
    GlobalUnlock(hTI);
    GlobalUnlock(hBI);            
}

void ScreenDelLines(SCREEN FAR *fpScr,int n,int s)
{
    HSCREENLINE hBI,hTI,hTD,hBD;
    SCREENLINE FAR *TI;
    
    if(s<0) 
        s=fpScr->y;
    if(s+n-1>fpScr->bottom) 
        n=fpScr->bottom -s +1;

    hTD=GetScreenLineFromY(fpScr,s);
    hBD=GetScreenLineFromY(fpScr,s+n-1);
    hTI=GetScreenLineFromY(fpScr,fpScr->bottom);
    TI=(SCREENLINE FAR *)GlobalLock(hTI);
    hBI=TI->next;
    GlobalUnlock(hTI);

    if(hTI!=hBD)
        ScreenListMove(hTD,hBD,hTI,hBI);
    
    /* NEED TO BLANK OUT n lines from bottom down */ /*IMPORTANT TODO */        
}

void ScreenInsertLine(SCREEN FAR *fpScr,int s) {
    HSCREENLINE hgScrLine,hgScrLineNew,hgScrLineTmp;
    HSCREENLINE hLine,hTI,hTD,hBD;
    SCREENLINE FAR *fpScrLine,*fpScrLineNew,*fpLine;
    int idx=0;
    RECT rc;
    HDC hDC;
 
    if(s<0) s=fpScr->y;

    hgScrLine=GetScreenLineFromY(fpScr,s);
    fpScrLine=(SCREENLINE FAR *)GlobalLock(hgScrLine);
    
    hgScrLineNew=ScreenNewLine();
    fpScrLineNew=(SCREENLINE FAR *)LINE_MEM_LOCK(hgScrLineNew);
    fpScrLineNew->prev=fpScrLine->prev;
    fpScrLineNew->next=hgScrLine;
    fpScrLine->prev=hgScrLineNew;
    LINE_MEM_UNLOCK(hgScrLineNew);
    LINE_MEM_UNLOCK(hgScrLine);
//    hgScrLine=hgScrLineNew;
    fpScr->numlines++;
    if (fpScr->numlines == fpScr->maxlines) DeleteTopLine(fpScr);
    fpScr->y--;        

    if (fpScr->y <=0) {
        fpScr->y=0;
        fpScr->screen_top=hgScrLine;
    }
//    ScreenScroll(fpScr);

    if (s==fpScr->top) { /* top of screen */
        hDC=GetDC(fpScr->hWnd);
        
        rc.left=0;
        rc.right=fpScr->cxChar*fpScr->width;
        rc.top=fpScr->cyChar*(fpScr->top);
        rc.bottom=fpScr->cyChar*(fpScr->bottom+1);        
        ScrollDC(hDC,0,fpScr->cyChar,(LPRECT)&rc,(LPRECT)&rc,NULL,NULL);
//        ScrollDC(hDC,0,(fpScr->cyChar),NULL,NULL,NULL,NULL);
        PatBlt(hDC,0,fpScr->top*fpScr->cyChar,fpScr->width*fpScr->cxChar,(fpScr->cyChar),
               WHITENESS);
        ReleaseDC(fpScr->hWnd,hDC);    
    } else {        
        rc.left=0;
        rc.right=(fpScr->width*fpScr->cyChar);
        rc.top=(fpScr->top*fpScr->cyChar);
        rc.bottom=((fpScr->bottom+1)*fpScr->cyChar);
        InvalidateRect(fpScr->hWnd,&rc,TRUE);
        SendMessage(fpScr->hWnd,WM_PAINT,NULL,NULL);
    }    
}        

void ScreenInsLines(SCREEN FAR *fpScr,int n,int s)
{
    HSCREENLINE hgScrLine,hgScrLineNew,hgScrLineTmp;
    HSCREENLINE hLine,hTI,hTD,hBD;
    SCREENLINE FAR *fpScrLine,*fpScrLineNew,*fpLine;
    int idx=0;
    RECT rc;
    HDC hDC;
 
    wsprintf(strTmp,"ScreenInsLine (n=%d s=%d)",n,s);   
//    OutputDebugString(strTmp);

    if(s<0) s=fpScr->y;
    if(s+n-1>fpScr->bottom) 
        n=fpScr->bottom -s +1;

    hLine=GetScreenLineFromY(fpScr,s);
    fpLine=(SCREENLINE FAR *)GlobalLock(hLine);
    hTI=fpLine->prev;
    hTD=GetScreenLineFromY(fpScr,fpScr->bottom-n+1);
    hBD=GetScreenLineFromY(fpScr,fpScr->bottom);
    
    if(hTD!=hLine)
        ScreenListMove(hTD,hBD,hTI,hLine);
       
    hgScrLine=GetScreenLineFromY(fpScr,s);
    for (idx=0; idx<n; idx++) {
        fpScrLine=(SCREENLINE FAR *)LINE_MEM_LOCK(hgScrLine);
        hgScrLineNew=ScreenNewLine();
        fpScrLineNew=(SCREENLINE FAR *)LINE_MEM_LOCK(hgScrLineNew);
        fpScrLineNew->prev=fpScrLine->prev;
        fpScrLineNew->next=hgScrLine;
        fpScrLine->prev=hgScrLineNew;
        LINE_MEM_UNLOCK(hgScrLineNew);
        LINE_MEM_UNLOCK(hgScrLine);
        hgScrLine=hgScrLineNew;
        fpScr->numlines++;
        if (fpScr->numlines == fpScr->maxlines) DeleteTopLine(fpScr);
        fpScr->y--;        
    }
    if (fpScr->y <=0) {
        fpScr->y=0;
        fpScr->screen_top=hgScrLine;
    }
    if (s==0) { /* top of screen */
        hDC=GetDC(fpScr->hWnd);
        ScrollDC(hDC,0,(fpScr->cyChar*n),NULL,NULL,NULL,NULL);
        PatBlt(hDC,0,0,fpScr->width*fpScr->cxChar,n*(fpScr->cyChar),
               WHITENESS);
        ReleaseDC(fpScr->hWnd,hDC);    
    } else {        
        rc.left=0;
        rc.right=(fpScr->width*fpScr->cyChar);
        rc.top=(fpScr->top*fpScr->cyChar);
        rc.bottom=((fpScr->bottom+1)*fpScr->cyChar);
        InvalidateRect(fpScr->hWnd,&rc,TRUE);
        SendMessage(fpScr->hWnd,WM_PAINT,NULL,NULL);
    }    
}        
    

#ifdef OLD
    if(s<0) 
        s=fpScr->y;
    if(s+n-1>fpScr->bottom) 
        n=fpScr->bottom -s +1;
    ts=fpScr->linest[0)->prev;
    BI=fpScr->linest[s);
    TI=BI->prev;
    TD=fpScr->linest[fpScr->bottom-n+1);
    BD=fpScr->linest[fpScr->bottom);
    itt=TD;
    if(TD!=BI) 
        VSIlistmove(TD,BD,TI,BI);
    if(s==0 || n>VSPBOTTOM) 
        as=fpScr->attrst[fpScr->bottom-n+1);
    else 
        as=fpScr->attrst[0);
    BI=fpScr->attrst[s);
    TI=BI->prev;
    TD=fpScr->attrst[fpScr->bottom-n+1);
    BD=fpScr->attrst[fpScr->bottom);
    if(TD!=BI && TI!=BD)
        VSIlistmove(TD,BD,TI,BI);
    ita=TD;
    for(i=0; i<n; i++) {
        tt=itt->text;
        ta=ita->text;
        for(j=0; j<=fpScr->allwidth; j++) {
            *tt++=' ';
            *ta++=VSIclrattrib;
          } /* end for */
        itt=itt->next;
        ita=ita->next;
      } /* end for */
    fpScr->scrntop=ts->next;
    if(attop) 
        fpScr->vistop=fpScr->scrntop;
    VSIlistndx(ts->next,as);
    VSIcinslines(fpScrn,s,fpScr->bottom,n,-1);  /* Destroy selection area if this is called tooo */
#endif    

void ScreenIndex(SCREEN FAR * fpScr)
{
    if(fpScr->y==fpScr->bottom)
        ScreenScroll(fpScr);
    else
        fpScr->y++;    
}

void ScreenWrapNow(SCREEN FAR *fpScr,int *xp,int *yp)
{
    if(fpScr->x > fpScr->maxwidth) {
        fpScr->x=0;
        ScreenIndex(fpScr);
      } /* end if */
    *xp=fpScr->x;
    *yp=fpScr->y;
}

void ScreenEraseToEOL(SCREEN FAR *fpScr)
{
    char *tt,*ta;
    int x1=fpScr->x,y1=fpScr->y,
        x2=fpScr->maxwidth,y2=fpScr->y,
        n=(-1),
        offset;
    int i;
    HSCREENLINE hgScrLine;
    SCREENLINE FAR *fpScrLine;
    RECT rc;    
        
    ScreenWrapNow(fpScr,&x1,&y1);
    y2=y1;
    wsprintf(strTmp,"[EraseEOL:%d]",y2);
//    OutputDebugString(strTmp);
    hgScrLine=GetScreenLineFromY(fpScr,y2);
    fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(hgScrLine);
    ta=&fpScrLine->attrib[x1];
    tt=&fpScrLine->text[x1];
    for(i=fpScr->width-x1+1; i>0; i--) {
        *ta++=ScreenClearAttrib;
        *tt++=' ';
      } /* end for */
    LINE_MEM_UNLOCK(hgScrLine);      
#ifdef NOT
    if(!VSIclip(&x1,&y1,&x2,&y2,&n,&offset)) 
        RSerase(fpScrn,x1,y1,x2,y2);
#endif
    rc.left=x1*fpScr->cxChar;
    rc.right=(fpScr->width*fpScr->cxChar);
    rc.top=(fpScr->cyChar*y1);    
    rc.bottom=(fpScr->cyChar*(y1+1));
    InvalidateRect(fpScr->hWnd,&rc,TRUE);
    UpdateWindow(fpScr->hWnd);
}

#ifdef LATER
void ScreenDelChars(SCREEN FAR *fpScr,int x)
{
    int i;
    int x1=fpScr->x,y1=fpScr->y,
        x2=fpScr->maxwidth,y2=fpScr->y,
        n=(-1),
        offset;
    char *tempa,*temp;

    ScreenWrapNow(&x1,&y1);
    y2=y1;
    if(x>fpScr->maxwidth) 
        x=fpScr->maxwidth;
    tempa=fpScr->attrst[y1]->text;
    temp=fpScr->linest[y1]->text;
    for(i=x1; i<=fpScr->maxwidth-x; i++) {
        temp[i]=temp[x+i];
        tempa[i]=tempa[x+i];
      } /* end for */
    for(i=fpScr->maxwidth-x+1; i<=fpScr->allwidth; i++) {
        temp[i]=' ';
        tempa[i]=VSIclrattrib;
      } /* end for */
    if(!VSIclip(&x1,&y1,&x2,&y2,&n,&offset))
        if(fpScr->VSIDC)
            RSdelchars(fpScrn,x1,y1,x);
        else
            RSdraw(fpScrn,x1,y1,fpScr->attrib,n,&fpScr->linest[y1]->text[x1]);
}

#endif

void ScreenRevIndex(SCREEN FAR *fpScr)
{
    HSCREENLINE hgScrLine,hTopLine;
    SCREENLINE FAR *fpScrLine;
    
    hgScrLine=GetScreenLineFromY(fpScr,fpScr->y);
    hTopLine=GetScreenLineFromY(fpScr,fpScr->top);
    
    if(hgScrLine==hTopLine) 
        ScreenInsertLine(fpScr,fpScr->y);
    else
        fpScr->y--;
}


void ScreenEraseToBOL(SCREEN FAR *fpScr)
{
    char *tt,*ta;
    int x1=0,y1=fpScr->y,
        x2=fpScr->x,y2=fpScr->y,
        n=(-1),
        offset;
    register int i;
    HSCREENLINE hgScrLine;
    SCREENLINE FAR *fpScrLine;
    
    hgScrLine=GetScreenLineFromY(fpScr,fpScr->y);
    fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(hgScrLine);

    ScreenWrapNow(fpScr,&x2,&y1);
    y2=y1;
    ta=&fpScrLine->attrib[0];
    tt=&fpScrLine->text[0];
    for(i=0;i<=x2; i++) {
        *ta++=ScreenClearAttrib;
        *tt++=' ';
      } /* end for */
    LINE_MEM_UNLOCK(hgScrLine);      
#ifdef NOT      
    if(!VSIclip(&x1,&y1,&x2,&y2,&n,&offset)) 
        RSerase(fpScrn,x1,y1,x2,y2);
#endif        
}

void ScreenEraseLine(SCREEN FAR *fpScr,int s)
{
    char *tt,*ta;
    int x1=0,y1=s,
        x2=fpScr->width,y2=s,
        n=(-1),
        offset;
    register int i;
    HSCREENLINE hgScrLine;
    SCREENLINE FAR *fpScrLine;
    RECT rc;
    
    if(s<0) {
        ScreenWrapNow(fpScr,&x1,&y1);
        s=y2=y1;
        x1=0;
      } /* end if */

    hgScrLine=GetScreenLineFromY(fpScr,y1);
    fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(hgScrLine);
      
    ta=&fpScrLine->attrib[0];
    tt=&fpScrLine->text[0];
    for(i=0; i<=fpScr->width; i++) {
        *ta++=ScreenClearAttrib;
        *tt++=' ';
      } /* end for */
    LINE_MEM_UNLOCK(hgScrLine);      
    rc.left=0;
    rc.right=(fpScr->width*fpScr->cxChar);
    rc.top=(fpScr->cyChar*y1);    
    rc.bottom=(fpScr->cyChar*(y1+1));
    InvalidateRect(fpScr->hWnd,&rc,TRUE);
    SendMessage(fpScr->hWnd,WM_PAINT,NULL,NULL);

#ifdef NOT      
    if(!VSIclip(&x1,&y1,&x2,&y2,&n,&offset)) 
        RSerase(fpScrn,x1,y1,x2,y2);
#endif        
}

void ScreenEraseToEndOfScreen(SCREEN FAR *fpScr)
{
    register int i;
    int x1=0,y1=fpScr->y+1,
        x2=fpScr->width,y2=VSPBOTTOM,
        n=(-1),
        offset;

    ScreenWrapNow(fpScr,&x1,&y1);
    y1++;
    x1=0;
    i=y1;
    ScreenEraseToEOL(fpScr);
    while(i<=VSPBOTTOM) {
        ScreenELO(fpScr,i);
        ScreenEraseLine(fpScr,i);
        i++;
      } /* end while */
#ifdef NOT
    if(fpScr->y < VSPBOTTOM && (fpScr->x <= fpScr->maxwidth))
        if(!VSIclip(&x1,&y1,&x2,&y2,&n,&offset)) 
            RSerase(fpScrn,x1,y1,x2,y2);
#endif            
}

#ifdef LATER
void VSIebos(void)
{
    register int i;
    int x1,y1,
        x2=fpScr->maxwidth,y2,
        n=(-1),
        offset;

    fpScrrapnow(&x1,&y1);
    y2=y1-1;
    x1=0;
    y1=0;
    VSIebol();
    i=0;
    while(i<(y2+1)) {           /* Equiv of fpScr->y */
        VSIelo(i);
        i++;
      } /* end while */
    if(y2>=0)                       /* Equiv of fpScr->y>0 */
        if(!VSIclip(&x1,&y1,&x2,&y2,&n,&offset)) 
            RSerase(fpScrn,x1,y1,x2,y2);
}
#endif

void ScreenRange(SCREEN FAR *fpScr)               /* check and resolve range errors on x and y */
{
    int wrap=0;

    if(fpScr->DECAWM)
        wrap=1;
    if(fpScr->x<0)
        fpScr->x=0;
    if(fpScr->x>(fpScr->maxwidth+wrap))
        fpScr->x=fpScr->maxwidth+wrap;
    if(fpScr->y<0)
        fpScr->y=0;
    if(fpScr->y>VSPBOTTOM)
        fpScr->y=VSPBOTTOM;
}

#ifdef LATER
void ScreenSendPos(SCREEN FAR *fpScr)        /* send cursor position to host */
{
    char tempbuf[15];
    int x=fpScr->x,
        y=fpScr->y;

    if(x > fpScr->maxwidth) {
        x=0;
        y++;
      } /* end if */
    if(y>VSPBOTTOM) 
        y=VSPBOTTOM;
    sprintf(tempbuf,"\033[%d;%dR",y+1,x+1);
    netwrite(fpScr->pnum,tempbuf,strlen(tempbuf));
}

void ScreenSendStat(SCREEN FAR *fpScr)       /* send OK status back to host */
{
    netwrite(fpScr->pnum,"\033[0n",4);
}

void ScreenSendIdent(SCREEN FAR *fpScr)      /* send terminal capabilities to host */
{
    netwrite(fpScr->pnum,"\033[?6c",5);       /* GPO & AVO options supported */
}

#endif

void ScreenAlign(SCREEN FAR *fpScr)  /* vt100 alignment, fill screen with 'E's */
{
    char *tt;
    register int i,j;
    HSCREENLINE hgScrLine,hgScrLineTmp;
    SCREENLINE FAR *fpScrLine;
    
    hgScrLine=GetScreenLineFromY(fpScr,fpScr->top);
    ScreenEraseScreen(fpScr);        /* erase the screen */

    for(j=0; j<VSPBOTTOM; j++) {
        fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(hgScrLine);
        tt=&fpScrLine->text[0];
        for(i=0; i<=fpScr->maxwidth; i++)
            *tt++='E';
        hgScrLineTmp=fpScrLine->next;            
        LINE_MEM_UNLOCK(hgScrLine);
        hgScrLine=hgScrLineTmp;    
        
      } /* end for */
    LINE_MEM_UNLOCK(hgScrLine);      
//    ScreenRedraw(fpScrn,0,0,(fpScr->Rright-fpScr->Rleft),(fpScr->Rbottom-fpScr->Rtop));
}

/* reset all the ANSI parameters back to the default state */
void ScreenApClear(SCREEN FAR *fpScr)
{
    for(fpScr->parmptr=5; fpScr->parmptr>=0; fpScr->parmptr--)
        fpScr->parms[fpScr->parmptr]=-1;
    fpScr->parmptr=0;
}

void ScreenSetOption(SCREEN FAR *fpScr,int toggle) {
//    int WindWidth=(fpScr->Rright - fpScr->Rleft);

    switch(fpScr->parms[0]) {
        case -2:
            switch(fpScr->parms[1]) {
                case 1:     /* set/reset cursor key mode */
                    fpScr->DECCKM=toggle;
                    break;

#ifdef NOT_SUPPORTED
                case 2:     /* set/reset ANSI/vt52 mode */
                    break;
#endif

                case 3:     /* set/reset column mode */
                    fpScr->x=fpScr->y=0;      /* Clear the screen, mama! */
                    ScreenEraseScreen(fpScr);
                    if(toggle)      /* 132 column mode */
                        fpScr->maxwidth=fpScr->allwidth;
                    else
                        fpScr->maxwidth=79;
//                    OutputDebugString("BAD Program! Trying to call RSMarginInfo.\r\n");
//                    RSmargininfo(fpScrn,fpScr->maxwidth-WindWidth,fpScr->Rleft);
                    break;

#ifdef NOT_SUPPORTED
                case 4:     /* set/reset scrolling mode */
                case 5:     /* set/reset screen mode */
                case 6:     /* set/rest origin mode */
                    fpScr->DECORG = toggle;
                    break;
#endif

                case 7:     /* set/reset wrap mode */
                    fpScr->DECAWM=toggle;
//                    set_vtwrap(fpScrn,fpScr->DECAWM);     /* QAK - 7/27/90: added because resetting the virtual screen's wrapping flag doesn't reset telnet window's wrapping */
                    break;

#ifdef NOT_SUPPORTED
                case 8:     /* set/reset autorepeat mode */
                case 9:     /* set/reset interlace mode */
                    break;
#endif

                default:
                    break;
            } /* end switch */
            break;

        case 4:
            fpScr->IRM=toggle;
            break;

        default:
            break;

    } /* end switch */
}

#ifdef NOT
void ScreenTab(SCREEN FAR *fpScr)
{
    if(fpScr->x>=fpScr->maxwidth)
        fpScr->x=fpScr->maxwidth;
    fpScr->x++;
    while((fpScr->tabs[fpScr->x] != 'x') && (fpScr->x < fpScr->maxwidth)) 
        fpScr->x++;
}
#endif
int ScreenInsChar(SCREEN FAR *fpScr,int x)
{
    int i,j;
    char *tempa,*temp;
    HSCREENLINE hgScrLine;
    SCREENLINE FAR *fpScrLine;
    RECT rc;
        
//    ScreenWrapNow(&i,&j);  /* JEM- Why is this here? comment out for now */

//    OutputDebugString("OOPS-InsChar!");
    hgScrLine=GetScreenLineFromY(fpScr,fpScr->y);
    fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(hgScrLine);
    if (fpScrLine==NULL) return (-1);

    for(i=fpScr->maxwidth-x; i>=fpScr->x; i--) {
        fpScrLine->text[x+i]=fpScrLine->text[i];
        fpScrLine->attrib[x+i]=fpScrLine->attrib[i];
      } /* end for */
    for(i=fpScr->x; i<fpScr->x+x; i++) {
        fpScrLine->text[i]=' ';
        fpScrLine->attrib[i]=ScreenClearAttrib;
      } /* end for */
    LINE_MEM_UNLOCK(hgScrLine);  
    rc.left= (fpScr->cxChar*x);
    rc.right= ((fpScr->cxChar*x)+(fpScr->cxChar*(x+fpScr->x)));
    rc.top=(fpScr->cyChar*((fpScr->y)-1));    
    rc.bottom=(fpScr->cyChar*(fpScr->y));
    InvalidateRect(fpScr->hWnd,&rc,TRUE);
    SendMessage(fpScr->hWnd,WM_PAINT,NULL,NULL);
}

void ScreenInsString(SCREEN FAR *fpScr,int len,char *start)
{
    HSCREENLINE hgScrLine;
    SCREENLINE FAR *fpScrLine;
    int idx;
    RECT rc;
    
    if(fpScr->VSIDC) return;  /* Call RSinsstring which does nothing? */
    
    hgScrLine=GetScreenLineFromY(fpScr,fpScr->y);
    fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(hgScrLine);
    if (fpScrLine==NULL) return;

    for(idx=fpScr->x; idx<fpScr->x+len; idx++) {
        fpScrLine->text[idx]=start[idx];
        fpScrLine->attrib[idx]=fpScr->attrib;
    } /* end for */
    LINE_MEM_UNLOCK(hgScrLine);
    rc.left= (fpScr->cxChar*fpScr->x);
    rc.right= ((fpScr->cxChar*fpScr->x)+(fpScr->cxChar*(fpScr->x+len)));
    rc.top=(fpScr->cyChar*(fpScr->y));    
    rc.bottom=(fpScr->cyChar*(fpScr->y+1));    
    
    InvalidateRect(fpScr->hWnd,&rc,TRUE);
    SendMessage(fpScr->hWnd,WM_PAINT,NULL,NULL);
}

#ifdef OLD
void VSIinsstring(int len,char *start)
{
    if(fpScr->VSIDC)
        RSinsstring(fpScrn,fpScr->x-len,fpScr->y,fpScr->attrib,len,start);
    else
        RSdraw(fpScrn,fpScr->x-len,fpScr->y,fpScr->attrib,fpScr->maxwidth-fpScr->x+len+1,start);
}
#endif

void ScreenSaveCursor(SCREEN FAR *fpScr)
{
    fpScr->Px=fpScr->x;
    fpScr->Py=fpScr->y;
    fpScr->Pattrib=fpScr->attrib;
}

void ScreenRestoreCursor(SCREEN FAR *fpScr)
{
    fpScr->x=fpScr->Px;
    fpScr->y=fpScr->Py;
    ScreenRange(fpScr);
//    fpScr->attrib=VSinattr(fpScr->Pattrib);
}

void ScreenDraw(SCREEN FAR *fpScr,int x,int y,int a,int len,char *c) {
    int x2,y2,
        offset;
    HSCREENLINE hgScrLine,hgScrLineTmp;
    SCREENLINE FAR *fpScrLine;
    int idx;
    RECT rc;

    if (fpScr->screen_bottom != fpScr->buffer_bottom) {
        fpScr->screen_bottom=fpScr->buffer_bottom;
        hgScrLine=fpScr->screen_bottom;
        for (idx=0; idx < fpScr->height; idx++) {
            fpScrLine=LINE_MEM_LOCK(hgScrLine);
            if (fpScrLine==NULL)
                return;
            hgScrLineTmp=fpScrLine->prev;
            LINE_MEM_UNLOCK(hgScrLine);
            hgScrLine=hgScrLineTmp;
        }
        fpScr->screen_top=hgScrLine;
        InvalidateRect(fpScr->hWnd,NULL,TRUE);
        SetScrollPos(fpScr->hWnd,SB_VERT,fpScr->numlines-fpScr->height,TRUE);
    }        
    hgScrLine=GetScreenLineFromY(fpScr,y);  
    fpScrLine=(SCREENLINE far *)LINE_MEM_LOCK(hgScrLine);
    if (fpScrLine==NULL) {
        OutputDebugString("fpScrLine==NULL");
        return;
        }
    
//    strncpy(fpScrLine->text,c,len);
//    wsprintf(strTmp,"[x=%d len=%d c=%s]",x,len,c);
//    OutputDebugString(strTmp);

    for(idx=x; idx<(x+len); idx++) {
        fpScrLine->text[idx]=c[idx-x];
        fpScrLine->attrib[idx-x]=a;
    } /* end for */
    LINE_MEM_UNLOCK(hgScrLine);

//    if(!VSIclip(&x,&y,&x2,&y2,&len,&offset))
//        RSdraw(fpScrn,x,y,a,len,c+offset);
    rc.left= (fpScr->cxChar*x);
//    rc.right= ((fpScr->cxChar*x)+(fpScr->cxChar*(x+len)));
    rc.right= (fpScr->cxChar*(x+len));
    rc.top=(fpScr->cyChar*(fpScr->y));    
    rc.bottom=(fpScr->cyChar*((fpScr->y)+1));
//    DrawCursor(fpScr);
    InvalidateRect(fpScr->hWnd,&rc,TRUE);    
    SendMessage(fpScr->hWnd,WM_PAINT,NULL,NULL);
}

#ifdef LATER
void VSIstring(unsigned char *c,int ctr)
{
    int sx;
    int insert,
        ocount,
        attrib,
        extra,
        offend;
    char *acurrent,         /* pointer to the attributes for characters drawn */
        *current,           /* pointer to the place to put characters */
        *start;

    while(ctr>0) {
        if(*c<32) {
            switch(*c) {
                case 0x07:      /* CTRL-G found (bell) */
                    ScreenBell(fpScr);
                    break;

                case 0x08:      /* CTRL-H found (backspace) */
                    ScreenBackspace(fpScr);
                    break;

                case 0x09:      /* CTRL-I found (tab) */
                    ScreenTab(fpScr);     /* Later change for versatile tabbing */
                    break;

                case 0x0a:      /* CTRL-J found (line feed) */
                case 0x0b:      /* CTRL-K found (treat as line feed) */
                case 0x0c:      /* CTRL-L found (treat as line feed) */
                    ScreenIndex();
                    break;

                case 0x0d:      /* CTRL-M found (carriage feed) */
                    ScreenCarriageFeed(fpScr);
                    break;

              } /* end switch */
            c++;
            ctr--;
          } /* end if */
        else
            while((ctr>0) && (*c>=32)) {     /* print out printable ascii chars, if we haven't found an ESCAPE char */
                current=start=&fpScr->linest[fpScr->y]->text[fpScr->x];    /* this line is important, both are * chars */
                acurrent=&fpScr->attrst[fpScr->y]->text[fpScr->x];
                attrib=fpScr->attrib;
                insert=fpScr->IRM;          /* boolean */
                ocount=fpScr->x;
                offend=0;
                extra=0;
                sx=fpScr->x;
                if(fpScr->x>fpScr->maxwidth) {
                    if(fpScr->DECAWM) {  /* check for line wrapping on */
                        fpScr->x=0;
                        VSIindex();
                      } /* end if */
                    else                /* no line wrapping */
                        fpScr->x=fpScr->maxwidth;
                    current=start=&fpScr->linest[fpScr->y]->text[fpScr->x];
                    acurrent=&fpScr->attrst[fpScr->y]->text[fpScr->x];
                    ocount=fpScr->x;
                    sx=fpScr->x;
                  } /* end if */
                while((ctr>0) && (*c>=32) && (offend==0)) {
                    if(insert)
                        VSIinschar(1);
                    *current=*c;
                    *acurrent=(char)attrib;
                    c++;
                    ctr--;
                    if(fpScr->x<fpScr->maxwidth) {
                        acurrent++;
                        current++;
                        fpScr->x++;
                      } /* end if */
                    else {
                        if(fpScr->DECAWM) {
                            fpScr->x++;
                            offend=1;
                          } /* end if */
                        else {
                            fpScr->x=fpScr->maxwidth;
                            extra=1;
                          } /* end else */
                      } /* end else */
                  } /* end while */
                if(insert)
                    VSIinsstring(fpScr->x-ocount+offend+extra,start);        /* actually just decides which RS to use */
                else
                    VSIdraw(fpScrn,sx,fpScr->y,fpScr->attrib,fpScr->x-ocount+offend+extra,start);
              } /* end while */
      } /* end while */
}   /* end VSIstring */
#endif
