/************************************************************************
 *									*
 *	Background File Transfer Program (BFTP)				*
 *									*
 *	Written at USC/Information Sciences Institute			*
 *	September, 1988							*
 *									*
 *	BFTP is Public Domain, and may be used for any purpose as	*
 *	long as this notice is not removed.  USC-ISI does not assume	*
 * 	any responsibility for the correctness, performance, or use	*
 *	of this software.						*
 *									*
 ************************************************************************/

 /* 
  *        File Transfer Service
  *
  *  The File Transfer Service provides background file transfer
  *  service for the Internet, by driving FTP Servers to cause the desired
  *  file transfer.  It queues requests and tries them periodically until
  *  they succeed.
  *
  */
  
#include "bftp.h"
		
extern int errno ;
extern char *sys_errlist[] ;
  
    /* Define server information structure 
     */
#define MAX_addrs 4

struct server_struct {
	struct hostinfo h;
	
	struct in_addr inetaddr[MAX_addrs] ;  
				/* List of Internet addresses (unused
				 *  entries are zero). */
	short addrcurr ;        /* Index of current inaddr[] entry */
	short hostcount;	/* Number of inaddr entries */
	
	int   socket ;          /* Socket number */
	FILE *fpin ;            /* File Pointer for input side of Telnet conn*/
	FILE *fpout ;           /* File Pointer for output side */
	char dir_delim;
} ;

typedef  struct server_struct *SHandle;

	/*  Define result codes from various routines*/
#define OK  0

#define ERR_RETRY     -1 /* Failed, but can be tried later.  err_string will
                          * contain explanatory string concerning error.
                          */
#define ERR_PERMANENT -2 /* Failed and should not be retried. err_string will
                          * contain explanatory string concerning error.
                          */
#define ERR_SYSTEM    -3 /* Local system failure. err_string will
                          * contain explanatory string concerning error.
                          */

#define FTPTIMEOUT 60	   /* seconds */			  
#define MAXFTSTIME 14400   /* seconds (14400 = 4 hours) */
#define MAXINTERVAL 240    /* minutes (4 hours) = limit for backoff */

#define MAXerrstr 100      /* max length global err_string */
#define MAXreply  1024     /* max length of reply that is saved */

/*  Define FTP reply codes -- leading digits */
#define REP_TIMEOUT 0
#define REP_PRELIM 1
#define REP_OK     2
#define REP_NEEDMORE 3
#define REP_TEMPERR  4
#define REP_PERMERR  5
