.\" @(#)bftp.1
.TH BFTP 1C "06 April 1990"
.nh
.SH NAME
bftp \- Background File Transfer Program
.SH SYNOPSIS
.B bftp
.SH DESCRIPTION
.LP
.B bftp
is the user interface to the Background File Transfer Program (BFTP).
.B bftp
may be used to submit a request to have a file transfered at some time
in the future via the standard internet File Transfer Protocol (FTP),
which is described in RFC-959.
.LP
BFTP makes use of third party FTP, so the source and the destination hosts do
not have to be operational at the time the request is submitted.
Transfers are scheduled locally via the system batch processor,
.BR at .
Therefore the exact time of a file transfer will take place depends on how
often jobs are run from the system batch queue.
.LP
For more information on BFTP see 
.BR RFC-1068 .
.SH  BASIC COMMANDS
.HP
.B explain
.br
Display a short explanation of how to use this program.
.TP
.BI find
.br
Locate and display a previously submitted BFTP job.  
.B bftp 
will prompt for the (optional) 
.I RequestID 
and the 
.IR RequestKeyword .
Once a reqest has been located and displayed, it can be changed and
resubmitted, or cancelled.
.HP
.B help
.RI [ " command " ]
.br
Print an informative message about the meaning of
.IR command .
If no argument is given, 
.B bftp
prints a list of the commands and their descriptions.
.TP
.B prompt
Prompt for all the necessary information to setup an transfer.
.TP
.B quit
.br
End the current 
.BR bftp " session."
.TP
.B status
.br
Display the current parameter values.
.TP
.B submit
.br
Place the request in the batch queue.
.BR bftp " will prompt for the"
.IR StartTime " and the " RequestKeyword .
.TP
.B transfer
.br
Perform the requested transfer now.
.TP
.B verify
.br
Validate the request.  The current request will be checked to see if all
needed information has been entered.  Then
.B bftp
will connect to the specified hosts to determine whether the specified
parameters used are supported.
.LP
.SH ADVANCED COMMANDS
.LP
.HP
.B init
.br
Discard all information about a request.  This command is used to reset
.BR bftp " to the default startup values."
.TP
.BI d-dir " destination-directory"
.br
Establish the destination directory into which the file is to be transferred.
The directory name must end with a directory-delimiter character.
.TP
.BI d-file " filename"
Set the destination filename.  This will be the name of the file once the
transfer is complete.
.TP
.BI d-host " hostname"
Set the destination hostname.  This is the host to which the file will be transferred.
.BI d-user " user"
Specify the user name (login) on the destination host.
.BI d-password " password"
Specify the password on the destination host.
.HP
.BI "r-delete " request-file
.TP
.B r-list
.TP
.BI "r-load " request-file
.TP
.BI "r-store " request-file
.br
.RB "The " request " commands are used to manage "
.IR request-files ", which are used to save BFTP requests for future use."
.TP
.BI s-dir " source-directory"
Set the source directory from which the file will be transferred.
The directory name must end with a directory-delimiter character.
.TP
.BI s-file " source-filename"
Set the source filename of the file to be tranferred.
.TP
.BI s-host " hostname"
Set the destination hostname.  This is the host to which the file will be transferred.
.BI s-user " user"
Specify the user name (login) on the destination host.
.BI s-password " password"
Specify the password on the destination host.
.HP
.BI s-acct and d-acct
.br
Set the login accounts.
This will set the login account name for the transaction.  This option
is usually not needed.
.HP
.BR "append true" " | "
.B false
.br
If the destination file exists and this option is
.BR true ,
append the transferred file to the existing file.  If this option is 
.B false
and the file name is already in use, the existing file will be replaced,
so long as write-permission on the destination host is enabled.
.HP
.BR "command copy" " | " delete " | " move
.br
Set the source file disposition to
.BR copy ", " move " (i.e. copy and delete), or simply " delete
the source file.  The default is 
.BR copy .
these commands set the file transfer mode.  
.HP
.BR "mode stream" " | " block " | " compress
.br
.RB "Set the FTP mode. The default value is " stream .
.HP
.B mailbox
.I "mailbox-name"
.br
Send the completion notification message to this address.
.HP
.BR "multiple true" " | "
.B false
.br
.RB "When " true ", transfer all files that match the pattern set in " sfile
to be transferred.  Matching is performed on the source host.
.HP
.BR s-port " | " d-port
.I n
.br
Set the FTP transaction source or destination port number.
This is usually set to 21.
.HP
.BR "structure file " | " record " | " page
.br
Set the FTP structure.
.TP
.BI "time " "StartTime retry-interval maximum-retries"
.br
Set the defaults for the the time at which the file will be transferred,
the number of times to retry following a failure, and the starting interval
between retries, in minutes.
Each time that a transfer is retried, the retry interval will be doubled,
up to a maximum of 4 hours.
.HP
.BR "type image" " | " ascii " | " ebcdic " | " 
.B local
.br
Set the FTP file type.  The 
.BR ascii " and " ebcdic " types have further parameters of "
.BR nonprint ,  telnet ", and " carriage-control .
.RB "The default type is " "ascii nonprint" .

The representation type may be one of network ASCII, EBCDIC, image, 
or local byte size with a specified byte size (for PDP-10's and 
PDP-20's mostly).  The network ASCII and EBCDIC types have a further 
subtype which specifies whether vertical format control (NEWLINE characters,
form feeds, etc.) are to be passed through (nonprint), provided in TELNET
format, or provided in ASA carriage control format.
.HP
.BR "unique true" " | "
.B false
.br
Set unique mode.  If 
.BR unique " is " true ,
then the destination file name will be guaranteed unique.
This keeps old files from being replaced by new files with the same name.
.HP
.BR "verbose true" " | "
.B false
.br
Set verbose mode.  When 
.BR verbose " is " true ,
.B bftp
prints each command used in the transaction during the 
.BR verify " and the " transfer " operations."
.SH FILES
.LP
.B bftp
creates a number of files that are used to keep track of requests that
are in progress:
.in 8
.BI bftp 123456789 .cmd
.br
.BI bftp 123456789 .list
.br
.BI bftp 123456789 .msg
.br
.BI bftp 123456789 .req
.LP
The files that are saved via the 
.B request save
command are as follows:
.in 8
.BI bftp-save. request-name
.LP
.B bftp
usually stores request files in the home directory of the user who is logged
on.  To have 
.B bftp
store these files in another directory, use the system
.B setenv 
command to set
.BR $BFTPDIR , 
for example
.in 8
.BI "setenv BFTPDIR ~" "yourname/.bftp"
.LP
.SH "SEE ALSO"
.BR at (1),
.BR bftptool (1C),
.BR cron (8),
.BR crontab (5),
.BR ftp (1C),
.BR ftpd (8C),
.BR mbftptool (1C)
.SH AUTHOR
Annette DeSchon, USC Information Sciences Institute
.SH BUGS
Please report bugs to Annette DeSchon <deschon@isi.edu>, 213-822-1511.
