/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <sys/types.h>
#include <sys/time.h>
#include <netatalk/at.h>
#include <atalk/atp.h>
#include "atp_internals.h"
#ifdef EBUG
#include <stdio.h>
#endif EBUG

int atp_close( ah )
    ATP		ah;
{
    struct atpbuf	*cq, *tq;
    int			i;

    /* remove from list of open atp sockets & discard queued data
    */
#ifdef EBUG
    printf( "(%d) atp_close %d\n", getpid(), ah->atph_socket );
#endif EBUG

    if ( close( ah->atph_socket ) < 0 ) {
	return -1;
    }
    cq = ah->atph_queue;
    while ( cq != NULL ) {
	tq = cq->atpbuf_next;
	free_buf( cq );
	cq = tq;
    }

    cq = ah->atph_sent;
    while ( cq != NULL ) {
	for ( i = 0; i < 8; ++i ) {
	    if ( cq->atpbuf_info.atpbuf_xo.atpxo_packet[ i ] != NULL ) {
		free_buf( cq->atpbuf_info.atpbuf_xo.atpxo_packet[ i ] );
	    }
	}
	tq = cq->atpbuf_next;
	free_buf( cq );
	cq = tq;
    }

    if ( ah->atph_reqpkt != NULL ) {
	free_buf( ah->atph_reqpkt );
    }

    for ( i = 0; i < 8; ++i ) {
	if ( ah->atph_resppkt[ i ] != NULL ) {
	    free_buf( ah->atph_resppkt[ i ] );
	}
    }

    free_buf( (struct atpbuf *) ah );

    return 0;
}
