/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

/* 
 * Our own memory maintenance for atp
*/

#include <sys/types.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <netatalk/at.h>
#include <atalk/atp.h>

#define			N_MORE_BUFS		10

extern char		*malloc();
extern int		errno;
static struct atpbuf 	*free_list = NULL;	/* free buffers */

struct atpbuf *alloc_buf()
{
    struct atpbuf *bp;

    if ( free_list == NULL && more_bufs() ) return NULL;

    bp = free_list;
    free_list = free_list->atpbuf_next;
    return bp;
}


int free_buf( bp )
    struct atpbuf	*bp;
{
    if ( bp == NULL ) {
	return -1;
    }
    bp->atpbuf_next = free_list;
    free_list = bp;
    return 0;
}


/* only call this when the free_list is empty...
 * N_MORE_BUFS must be >= one
*/
more_bufs()
{
    int			i;
    char		*mem;
    struct atpbuf	*bp;

    /* get the whole chunk in one malloc call
    */
    if (( mem = malloc( N_MORE_BUFS * sizeof( struct atpbuf ))) == NULL ) {
	errno = ENOBUFS;
	return -1;
    }
    /* now split into separate bufs
    */
    bp = free_list = (struct atpbuf *) mem;
    for ( i = 1; i < N_MORE_BUFS; ++i ) {
	bp->atpbuf_next = (struct atpbuf *) ( mem += sizeof( struct atpbuf ));
	bp = bp->atpbuf_next;
    }
    bp->atpbuf_next = NULL;

    return 0;
}
