/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <sys/file.h>
#include <sys/types.h>
#include <sys/param.h>
#include <atalk/adouble.h>

ad_write( ad, eid, off, buf, buflen )
    struct adouble	*ad;
    int			eid, off, buflen;
    char		*buf;
{
    int			cc;

    if ( eid == ADEID_DFORK ) {
	if ( ad->ad_df.adf_off != off ) {
	    if ( lseek( ad->ad_df.adf_fd, off, L_SET ) < 0 ) {
		return( -1 );
	    }
	    ad->ad_df.adf_off = off;
	}
	cc = write( ad->ad_df.adf_fd, buf, buflen );
	if ( cc < 0 ) {
	    return( -1 );
	}
	ad->ad_df.adf_off += cc;
    } else {
	if ( ad->ad_hf.adf_off != ad->ad_eid[ eid ].ade_off + off ) {
	    if ( lseek( ad->ad_hf.adf_fd,
		    ad->ad_eid[ eid ].ade_off + off, L_SET ) < 0 ) {
		return( -1 );
	    }
	    ad->ad_hf.adf_off = ad->ad_eid[ eid ].ade_off + off;
	}
	cc = write( ad->ad_hf.adf_fd, buf, buflen );
	if ( cc < 0 ) {
	    return( -1 );
	}

	if ( ad->ad_hf.adf_off < sizeof( ad->ad_data )) {
	    bcopy( buf, ad->ad_data + ad->ad_hf.adf_off,
		    MIN( sizeof( ad->ad_data ) - ad->ad_hf.adf_off, cc ));
	}

	ad->ad_hf.adf_off += cc;
	if ( ad->ad_eid[ eid ].ade_len < off + cc ) {
	    ad->ad_eid[ eid ].ade_len = off + cc;
	}
    }

    return( cc );
}

ad_rtruncate( ad, size )
    struct adouble	*ad;
    int			size;
{
    if ( ftruncate( ad->ad_hf.adf_fd,
	    size + ad->ad_eid[ ADEID_RFORK ].ade_off ) < 0 ) {
	return( -1 );
    }
    ad->ad_eid[ ADEID_RFORK ].ade_len = size;
    if ( lseek( ad->ad_hf.adf_fd, 0L, L_SET ) < 0 ) {
	return( -1 );
    }
    ad->ad_hf.adf_off = 0;
    return( 0 );
}
