#!/bin/sh
#
# setprintername printername
#
# Set printer name
#
# N.B. The entire PRINTERNAME variable must be under 32 bytes long.
# This can be a problem when attempting to set the type. One possible
# work around is to set the name and the type as separate operations.
#

USAGE="Usage: setprintername [-P printer] printername"

while :
do
	case $# in
	0)	break
		;;
	esac

	case "$1" in
	-P)	shift; PRINTERARG="-P$1"
		;;
	-P*)	PRINTERARG="$1"
		;;
	-*)	echo "$0: bad option $1" >&2
		echo $USAGE
		exit 1
		;;
	*)	if [ x"$PRINTERNAME" != x ]; then
			echo $USAGE
			exit 1
		fi
		PRINTERNAME=$1
		;;
	esac
	shift
done

if [ x"$PRINTERNAME" = "x" ]; then
	echo $USAGE
	exit 1
fi

if [ x"$PRINTERARG" = x ]; then
	if [ x"$PRINTER" != x ]; then
		PRINTERARG=-P$PRINTER
	fi
fi

lpr $PRINTERARG <<EOF
%!
0000000000
serverdict begin exitserver
statusdict begin
($PRINTERNAME)
setprintername
end
EOF
exit 0
