#!/bin/sh
#
# set8bit [-P printer]
#
# Set printer 25-pin serial interface to 9600bps, no parity (pass 8 bits)
#

USAGE="Usage: set8bit [-P printer]"

while :
do
	case $# in
	0)	break
		;;
	esac

	case "$1" in
	-P)	shift; PRINTERARG="-P$1"
		;;
	-P*)	PRINTERARG="$1"
		;;
	-*)	echo "$0: bad option $1" >&2
		echo $USAGE
		exit 1
		;;
	*)	echo $USAGE
		exit 1
		;;
	esac
	shift
done

if [ x"$PRINTERARG" = x ]; then
	if [ x"$PRINTER" != x ]; then
		PRINTERARG=-P$PRINTER
	fi
fi

lpr $PRINTERARG <<EOF
%!
0000000000
serverdict begin exitserver
statusdict begin
25 9600 3
setsccbatch
end
EOF
exit 0
