#!/bin/sh
#
# product [-P printer]
#
# Send a job to the printer that causes it to print its product name
#

USAGE="Usage: product [-P printer]"

while :
do
	case $# in
	0)	break
		;;
	esac

	case "$1" in
	-P)	shift; PRINTERARG="-P$1"
		;;
	-P*)	PRINTERARG="$1"
		;;
	-*)	echo "$0: bad option $1" >&2
		echo $USAGE
		exit 1
		;;
	*)	echo $USAGE
		exit 1
		;;
	esac
	shift
done

if [ x"$PRINTERARG" = x ]; then
	if [ x"$PRINTER" != x ]; then
		PRINTERARG=-P$PRINTER
	fi
fi

lpr $PRINTERARG <<EOF
%!
/Helvetica findfont
24 scalefont setfont
100 700 moveto
statusdict begin
(Product: ") show
product show
(") show
showpage
EOF
exit 0
