/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>
#include <netatalk/at.h>
#include <atalk/atp.h>
#include "pap.h"

int debugflg = 0;

static char	statbuf[ PAP_MAXDATA ];

main( argc, argv )
    int		argc;
    char	**argv;
{
    extern int		optind;
    extern char		*optarg;

    int			c, retrytime = 0;
    int			errflg = 0;
    char		*printer = NULL;
    char		*usage = "usage: %s [-d] [-p printer] [retrytime]\n";
    struct sockaddr_at	sat;

    /* process arguments */
    while (( c = getopt( argc, argv, "dp:" )) != EOF ) {
	switch( c ) {
	case 'd':
	    if ( debugflg ) {
		++errflg;
	    } else {
		++debugflg;
	    }
	    break;
	case 'p':
	    if ( printer != NULL ) {
		++errflg;
	    }
	    printer = optarg;
	    break;
	default:
	    ++errflg;
	}
    }

    if ( optind == argc - 1 ) {
	retrytime = atoi( argv[ optind ] );
	++optind;
    }

    if ( errflg || optind < argc ) {
	fprintf( stderr, usage, argv[ 0 ] );
	exit( 1 );
    }

    if ( printer == NULL ) {	/* try to get printer from .paprc file */
	if (( printer = pap_printername()) == NULL ) {
	    pap_fperror( stderr, PAP_PRINTERNAMEFILE );
	    exit( 1 );
	}
    }

    if ( pap_nametoaddr( printer, &sat ) < 0 ) {
	pap_fperror( stderr, printer );
	exit( 1 );
    }

    errflg = 0;
    do {
	if ( pap_status( &sat, statbuf, sizeof( statbuf )) < 0 ) {
	    pap_fperror( stderr, printer );
	    ++errflg;
	} else {
	    printf( "%s:\t%s\n", printer, statbuf );
	}
	if ( retrytime > 0 ) {
	    sleep( retrytime );
	}
    } while ( retrytime > 0 );

    exit( errflg );
}
