/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

extern char	**Argv;		/* pointer to original (main's) argv */
extern int	Argc;		/* original argc */

setproctitle(fmt, a, b, c)
	char *fmt;
/*
 * takes a printf-style format string (fmt) and up to three parameters (a,b,c)
 * this clobbers the original argv...
 */
{
    static char *endargv = (char *)0;
    char	*s;
    int		i;
    char	buf[ 1024 ];

    if ( endargv == (char *)0 ) {
	/* set pointer to end of original argv 
	*/
	endargv = Argv[ Argc-1 ] + strlen( Argv[ Argc-1 ] );
    }
    sprintf( buf, fmt, a, b, c );
    /* make ps print "([prog name])" */
    s = Argv[0];
    *s++ = '-';
    i = strlen( buf );
    if ( i > endargv - s - 2 ) {
	i = endargv - s - 2;
	buf[ i ] = '\0';
    }
    strcpy( s, buf );
    s += i;
    while ( s < endargv ) *s++ = ' ';
}
