/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <strings.h>
#include <netinet/in.h>
#undef s_net
#include <netatalk/at.h>
#include <atalk/nbp.h>
#include <atalk/atp.h>
#include "pap.h"
#include "papd.h"
#include "lw.h"

int		q_default(), q_spooler();
extern int	q_font(), q_fontlist(), q_procset();
extern int	debugflg;

static struct query_table qtable[] = {
    { Q_FEATURE, sizeof( Q_FEATURE )-1, q_default },
    { Q_FILE, sizeof( Q_FILE )-1, q_default },
    { Q_FONTLIST, sizeof( Q_FONTLIST )-1, q_fontlist },
    { Q_FONT, sizeof( Q_FONT )-1, q_font },
    { Q_PRINTER, sizeof( Q_PRINTER )-1, q_default },
    { Q_PROCSET, sizeof( Q_PROCSET )-1, q_procset },
    { Q_QUERY, sizeof( Q_QUERY )-1, q_default },
    { Q_VMSTATUS, sizeof( Q_VMSTATUS )-1, q_default },
    { NULL, 0, q_default },
};

struct query_table *
find_query( s )
    char	*s;
{
    struct query_table	*qt;

    if ( strncasecmp( BEGINQUERY, s, sizeof(BEGINQUERY)-1 ) != 0 ) {
	return( NULL );
    }
    s += sizeof(BEGINQUERY)-1;

    for ( qt = qtable; qt->query_text != NULL; ++qt ) {
	if ( strncasecmp( qt->query_text, s, qt->query_textlen ) == 0 ) 
	    break;
    }
#ifdef EBUG
    if ( debugflg ) {
	fprintf( stderr, "find_query returns %s\n",
	  qt->query_text == NULL ? "<Use Default>" : qt->query_text );
	fflush( stderr );
    }
#endif EBUG
    qt->query_params = s + qt->query_textlen;
    if ( *qt->query_params == ':' ) {
	++qt->query_params;
    }
    if ( *qt->query_params == ' ' ) {
	++qt->query_params;
    }

    for ( s = qt->query_params ; *s != EOL; ++s ) {
	;
    }
    *s = '\0';

    return ( qt );
}


char	*
swallow_query( bufp, blen )
    char	**bufp;
    int		*blen;
{
/* return End (last) line of a query.  swallow lines preceding %%End */
    char	*s;

#ifdef EBUG
    if ( debugflg ) {
	fprintf( stderr, "entered swallow_query:\n" );
	bfprint( stderr, *bufp, *blen );
	fflush( stderr );
    }
#endif EBUG
    while (( s = getline( bufp, blen )) != NULL
      && strncasecmp( ENDQUERY, s, sizeof(ENDQUERY)-1 ) != 0 ) {
#ifdef EBUG
	if ( debugflg ) {
	    fprintf( stderr, "swallow_query line is:" );
	    bfprint( stderr, s, linelen( s ));
	    fflush( stderr );
	}
#endif EBUG
	;
    }
#ifdef EBUG
    fprintf( stderr, "swallow_query returning:" );
    if ( s == NULL ) {
	fprintf( stderr, "\tNULL" );
    } else {
	fprintf( stderr, "<%.*s>\n", linelen( s ), s );
    }
    fflush( stderr );
#endif EBUG
    return s;
}


q_default( ph, qt, bufp, blen )
    PAP			ph;
    struct query_table	*qt;
    char		**bufp;
    int			*blen;
{
/* handle a query by just returning the default message */ 
    char	*s;

#ifdef EBUG
    if ( debugflg ) {
	fprintf( stderr, "entered q_default\n" );
	fflush( stderr );
    }
#endif EBUG

    if (( s = swallow_query( bufp, blen )) == NULL
      || ( s = index( s, ' ' )) == NULL ) {
#ifdef EBUG
    if ( debugflg ) {
	fprintf( stderr, "q_default returning -1\n" );
	fflush( stderr );
    }
#endif EBUG
	return -1;
    }
    ++s;
    /* send back reply */
#ifdef EBUG
    if ( debugflg ) {
	fprintf( stderr, "q_default is <%.*s> -- sending it\n", linelen(s), s );
	fflush( stderr );
    }
#endif EBUF
    if ( pap_write( ph, s, linelen( s )+1, 0 ) < 0 ) {
	return -1;
    }
    return 0;
}
