/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#ifdef EBUG
#include <stdio.h>
#endif EBUG
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/dir.h>
#include <sys/uio.h>
#include <strings.h>

#include <netatalk/at.h>
#include <atalk/atp.h>
#include "pap.h"
#include "papd.h"
#include "lw.h"

char			*malloc();
char			*realloc();
char			*index();
char			*rindex();

extern int		debugflg;
extern int		acceptprocsets;
extern char		*procsetdir;
extern struct procset	**procsetlist;

static char		pspath[ MAXPATHLEN ];

readprocsetdir( dir )
    char	*dir;
{
    DIR			*dp;
    struct direct	*dent;
    struct procset	*ps;
    struct procset	**psp;
    char		*name;
    char		*s;
    int			i;

    if (( dp = opendir( dir )) == NULL ) {
	if ( mkdir( dir, 0755 ) < 0 ) {
	    return -1;
	} else {
	    dp = opendir( dir );
	}
    }
    if ( procsetlist != NULL ) {
	/* we must be replacing an old list -- free old one */
	for ( psp = procsetlist; *psp != NULL; ++psp ) {
	    free( (*psp)->procset_name );
	    free( *psp );
	}
	free( procsetlist );
    }
    if (( procsetlist = (struct procset **) malloc( sizeof(struct procset **)))
      == NULL ) {
	return -1;
    }
    i = 1;
    while (( dent = readdir( dp )) != NULL ) {
	if ( dent->d_name[ 0 ] != '.' ) {
	    dent->d_name[ dent->d_namlen ] = '\0';
	    name = dent->d_name;
	    if (( procsetlist = (struct procset **) realloc( procsetlist,
	      (i+1) * sizeof(struct procset **))) == NULL ) {
		return -1;
	    }
	    if (( ps = procsetlist[i-1] =
	      (struct procset *) malloc( sizeof(struct procset))) == NULL ) {
		return -1;
	    }
	    ps->procset_version = ps->procset_release = 0;
	    if (( s = index( name, '.' )) != NULL ) {
		/* found a version number */ 
		*s = '\0';
		ps->procset_version = (short) atoi( s+1 );
		if (( s = index( s+1, '.' )) != NULL ) {
		    /* found a release number */ 
		    ps->procset_release = (short) atoi( s+1 );
		}
	    }
	    if (( ps->procset_name = malloc( strlen( name ) + 1 )) == NULL ) {
		return -1;
	    }
	    strcpy( ps->procset_name, name );
	    ++i;
	}
    }
    procsetlist[ i-1 ] = NULL;
    closedir( dp );
    return 0;
}


openprocset( procsetdir, new, psp, flags, mode )
    char		*procsetdir;
    int			new;
    struct procset	*psp;
    int			flags;
    int			mode;
{
    int		fd;

    if ( new ) {
	sprintf( pspath, "%s/tmp.%d", procsetdir, getpid());
    } else {
	sprintf( pspath, "%s/%s.%hu.%hu", procsetdir, psp->procset_name,
	  psp->procset_version, psp->procset_release );
    }
    fd = open( pspath, flags, mode );
    if ( fd >= 0 && new && write( fd, BEGINPOSTSCRIPT, BEGINPOSTSCRIPT_LEN ) !=
      BEGINPOSTSCRIPT_LEN ) {
	return -1;
    }
    return fd;
}


closeprocset( procsetdir, psp, fd )
    char		*procsetdir;
    struct procset	*psp;
    int			fd;
{
    char	newpath[ MAXPATHLEN ];

    close( fd );
    /* rename file from "dir/tmp.<pid>" to "dir/procsetname" */
    sprintf( newpath, "%s/%s.%hu.%hu", procsetdir, psp->procset_name,
      psp->procset_version, psp->procset_release );
    if ( rename( pspath, newpath ) != 0 ) {
	/* someone else must've beat us to creating this proc. set
	 * just unlink the file instead
	 */
	unlink( pspath );
    }
    return ( readprocsetdir( procsetdir ));
}


unlinkprocset()
{
    unlink( pspath );
    return 0;
}



struct procset	*
str2procset( s )
    char	*s;
{
    struct procset		*psp;
    char			*name;
    int				quoted = 0;
    int				psversion, psrelease;

    psversion = psrelease = 0;
    if (( name = index( s, '"' )) != NULL ) {
	++quoted;
    } else if (( name = index( s, ' ' )) == NULL ) {
	return NULL;
    }
    ++name;
    if (( s = index( name, quoted ? '"' : ' ' )) != NULL ) {
	*s = '\0';
	if ( *(++s) == ' ' ) ++s;
	psversion = atoi( s );
	if (( s = index( s, ' ' )) != NULL ) {
	    psrelease = atoi( s+1 );
	}
    } else {
	return NULL;
    }

    if (( psp = (struct procset *)malloc( sizeof( struct procset ))) == NULL ) {
	return NULL;
    }
    psp->procset_version = psversion;
    psp->procset_release = psrelease;
    if (( psp->procset_name = malloc( strlen( name ) + 1 )) == NULL ) {
	return NULL;
    }
    strcpy( psp->procset_name, name );
    name[ strlen( name ) ] = quoted ? '"': ' ';
    spaces2ubars( psp->procset_name );
    return psp;
}


psp_free( psp )
    struct procset	*psp;
{
    if ( psp->procset_name != NULL ) {
	free( psp->procset_name );
    }

    free( psp );
}


haveprocset( psp )
    struct procset	*psp;
{
    int			rc;
    struct procset	**p;

    rc = 0;
    for ( p = procsetlist; *p != NULL && rc != 1; ++p ) {
	if ( strcasecmp( (*p)->procset_name, psp->procset_name ) == 0 ) {
	    rc = ( (*p)->procset_version == psp->procset_version ? 1 : 0 );
	}
    }
    return rc;
}


q_procset( ph, qt, bufp, blen )
    PAP			ph;
    struct query_table	*qt;
    char		**bufp;
    int			*blen;
{
/* handle a procedure set query */ 
    static char		reply[ 2 ];
    struct procset	*ps;

    if ( swallow_query( bufp, blen ) == NULL ||
      ( ps = str2procset( qt->query_params )) == NULL ) {
	return -1;
    }
    /* send back reply */
    reply[ 0 ] = '0' + haveprocset( ps );
    reply[ 1 ] = EOL;
#ifdef EBUG
    if ( debugflg ) {
	printf( "q_procset: ps is <%x>\n", ps->procset_name );
	fprintf( stderr, "q_procset returning %c\n", reply[ 0 ] );
	fflush( stderr );
    }
#endif EBUG
    if ( pap_write( ph, reply, 2, 0 ) < 0 ) {
	return -1;
    }
    return 0;
}


spaces2ubars( s )
    char	*s;
{
    for (;  *s != '\0'; ++s ) {
	if ( *s == ' ' ) *s = '_';
    }
}
