/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/uio.h>
#include <sys/signal.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <pwd.h>
#include <strings.h>
#include <syslog.h>
#include <netatalk/at.h>
#include <atalk/nbp.h>
#include <atalk/atp.h>
#include <atalk/paths.h>
#include "pap.h"
#include "papd.h"
#include "paperrno.h"
#include "lw.h"
#include "lp.h"

extern char	*malloc();
extern char	*realloc();
char		*copyarg();
#if !defined( ibm032 ) && !defined( _IBMR2 )
void		reinitialize();
void		die();
void		childdone();
void		pipebroken();
#else ibm032 _IBMR2
int		reinitialize();
int		die();
int		childdone();
int		pipebroken();
#endif ibm032 _IBMR2
int		children = 0;

PAP		ph;
int		uid;
char		*host;
char		*printer = NULL;
char		*printcmdargv = NULL;
char		*printspooldir = NULL;
char		*operator = NULL;
char		*servername = NULL; 
char		*procsetdir = NULL;
char		**fontlist = NULL;
struct procset	**procsetlist = NULL;
char		*fontfilename = NULL; 
char		*configfile = NULL; 
int		debugflg = 0;
int		pipedprinter = 0;
int		acceptprocsets = 0;
int		dsc_majorvers = 0;
int		dsc_minorvers = 0;
static int	server = 1;

char		**Argv;
int		Argc;

main( argc, argv )
    int		argc;
    char	**argv;
{
    extern int		optind;
    extern char		*optarg;

    int			c;
    int			origsigmask;
    struct sigvec	sv;
    PAP			newph;
    int			errflg = 0;
    char		*s, *usage = "usage: %s [-a] [-d] [-f configfile]\n";

    /* process arguments */
    while (( c = getopt( argc, argv, "adf:" )) != EOF ) {
	switch( c ) {
	case 'a':
	    if ( acceptprocsets ) {
		++errflg;
	    } else {
		++acceptprocsets;
	    }
	    break;
	case 'd':
	    if ( debugflg ) {
		++errflg;
	    } else {
		++debugflg;
	    }
	    break;
	case 'f':
	    if ( configfile != NULL ) {
		++errflg;
	    } else {
		configfile = copyarg( optarg );
	    }
	    break;
	default:
	    ++errflg;
	}
    }
    if ( errflg ) {
	fprintf( stderr, usage, argv[ 0 ] );
	exit( 2 );
    }
    /* set extern'd Argv and Argc for setproctitle() */
    Argv = argv;
    Argc = argc;

    /* fork and disassociate from the terminal */
    if ( !debugflg ) {
	int	i, dt;

	switch ( fork()) {
	case 0 :	/* child */
	    dt = getdtablesize();
	    for ( i = 0; i < dt; i++ ) {
		(void) close( i );
	    }
	    if (( i = open( "/dev/tty", O_RDWR )) >= 0 ) {
		(void) ioctl( i, TIOCNOTTY, 0 );
		setpgrp( 0, getpid());
		(void) close( i );
	    }
	    break;
	case -1 :
	    perror( "fork" );
	    exit( -1 );
	default :	/* parent */
	    exit( 0 );
	}
    }
    if (( s = rindex( argv[ 0 ], '/' )) == NULL ) {
	s = copyarg( argv[ 0 ] );
    } else {
	s = copyarg( s + 1 );
    }

#ifdef ultrix
    openlog( s, LOG_PID );
#else ultrix
    openlog( s, LOG_NDELAY | LOG_PID, LOG_DAEMON );
#endif ultrix
    if ( configfile == NULL ) {
	configfile = _PATH_PAPDCONF;
    }
    if ( initialize( configfile ) < 0 ) {
	syslog( LOG_ERR, "initialize: %m (exiting)" );
	exit( -1 );
    }
    /* set up signal catchers */
    sv.sv_mask = 0;
    sv.sv_flags = SV_INTERRUPT;
    sv.sv_handler = die;
    sigvec( SIGTERM, &sv, (struct sigvec *) 0 ); 
    sv.sv_handler = reinitialize;
    sigvec( SIGHUP, &sv, (struct sigvec *) 0 ); 
    sv.sv_handler = childdone;
    sigvec( SIGCHLD, &sv, (struct sigvec *) 0 ); 
    sv.sv_handler = pipebroken;
    sigvec( SIGPIPE, &sv, (struct sigvec *) 0 ); 

    origsigmask = sigblock( sigmask(SIGTERM) | sigmask(SIGCHLD));

    syslog( LOG_INFO, "started (service: %s  operator: %s  printer: %s)",
      servername, operator, printer );

    /* main service loop */
    for (;;) {
	if (( newph = pap_getnextjob( &ph )) == NULL ) {
	    pap_logerror( "pap_getnextjob (exiting)" );
	    exit( -1 );
	}
	if ( readprocsetdir( procsetdir ) < 0 ) {
	    pap_logerror( "readprocsetdir (exiting)" );
	    exit( -1 );
	}
	while (( c = fork()) < 0 ) {
	    syslog( LOG_ERR, "fork %m: sleeping for 10 seconds..." );
	    sleep( 10 );
	}
	if ( c ) {
	    /* parent */
	    if ( ++children == 1 ) {
		pap_herestatus( ph, STATUSWORKING );
	    }
	    pap_slclose( newph, 0 );
	} else {
	    /* child -- remove signal handlers, close server socket */
	    server = 0;
	    pap_slclose( ph, 0 );
	    sv.sv_handler = SIG_DFL;
	    sv.sv_mask = sv.sv_flags = 0;
	    sigvec( SIGTERM, &sv, (struct sigvec *) 0 ); 
	    sigvec( SIGHUP, &sv, (struct sigvec *) 0 ); 
	    sigvec( SIGCHLD, &sv, (struct sigvec *) 0 ); 
	    sigsetmask( origsigmask );
	    if ( process_job( newph ) < 0 ) {
		pap_logerror( "process_job (exiting)" );
		unlinktempfiles();
		exit( -1 );
	    }
	    pap_slclose( newph, 0 );
	    syslog( LOG_INFO, "job done -- child exiting" );
	    exit( 0 );
	}
	if ( children > PAPD_MAXCHILDS ) {
	    syslog( LOG_INFO, "exceeded job limit %d", PAPD_MAXCHILDS );
	    sigpause( 0 );
	}
    }
}


char	*
copyarg( s )
    char	*s;
{
    char	*rs;

    if (( rs = malloc( strlen( s ) + 1 )) == NULL ) {
	syslog( LOG_ERR, "copyarg %m (exiting)" );
	exit( -1 );
    }
    strcpy( rs, s );
    return rs;
}


#if !defined( ibm032 ) && !defined( _IBMR2 )
    void
#endif ibm032 _IBMR2
reinitialize()
{
    syslog( LOG_INFO, "restarting on signal" );
    if ( pap_slclose( ph, 1 ) < 0 ) {
	pap_logerror( "pap_slclose (exiting)" );
	exit( -1 );
    }
    if ( initialize( configfile ) < 0 ) {
	pap_logerror( "initialize (exiting)" );
	exit( -1 );
    }
    if ( children > 0 ) {
	pap_herestatus( ph, STATUSWORKING );
    }
    syslog( LOG_INFO, "restarted (service: %s  operator: %s  printer: %s)",
      servername, operator, printer );
}


#if !defined( ibm032 ) && !defined( _IBMR2 )
    void
#endif ibm032 _IBMR2
die()
{
    syslog( LOG_INFO, "shutting down....\n" );
    if ( server && pap_slclose( ph, 1 ) < 0 ) {
	pap_logerror( "pap_slclose" );
	exit( -1 );
    }
    exit( 0 );
}

#ifndef WEXITSTATUS
#define WEXITSTATUS(x)  ((x).w_status)
#endif

#if !defined( ibm032 ) && !defined( _IBMR2 )
    void
#endif ibm032 _IBMR2
childdone()
{
    union wait	status;
    int		pid;

    while (( pid = wait3( &status, WNOHANG, 0 )) > 0 ) {
	if ( WIFEXITED( status )) {
	    if ( WEXITSTATUS( status )) {
		syslog( LOG_INFO, "childdone %d exited %d", pid,
			WEXITSTATUS( status ));
	    } else {
		syslog( LOG_INFO, "childdone %d done", pid );
	    }
	} else if ( WIFSIGNALED( status )) {
	    syslog( LOG_INFO, "childdone %d killed", pid );
	} else {
	    syslog( LOG_INFO, "childdone %d died", pid );
	}
	if ( --children == 0 ) {
	    pap_herestatus( ph, STATUSIDLE );
	}
    }
}


#if !defined( ibm032 ) && !defined( _IBMR2 )
    void
#endif ibm032 _IBMR2
pipebroken()
{
    /* just ignore this for now... */
}


pap_logerror( s )
    char	*s;
{
    if ( pap_errno == 0 ) {	/* system error */
	syslog( LOG_ERR, "%s: %m", s );
    } else {
	if ( pap_errno < 0 || pap_errno > pap_nerr ) {
	    syslog( LOG_ERR, "%s: Unknown PAP Error (%d)\n", s, pap_errno );
	} else {
	    syslog( LOG_ERR, "%s: %s", s, pap_errlist[ pap_errno ] );
	}
    }
}
