/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/syslog.h>
#include <sys/uio.h>
#include <pwd.h>
#include <strings.h>
#include <ctype.h>
#include <netatalk/at.h>
#include <atalk/nbp.h>
#include <atalk/atp.h>
#include <atalk/paths.h>
#include "pap.h"
#include "papd.h"
#include "lw.h"
#include "lp.h"

extern char	*malloc();
extern char	*realloc();
extern char	*copyarg();
int		initialize();

extern char	*fontfilename;
extern char	*procsetdir;
extern char	*host;
extern char	*servername;
extern char	*printer;
extern char	*printspooldir;
extern char	**printcmdargv;
extern char	*operator;
extern char	*printcapfile;
extern PAP	ph;
extern int	debugflg;
extern int	pipedprinter;

initialize( conffile )
    char	*conffile;
{
    char		*service;
    char		line[ 1024 ];
    FILE		*f;
    char		*p;

    pipedprinter = 0;
    if ( servername != NULL ) free( servername );
    if ( fontfilename != NULL ) free( fontfilename );
    if ( printer != NULL ) free( printer );
    if ( procsetdir != NULL ) free( procsetdir );
    if ( printspooldir != NULL ) free( printspooldir );
    if ( printcmdargv != NULL ) free( printcmdargv );
    if ( operator != NULL ) free( operator );
    if ( printcapfile != NULL ) free( printcapfile );
    servername = fontfilename = printer = procsetdir = NULL;
    printspooldir = operator = printcapfile = NULL;

    if (( f = fopen( conffile, "r" )) == NULL ) {
	syslog( LOG_ERR, "unable to open %s: %m", conffile );
    } else {
	while ( fgets( line, sizeof( line ), f ) != NULL ) {
	    line[ strlen( line ) - 1 ] = '\0';
	    for( p = line; isspace( *p ); ++p );
	    if ( *p == '#' || *p == '\0' ) {
		continue;
	    }
	    if ( strncasecmp( p, CONF_CHOOSERNAME, sizeof(CONF_CHOOSERNAME)-1)
	      == 0 ) {
		servername = copyarg( p + sizeof(CONF_CHOOSERNAME)-1);
	    } else if ( strncasecmp( p, CONF_FONTFILE, sizeof(CONF_FONTFILE)-1)
	      == 0 ) {
		fontfilename = copyarg( p + sizeof(CONF_FONTFILE)-1);
	    } else if ( strncasecmp( p, CONF_PROCSETDIR,
	      sizeof(CONF_PROCSETDIR)-1) == 0 ) {
		procsetdir = copyarg( p + sizeof(CONF_PROCSETDIR)-1);
	    } else if ( strncasecmp( p, CONF_PRINTSPOOLDIR,
	      sizeof(CONF_PRINTSPOOLDIR)-1) == 0 ) {
		printspooldir = copyarg( p + sizeof(CONF_PRINTSPOOLDIR)-1);
	    } else if ( strncasecmp( p, CONF_PRINTER, sizeof(CONF_PRINTER)-1)
	      == 0 ) {
		printer = copyarg( p + sizeof(CONF_PRINTER)-1);
		if ( *printer == '|' ) {
		    pipedprinter = 1;
		}
	    } else if ( strncasecmp( p, CONF_OPERATOR, sizeof(CONF_OPERATOR)-1)
	      == 0 ) {
		operator = copyarg( p + sizeof(CONF_OPERATOR)-1);
	    } else if ( strncasecmp( p, CONF_PRINTCAP, sizeof(CONF_PRINTCAP)-1)
	      == 0 ) {
		printcapfile = copyarg( p + sizeof(CONF_PRINTCAP)-1);
	    } else {
		syslog( LOG_ERR, "unrecognized line %s in %s (continuing)", 
		  p, conffile );
	    }
	}
	fclose( f );
    }

    if ( procsetdir == NULL ) {
	procsetdir = copyarg( _PATH_PAPDPROCSETS );
    }
    if ( operator == NULL ) {
	operator = copyarg( CONF_DEF_OPERATOR );
    }
    if ( printer == NULL ) {
	printer = copyarg( CONF_DEF_PRINTER );
    }
    if ( printspooldir == NULL ) {
	printspooldir = copyarg( CONF_DEF_PRINTSPOOLDIR );
    }

    /* determine server name */
    if ( servername != NULL ) {
	service = malloc( strlen( servername ) + 1 );
    } else {
	service = malloc( MAXHOSTNAMELEN + 1 );
    }
    if ( service == NULL ) {
	return( -1 );
    }
    if (( host = malloc( MAXHOSTNAMELEN + 1 )) == NULL ||
	    gethostname( host, MAXHOSTNAMELEN ) != 0 ) {
	return -1;
    }
    host[ MAXHOSTNAMELEN ] = 0;
    if ( servername != NULL ) {
	strcpy( service, servername );
    } else {
	/* by default use first word of hostname for server name */
	char	*s;
	strcpy( service, host );
	if (( s = index( service, '.' )) != NULL ) {
	    *s = '\0';
	} 
	if (( servername = malloc( strlen( service ) + 1 )) == NULL ) {
	    return( -1 );
	}
    	strcpy( servername, service );
    }
    setproctitle( "initializing" );
#ifdef EBUG
    if ( debugflg ) {
	fprintf( stderr, "Initializing %s\n", service );
	fflush( stderr );
    }
#endif EBUG

    /* read the font file and build list of resident fonts */
    if ( fontfilename != NULL ) {
	if ( readfontfile( fontfilename ) < 0 ) {
	    syslog( LOG_ERR, "readfontfile %s: %m", fontfilename );
	    return -1;
	}
    }
    /* read the procedure set directory and build internal list */
    if ( readprocsetdir( procsetdir ) < 0 ) {
	syslog( LOG_ERR, "readprocsetdir %s: %m", procsetdir );
	return -1;
    }
    /* check the printer (read printer capabilities) */
    if ( !pipedprinter && printer != NULL && readprintcap( printer ) < 0 ) {
	syslog( LOG_ERR, "readprintcap for %s", printer );
	return -1;
    }

    /* register name via nbp and open pap listening socket */
    if (( ph = pap_slinit( service, 0, 8, STATUSIDLE )) == NULL ) {
	pap_logerror( service );
	return -1;
    }
    free( service );
    setproctitle( "%s/%s accepting jobs", servername, printer );
    return 0;
}
