/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <strings.h>
#include <ctype.h>

#include <netatalk/at.h>
#include <atalk/atp.h>
#include "pap.h"
#include "papd.h"
#include "lw.h"

char			*malloc();
char			*realloc();
char			*index();
char			*rindex();

extern int		debugflg;
extern char		**fontlist;
extern int		dsc_majorvers;
extern int		dsc_minorvers;


readfontfile( fontfilename )
    char	*fontfilename;
{
    int		i, len;
    char	**s, fontname[ 65 ];
    FILE	*f;

    if (( f = fopen( fontfilename, "r" )) == NULL ) {
	return( -1 );
    }
    if ( fontlist != NULL ) {
	/* we must be replacing an old list -- free old one */
	for ( s = fontlist; *s != NULL; ++s ) {
	    free( *s );
	}
	free( fontlist );
    }
    if (( fontlist = (char **) malloc( sizeof(char **))) == NULL ) {
	return( -1 );
    }
    for ( i = 1; fgets( fontname, 64, f ) != NULL; ++i ) {
	if (( fontlist = (char **) realloc( fontlist,
	  (i+1) * sizeof(char **))) == NULL ) {
	    return( -1 );
	}
	len = strlen( fontname ) + 1;	/* room for leading '/' */
	if (( fontlist[i-1] = malloc( len + 1 )) == NULL ) {
	    return( -1 );
	}
	fontlist[i-1][0] = '/';
	strcpy( fontlist[i-1] + 1, fontname );
    }

    fclose( f );
    fontlist[ i-1 ] = NULL;
    return( 0 );
}


q_font( ph, qt, bufp, blen )
    PAP			ph;
    struct query_table	*qt;
    char		**bufp;
    int			*blen;
{
/* handle a font query */ 
    static char	reply[ 256 ];
    int		i, foundfont, len;
    char	*fontname, *next, *p, savec;

    if ( swallow_query( bufp, blen ) == NULL ) {
	return( -1 );
    }

#ifdef EBUG 
    if ( debugflg ) {
	fprintf( stderr, "q_font list is <%s>\n", qt->query_params );
	fflush( stderr );
    }
#endif EBUG

    for ( fontname = qt->query_params; *fontname != '\0'; fontname = next ) {
	for ( next = fontname; *next != '\0' && !isspace( *next ); ++next ) {
	    ;
	}
	if ( *next != '\0' ) {
	    *next++ = '\0';
	    while ( *next != '\0' && isspace( *next )) {
		++next;
	    }
	}

	foundfont = 0;

	if ( fontlist != NULL ) {
#ifdef EBUG
	    if ( debugflg ) {
		fprintf( stderr, "q_font checking for <%s>\n", fontname );
		fflush( stderr );
	    }
#endif EBUG
	    for ( i = 0; !foundfont && fontlist[ i ] != NULL; ++i ) {
#ifdef EBUG
		if ( debugflg ) {
		    fprintf( stderr, "q_font checking against <%.*s>\n",
			    strlen( fontlist[ i ] ) - 2, 1 + fontlist[ i ] );
		    fflush( stderr );
		}
#endif EBUG
		len = strlen( fontlist[ i ] ) - 1;
		savec = fontlist[ i ][ len ];
		fontlist[ i ][ len ] = '\0';
		foundfont = ( strcasecmp( 1 + fontlist[ i ], fontname ) == 0 );
		fontlist[ i ][ len ] = savec;
	    }
	}

	p = reply;

	if ( dsc_majorvers <= 2 && dsc_minorvers < 1 ) {
	    *p++ = foundfont ? '1' : '0';
	} else {
	    *p++ = '/';
	    strcpy( p, fontname );
	    p += strlen( fontname );
	    *p++ = ':';
	    strcpy( p, foundfont ? "Yes" : "No" );
	    p += strlen( p );
	}
	*p++ = EOL;

	if ( pap_write( ph, reply, p - reply, 0 ) < 0
		|| pap_get_request( ph ) != 0 ) {
	    return( -1 );
	}
    }

    if ( dsc_majorvers > 2 || ( dsc_majorvers == 2 && dsc_minorvers >= 1 )) {
	p = reply;
	*p++ = '*';
	*p++ = EOL;
	if ( pap_write( ph, reply, p - reply, 0 ) < 0 ) {
	    return( -1 );
	}
    }

    return( 0 );
}


q_fontlist( ph, qt, bufp, blen )
    PAP			ph;
    struct query_table	*qt;
    char		**bufp;
    int			*blen;
{
/* handle a fontlist query */ 
    static char	reply[ 2 ];
    int		i, len;
    char	*send;

    if ( swallow_query( bufp, blen ) == NULL ) {
	return( -1 );
    }
    /* send back reply */
    if ( fontlist != NULL ) {
#ifdef EBUG
	if ( debugflg ) {
	    fprintf( stderr, "q_fontlist sending list of fonts\n" );
	    fflush( stderr );
	}
#endif EBUG
	for ( i = 0; fontlist[ i ] != NULL; ++i ) {
	    send = fontlist[ i ];
	    if ( dsc_majorvers <= 2 && dsc_minorvers < 1 ) {
		++send;
	    }
	    if ( pap_write( ph, send, strlen( send ), 0 ) < 0
		    || pap_get_request( ph ) != 0 ) {
		return( -1 );
	    }
	}
    }
    reply[ 0 ] = '*';
    reply[ 1 ] = '\n'; /* EOL */
    if ( pap_write( ph, reply, 2, 0 ) < 0 ) {
	return( -1 );
    }

    return( 0 );
}
