#!/bin/sh
#
# fontlist2 printer
#
# Dump the list of resident fonts to stdout
# This script uses pap....
#

PAP=/usr/local/atalk/etc/pap
USAGE="Usage: fontlist2 printer"

while :
do
	case $# in
	0)	break
		;;
	esac

	case "$1" in
	-*)	echo "$0: bad option $1" >&2
		echo $USAGE
		exit 1
		;;
	*)	PRINTER="$1"
		;;
	esac
	shift
done

if [ x"$PRINTER" = x ]; then
	echo $USAGE
	exit 1
fi

$PAP -p "$PRINTER" <<EOF
FontDirectory { pop = flush } forall
EOF
exit 0
