#!/bin/sh
#
# fontlist [-P printer]
#
# Print the list of resident fonts
# Caveat: we assume there are no more than 60 or so resident fonts
#

USAGE="Usage: fontlist [-P printer]"

while :
do
	case $# in
	0)	break
		;;
	esac

	case "$1" in
	-P)	shift; PRINTERARG="-P$1"
		;;
	-P*)	PRINTERARG="$1"
		;;
	-*)	echo "$0: bad option $1" >&2
		echo $USAGE
		exit 1
		;;
	esac
	shift
done

if [ x"$PRINTERARG" = x ]; then
	if [ x"$PRINTER" != x ]; then
		PRINTERARG=-P$PRINTER
	fi
fi

lpr $PRINTERARG <<EOF
%!
/Helvetica findfont
12 scalefont setfont
72 720 dup /ycoord exch def moveto
(Resident fonts:) show
FontDirectory {
	84 ycoord 12 sub dup /ycoord exch def moveto
	pop 255 string cvs show
} forall
showpage
EOF
exit 0
