/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/errno.h>
#include <sys/dir.h>
#include <sys/uio.h>
#include <strings.h>

#include <netatalk/at.h>
#include <atalk/nbp.h>
#include <atalk/atp.h>
#include "pap.h"
#include "papd.h"
#include "paperrno.h"
#include "lw.h"

char			*malloc();
char			*realloc();
char			*index();
char			*rindex();

extern int		errno;
extern char		*sys_errlist[];
extern int		sys_nerr;

extern int		debugflg;
extern char		**fontlist;
extern char		*procsetdir;
extern struct procset	**procsetlist;

#ifdef notdef
breakupname( name, objp, typep, zonep )
    char	*name;
    char	**objp;
    char	**typep;
    char	**zonep;
{
    static char	*namecpy = NULL;
    char	*p;

    if ( namecpy != NULL ) {
	/* free memory from last call to breakup_name */
	free( namecpy );
    }
    if (( namecpy = malloc( strlen( name ) + 1 )) == NULL ) {
	return -1;
    }
    strcpy( namecpy, name );

    if (( p = rindex( namecpy, '@' )) != NULL ) {	/* grab the zone */
	*zonep = p + 1;
	*p = '\0';
    }

    if (( p = rindex( namecpy, ':' )) != NULL ) {	/* grab the type */
	*typep = p + 1;
	*p = '\0';
    }
    if ( *namecpy == '\0' ) {
	pap_errno = PAP_EBADNAME;
	return( -1 );
    }

    *objp = namecpy;
    return( 0 );
}

breakupname( name, objp, typep, zonep )
    char	*name;
    char	**objp;
    char	**typep;
    char	**zonep;
{
    static char	*wildcard = "*";
    static char	*namecpy = NULL;

    if ( namecpy != NULL ) {
	/* free memory from last call to breakup_name */
	free( namecpy );
    }
    if (( namecpy = malloc( strlen( name ) + 1 )) == NULL ) {
	return -1;
    }
    strcpy( namecpy, name );
    *objp = namecpy;
    *typep = index( namecpy, ':' );
    *zonep = index( (*typep == NULL ? namecpy : (*typep)+1 ), '@' );
    if ( *typep == NULL ) {
	*typep = wildcard;
    } else {
	**typep = '\0';
	++(*typep);
    }
    if ( *zonep == NULL ) {
	*zonep = wildcard;
    } else {
	**zonep = '\0';
	++(*zonep);
    }
    if ( strlen( *objp ) < 1 ) {
	*objp = wildcard;
    }
    return 0;
}
#endif notdef


char	*
getline( bufp, blen )
    char	**bufp;
    int		*blen;
{
/* return pointer to next line from bufp (NULL if no end of line is found) */
    char	*line;
    char	*s;

    line = *bufp;
    if ( *blen < 1 ) {
#ifdef EBUG
	if ( debugflg ) {
	    fprintf( stderr, "getline returns NULL len=%d\n", *blen );
	    fflush( stderr );
	}
#endif EBUG
	return NULL;
    }
    if (( s = pap_eol( *bufp, *blen )) == NULL ) {
	/* special handling if packet breaks a line */
	s = *bufp + *blen;
	*bufp = NULL;
	*s = EOL;
    } else {
	*bufp = s + 1;
    }
    *blen -= ( linelen( line )+1 );
    return line;
}


char	*
pap_eol( buf, blen )
    char	*buf;
    int		blen;
{
    char	*end;

    end = buf + blen;
    while ( buf < end && *buf != EOL && *buf != NEWLINE ) {
	++buf;
    }
    return ( buf < end ? buf : NULL );
}


linelen( line )
    char	*line;
{
    char	*base;

    for ( base = line; *line != EOL && *line != NEWLINE; ++line ); 
    return ( line - base );
}


pap_fperror( f,  s )
    FILE	*f;
    char	*s;
{
    int	pid;

    pid = getpid();

    if ( pap_errno == 0 ) {	/* system error */
	if ( errno < 0 || errno > sys_nerr ) {
	    fprintf( f, "%s[%d]: Unknown Error (%d)\n", s, pid, errno );
	} else {
	    fprintf( f, "%s[%d]: %s\n", s, pid, sys_errlist[ errno ] );
	}
    } else {
	if ( pap_errno < 0 || pap_errno > pap_nerr ) {
	    fprintf( f, "%s[%d]: Unknown PAP Error (%d)\n", s, pid, pap_errno );
	} else {
	    fprintf( f, "%s[%d]: %s\n", s, pid, pap_errlist[ pap_errno ] );
	}
    }
}
