/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#ifdef EBUG
#include <stdio.h>
#endif EBUG
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/syslog.h>
#include <sys/errno.h>
#include <sys/uio.h>
#include <netatalk/endian.h>
#include <netatalk/at.h>
#include <atalk/nbp.h>
#include <atalk/atp.h>
#include <strings.h>
#include "pap.h"
#include "paperrno.h"

extern char	*malloc();
extern char	*realloc();
extern int	errno;
extern int	debugflg;

PAP
pap_slinit( name, port, quantum, status )
    char		*name;		/* name to register as */
    u_char		port;		/* server port (0 = pick next) */
    int			quantum;	/* 1-8 512 byte bufs */
    char		*status;	/* initial status string */
{
    PAP			paph;
    ATP			atph;

    /* check parameters
    */
    if ( quantum < 1 || quantum > 8 || strlen( status ) > PAP_MAXSTATUSLEN ) {
	errno = EINVAL;
	return NULL;
    }

    /* open responding socket via atp
    */
    if (( atph = atp_open( port )) == NULL ) {
	return NULL;
    }

    /* allocate handle and copy status
    */
    if (( paph = (PAP) malloc( sizeof( struct pap_handle ))) == NULL ||
      ( paph->paph_status = (char *) malloc( PAP_MAXSTATUSLEN + 1 ))
      == NULL || ( paph->paph_name = (char **) malloc( sizeof( char ** )))
      == NULL ) {
	atp_close( atph );
	return NULL;
    }
    paph->paph_name[0] = NULL;
    strcpy( paph->paph_status, status );
    paph->paph_atph = atph;
    paph->paph_recvquantum = quantum;		/* server's (my) quantum */
    paph->paph_sendseqnum = paph->paph_recvseqnum = 0;

    /* register the name using nbp
    */
    if ( pap_regname( paph, name ) < 0 ) {
	atp_close( atph );
	pap_freesl( paph );
	pap_errno = PAP_ENAMEREGISTER;
	return NULL;
    }

    return paph;
}


pap_slclose( paph, deregister )
    PAP		paph;
    int		deregister;
{
    int		i;
    char	*obj, buf[ MAXHOSTNAMELEN ], *type, *zone, *p;

    if ( deregister ) {
	/* de-register all names for socket and close sls
	*/
	for ( i = 0; paph->paph_name[i] != NULL; ++i ) {
	    if ( gethostname( buf, sizeof( buf )) < 0 ) {
		return( -1 );
	    }
	    if (( p = index( buf, '.' )) != NULL ) {
		*p = '\0';
	    }
	    obj = buf;
	    type = LWTYPE;
	    zone = "*";
	    nbp_name( paph->paph_name[i], &obj, &type, &zone ); 
	    nbp_unrgstr( obj, type, zone );
	}
    }
    if ( atp_close( paph->paph_atph ) < 0 ) {
	return -1;
    }
    pap_freesl( paph );
    return 0;
}


pap_regname( paph, name )
    PAP		paph;
    char	*name;
{
    int		i;
    char	*obj, buf[ MAXHOSTNAMELEN ], *type, *zone, *p;

    /* add name to list of registered names in paph
    */
    for ( i = 0; paph->paph_name[ i ] != NULL; ++i )
	;
    if (( paph->paph_name =
	    (char **) realloc( paph->paph_name, ( i + 2 ) * sizeof( char ** )))
	    == NULL ||
	    ( paph->paph_name[i] = (char *) malloc( strlen( name ) + 1 ))
	    == NULL ) {
	return -1;
    }
    strcpy( paph->paph_name[i], name );
    paph->paph_name[i+1] = NULL;

    if ( gethostname( buf, sizeof( buf )) < 0 ) {
	return( -1 );
    }
    if (( p = index( buf, '.' )) != NULL ) {
	*p = '\0';
    }
    obj = buf;
    type = LWTYPE;
    zone = "*";
    if ( nbp_name( name, &obj, &type, &zone ) < 0 ) {
	return -1;
    }
    if ( nbp_rgstr( atp_sockaddr( paph->paph_atph ), obj, type, zone ) < 0 ) {
	pap_errno = PAP_ENAMEREGISTER;
	return -1;
    }

    return 0;
}

#ifdef notdef
pap_remname( paph, name )
    PAP		paph;
    char	*name;
{
    int		i;
    char	*obj, *type, *zone;

    for ( i = 0; paph->paph_name[i] != NULL; ++i ) {
	if ( strcasecmp( paph->paph_name[i], name ) == 0 ) break;
    }
    if ( paph->paph_name[i] == NULL ) {
	pap_errno = PAP_ENOSUCHNAME;
	return -1;
    }
    type = LWTYPE;
    zone = "*";
    if ( breakupname( paph->paph_name[i], &obj, &type, &zone ) < 0 ) {
	return -1;
    } 
    if ( nbp_unrgstr( obj, type ) != 0 ) {
	pap_errno = PAP_EUNREGISTER;
	return -1;
    }

    paph->paph_name[i][0] = '\0';
    return 0;
}
#endif notdef

pap_herestatus( paph, status )
    PAP		paph;
    char	*status;
{
    /* check parameters
    */
    if ( strlen( status ) > PAP_MAXSTATUSLEN ) {
	errno = EINVAL;
	return -1;
    }
    strcpy( paph->paph_status, status );
    return 0;
}


pap_freesl( paph )
    PAP		paph;
{
    int		i;

    free( paph->paph_status );
    if ( paph->paph_name != NULL ) {
	for ( i = 0; paph->paph_name[i] != NULL; ++i ) {
	    free( paph->paph_name[i] );
	}
	free( paph->paph_name );
    }
    free( paph );
}


PAP
pap_getnextjob( paphp )
    PAP		*paphp;
{
    struct atp_block	atpb;
    struct sockaddr_at	saddr;
    char		rbuf[ ATP_MAXDATA ];
    char		sbuf[ ATP_MAXDATA ];
    struct iovec	iov;
    PAP			newph = NULL;
    u_short		result;
    int			mask;

    do {
	bzero( (char *) &saddr, sizeof( struct sockaddr_at ));
	saddr.sat_family = AF_APPLETALK;
	saddr.sat_port = ATADDR_ANYPORT;
	saddr.sat_addr.s_net = ATADDR_ANYNET;
	saddr.sat_addr.s_node = ATADDR_ANYNODE;
	atpb.atp_saddr = &saddr;
	atpb.atp_rreqdata = rbuf;
	atpb.atp_rreqdlen = ATP_MAXDATA;
	
	/* unblock signals -- this is where we catch SIGCHLD and SIGHUP */
	mask = sigsetmask( 0 );
	while ( atp_rreq( (*paphp)->paph_atph, &atpb ) < 0 ) {
	    if ( errno != EINTR ) return NULL;
	}
	/* block signals again*/
	sigsetmask( mask );
#ifdef EBUG
	if ( debugflg ) {
	    timefprint( stderr );
	    fprintf( stderr, "got op=%d in pap_getnextjob\n", rbuf[ 1 ] );
	    bfprint( stderr, rbuf, atpb.atp_rreqdlen );
	    fflush( stderr );
	}
#endif EBUG
	switch ( rbuf[ 1 ] ) {

	case PAP_SENDSTATUS:
	    bzero( sbuf, 8 );
	    sbuf[ 1 ] = PAP_STATUS;
	    sbuf[ 8 ] = strlen( (*paphp)->paph_status );
	    bcopy( (*paphp)->paph_status, &sbuf[ 9 ], strlen( (*paphp)->paph_status ));
	    iov.iov_base = sbuf;
	    iov.iov_len = strlen( (*paphp)->paph_status ) + 9;
	    atpb.atp_sresiov = &iov;
	    atpb.atp_sresiovcnt = 1;
	    if ( atp_sresp( (*paphp)->paph_atph, &atpb ) < 0 ) {
		syslog( LOG_ERR, "atp_sresp in pap_getnextjob: %m" );
	    }
	    break;
	case PAP_OPENCONN:
	    /* sanity check */
	    if ( rbuf[ 5 ] > 8 ) {
		break;
	    }
	    if (( newph = (PAP) malloc( sizeof( struct pap_handle ))) == NULL ||
	      ( newph->paph_status = (char *) malloc( PAP_MAXSTATUSLEN + 1 ))
	      == NULL ) {
		return NULL;
	    } 
	    if (( newph->paph_atph = atp_open( 0 )) == NULL ) {
		free( newph->paph_status );
		free( newph );
		return NULL;
	    }
	    (*paphp)->paph_saddr = newph->paph_saddr = saddr;
	    newph->paph_saddr.sat_port = rbuf[ 4 ];
	    newph->paph_connid = rbuf[ 0 ];
	    strcpy( newph->paph_status, (*paphp)->paph_status );
	    newph->paph_recvquantum = (*paphp)->paph_recvquantum;
	    newph->paph_sendquantum = rbuf[ 5 ];
	    newph->paph_name = NULL;
	    newph->paph_recvseqnum = newph->paph_sendseqnum = 0;
	    sbuf[ 0 ] = newph->paph_connid;
	    sbuf[ 1 ] = PAP_OPENCONNREPLY;
	    sbuf[ 2 ] = sbuf[ 3 ] = 0;
	    sbuf[ 4 ] = atp_sockaddr( newph->paph_atph )->sat_port;
	    sbuf[ 5 ] = newph->paph_recvquantum;
	    result = htons( PAP_RESULT_READY );
	    bcopy( &result, &sbuf[ 6 ], 2 ); 
	    sbuf[ 8 ] = strlen( newph->paph_status );
	    bcopy( newph->paph_status, &sbuf[ 9 ],
	      strlen( newph->paph_status ));
	    iov.iov_base = sbuf;
	    iov.iov_len = strlen( newph->paph_status ) + 9;
/*
	    sleep( 1 );
*/
	    atpb.atp_sresiov = &iov;
	    atpb.atp_sresiovcnt = 1;
	    if ( atp_sresp( (*paphp)->paph_atph, &atpb ) < 0 ) {
		syslog( LOG_ERR, "atp_sresp in pap_getnextjob: %m" );
		newph = NULL;
	    }
	    break;
	
	default:
	    ;
	}
    } while ( newph == NULL );

    return newph;
}
