/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

struct pap_handle {
    ATP			paph_atph;		/* ATP handle */
    struct sockaddr_at	paph_saddr;		/* destination address */
    u_char		paph_connid;		/* connection id */
    char		*paph_status;		/* current server status */
    u_char		paph_sendquantum;	/* send and recv quantums */
    u_char		paph_recvquantum;		
    char		**paph_name;		/* registered as... */
    u_short		paph_sendseqnum;	/* sequence numbers for data */
    u_short		paph_recvseqnum;
};

typedef struct pap_handle	*PAP;

#define pap_ddpsocket( h )	((h)->paph_atph->atph_socket)

/* PAP function codes */
#define PAP_OPENCONN		1
#define PAP_OPENCONNREPLY	2
#define PAP_SENDDATA		3
#define PAP_DATA		4
#define PAP_TICKLE		5
#define PAP_CLOSECONN		6
#define PAP_CLOSECONNREPLY	7
#define PAP_SENDSTATUS		8
#define PAP_STATUS		9

/* PAP Parameters */
#define PAP_MAXQUANTUM		8
#define PAP_MAXDATA		512
#define PAP_MAXSTREAM		(512*PAP_MAXQUANTUM)
#define PAP_MAXSTATUSLEN	255		/* plus length byte */
#define PAP_OPEN_RETRY_TIME	2		/* seconds */
#define PAP_OPEN_RETRY_CNT	10
#define PAP_TICKLE_TIME		60
#define PAP_CONN_TIME		120
#define PAP_DATA_RETRY_TIME	15
#define PAP_DATA_RETRY_CNT	-1		/* infinite */
#define PAP_RESULT_BUSY		0xffff
#define PAP_RESULT_READY	0x0000

#define PAP_SELECT_READ		ATP_TRESP	/* for pap_select() call */
#define PAP_SELECT_REQUEST	ATP_TREQ

#define PAP_PRINTERNAMEFILE	".paprc"

#define LWOBJ			"LaserWriter Plus"
#define LWTYPE			"LaserWriter"

/* functions: client only */
int pap_nametoaddr();
PAP pap_open();
int pap_status();
int pap_close();
char *pap_printername();

/* server only */
PAP pap_slinit();
PAP pap_getnextjob();
int pap_slclose();
int pap_regname();
#ifdef notdef
int pap_remname();
#endif notdef
int pap_herestatus();

/* client and server */
int pap_read();
int pap_initiate_read();
int pap_read_data();
int pap_select();
int pap_get_request();
int pap_write();
