/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

struct query_table {
    char	*query_text;
    int		query_textlen;
    int		(*query_handler)();
    char	*query_params;
};

struct procset {
    char	*procset_name;
    u_short	procset_version;
    u_short	procset_release;
};

struct comm {
    int		comm_tag;
    char	*comm_str;
    int		comm_len;
};

#define STATUSIDLE		"status: print spooler idle"
#define STATUSWORKING		"status: print spooler processing job(s)"
#define COMMENTCHAR		'%'
#define PAPEOF			0
#define PAPEOF_STR		"%%EOF"
#define BEGINPROCSET		1
#define BEGINPROCSET_STR	"%%BeginProcSet"
#define ENDPROCSET		2
#define ENDPROCSET_STR		"%%EndProcSet"
#define INCLUDEPROCSET		3
#define INCLUDEPROCSET_STR	"%%IncludeProcSet"
#define STARTJOB		4
#define STARTJOB_STR		"%!"
#define ENDJOB			5
#define ENDJOB_STR		"%%Trailer"
#define TITLE			6
#define TITLE_STR		"%%Title"
#define USER			7
#define USER_STR		"%%For"
#define BEGINEXITSERVER		8
#define BEGINEXITSERVER_STR	"%%BeginExitServer"
#define BEGINQUERY		"%%?Begin"
#define ENDQUERY		"%%?End"

#define DSC_CONFORMANT		"PS-Adobe-"
#define DSC_CONFORMANT_LEN	(sizeof( DSC_CONFORMANT )-1)

#define NEWLINE			0x0a
#define EOL			0x0d

#define Q_FEATURE		"FeatureQuery"
#define Q_FILE			"FileQuery"
#define Q_FONTLIST		"FontListQuery"
#define Q_FONT			"FontQuery"
#define Q_PRINTER		"PrinterQuery"
#define Q_PROCSET		"ProcSetQuery"
#define Q_QUERY			"Query"
#define Q_VMSTATUS		"VMStatusQuery"

#define BEGINPOSTSCRIPT		"%!\r"
#define BEGINPOSTSCRIPT_LEN	(sizeof( BEGINPOSTSCRIPT )-1)

#define KEY_EPS_STR		"EPSF"
#define KEY_EPS_STR_LEN		(sizeof( KEY_EPS_STR )-1)
#define KEY_QUERY_STR		"QUERY"
#define KEY_QUERY_STR_LEN	(sizeof( KEY_QUERY_STR )-1)
#define KEY_EXIT_STR		"EXITSERVER"
#define KEY_EXIT_STR_LEN	(sizeof( KEY_EXIT_STR )-1)

struct query_table	*find_query();
char			*getline();
char			*swallow_query();
char			*pap_eol();
struct procset		*str2procset();
