/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <sys/errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/uio.h>
#include <sys/syslog.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <netatalk/endian.h>
#include <netatalk/at.h>
#include <atalk/atp.h>
#include <atalk/asp.h>
#include <atalk/afp.h>
#include <atalk/paths.h>
#include <signal.h>
#include <stdio.h>
#include <strings.h>

#include "switch.h"
#include "icon.h"
#include "globals.h"
#include "conf.h"

#ifdef ATP_MAXDATA
#undef ATP_MAXDATA
#endif
#define ATP_MAXDATA		578

char	replybuf[ ATP_MAXDATA * 8 ];			/* 8 atp packets */
int	debug = 0;
int	nologin = 0;
int	connections = 5;
char	*defaultvol = _PATH_AFPDCONF;
char	*Obj, *Type = "AFPServer", *Zone = "*";
ASP	child;

#if !defined( ibm032 ) && !defined( _IBMR2 )
    void
#endif ibm032 _IBMR2
afp_goaway( sig )
    int		sig;
{
    syslog( LOG_INFO, "shutting down on signal %d", sig );
    if ( nbp_unrgstr( Obj, Type, Zone ) < 0 ) {
	syslog( LOG_ERR, "afp_goaway: nbp_unrgstr: %m" );
    }
    switch( sig ) {
    case SIGTERM :
	if ( asp_attentionall( htons((short)0x8000 )) < 0 ) {
	    syslog( LOG_ERR, "afp_goaway: asp_attentionall: %m" );
	}
	break;
    case SIGHUP :
	if ( asp_attentionall( htons((short)0x800A )) < 0 ) {
	    syslog( LOG_ERR, "afp_goaway: asp_attentionall: %m" );
	}
	break;
    default :
	syslog( LOG_ERR, "afp_goaway: bad signal" );
    }
    if ( asp_kill( sig ) < 0 ) {
	syslog( LOG_ERR, "afp_goaway: asp_kill: %m" );
    }
    if ( sig == SIGTERM ) {
	exit( 0 );
    }
    return;
}

#if !defined( ibm032 ) && !defined( _IBMR2 )
    void
#endif ibm032 _IBMR2
afp_die()
{
    /*
     * Let parent receive TERM before we exit,
     * during shutdown.
     */
    sleep( 10 );
    exit( 0 );
}

#if !defined( ibm032 ) && !defined( _IBMR2 )
    void
#endif ibm032 _IBMR2
afp_timedown()
{
    struct sigvec	sv;
    struct itimerval	it;

    it.it_interval.tv_sec = 0;
    it.it_interval.tv_usec = 0;
    it.it_value.tv_sec = 600;
    it.it_value.tv_usec = 0;
    if ( setitimer( ITIMER_REAL, &it, 0 ) < 0 ) {
	syslog( LOG_ERR, "afp_timedown: setitimer: %m" );
	exit( 1 );
    }
    sv.sv_handler = afp_die;
    sv.sv_mask = 0;
    sv.sv_flags = 0;
    if ( sigvec( SIGALRM, &sv, 0 ) < 0 ) {
	syslog( LOG_ERR, "afp_timedown: sigvec: %m" );
	exit( 1 );
    }
}

main( ac, av )
    int		ac;
    char	**av;
{
    ATP			atp;
    ASP			asp;
    struct sigvec	sv;
    char		*p, *buf, data[ ATP_MAXDATA ], *status;
    int			c, buflen, func, rbuflen;
    char		hostname[ MAXHOSTNAMELEN ];
    char		*server = 0;
    extern char		*optarg;
    extern int		optind;

    umask( 0 );		/* so inherited file permissions work right */
    if ( gethostname( hostname, sizeof( hostname )) < 0 ) {
	perror( "gethostname" );
	exit( 1 );
    }
    if (( p = index( hostname, '.' )) != 0 ) {
	*p = '\0';
    }

    while (( c = getopt( ac, av, "dn:f:c:" )) != EOF ) {
	switch ( c ) {
	case 'd' :
	    debug++;
	    break;
	case 'n' :
	    server = optarg;
	    break;
	case 'f' :
	    defaultvol = optarg;
	    break;
	case 'c' :
	    connections = atoi( optarg );
	    break;
	default :
	    fprintf( stderr, "Unknown option -- '%c'\n", c );
	    exit( 1 );
	}
    }

    /*
     * Disassociate from controlling tty.
     */
    if ( !debug ) {
	int		i, dt;

	switch ( fork()) {
	case 0 :
	    dt = getdtablesize();
	    for ( i = 0; i < dt; i++ ) {
		(void)close( i );
	    }
	    if (( i = open( "/dev/tty", O_RDWR )) >= 0 ) {
		(void)ioctl( i, TIOCNOTTY, 0 );
		setpgrp( 0, getpid());
		(void)close( i );
	    }
	    break;
	case -1 :
	    perror( "fork" );
	    exit( 1 );
	default :
	    exit( 0 );
	}
    }

    if (( p = rindex( av[ 0 ], '/' )) == NULL ) {
	p = av[ 0 ];
    } else {
	p++;
    }

#ifdef ultrix
    openlog( p, LOG_PID );
#else ultrix
    openlog( p, LOG_NDELAY|LOG_PID, LOG_DAEMON );
#endif ultrix

    if (( status = (char *)malloc( ATP_MAXDATA )) == NULL ) {
	syslog( LOG_ERR, "main: malloc: %m" );
	exit( 1 );
    }

    /*
     * This must be before status_server(), so we can get the name correct.
     */
    Obj = hostname;
    if ( nbp_name( server, &Obj, &Type, &Zone )) {
	syslog( LOG_ERR, "main: can't parse %s", server );
	exit( 1 );
    }

    /*
     * These routines must be called in order -- earlier calls
     * set the offsets for later calls.
     */
    status_flags( status );
    status_server( status, Obj );
    status_machine( status );
    status_versions( status );
    status_uams( status );
    c = status_icon( status );

    if (( atp = atp_open( 0 )) == NULL ) {
	syslog( LOG_ERR, "main: atp_open: %m" );
	exit( 1 );
    }
    if (( asp = asp_init( atp )) == NULL ) {
	syslog( LOG_ERR, "main: asp_init: %m" );
	exit( 1 );
    }

    asp_setstatus( asp, status, c );

    if ( nbp_rgstr( atp_sockaddr( atp ), Obj, Type, Zone ) < 0 ) {
	syslog( LOG_ERR, "Can't register %s:%s@%s", Obj, Type, Zone );
	exit( 1 );
    }
    syslog( LOG_INFO, "%s:%s@%s started", Obj, Type, Zone );

    sv.sv_handler = afp_goaway;
    sv.sv_mask = 0;
    sv.sv_flags = 0;
    if ( sigvec( SIGHUP, &sv, 0 ) < 0 ) {
	syslog( LOG_ERR, "main: sigvec: %m" );
	exit( 1 );
    }
    if ( sigvec( SIGTERM, &sv, 0 ) < 0 ) {
	syslog( LOG_ERR, "main: sigvec: %m" );
	exit( 1 );
    }

    if (( child = asp_getsession( asp, connections )) == NULL ) {
	syslog( LOG_ERR, "main: asp_getsession: unknown error" );
	exit( 1 );
    }

    sv.sv_handler = afp_timedown;
    sv.sv_mask = 0;
    sv.sv_flags = 0;
    if ( sigvec( SIGHUP, &sv, 0 ) < 0 ) {
	syslog( LOG_ERR, "main: sigvec: %m" );
	exit( 1 );
    }

    sv.sv_handler = afp_die;
    sv.sv_mask = 0;
    sv.sv_flags = 0;
    if ( sigvec( SIGTERM, &sv, 0 ) < 0 ) {
	syslog( LOG_ERR, "main: sigvec: %m" );
	exit( 1 );
    }

    for (;;) {
	buf = data;
	buflen = sizeof( data );
	switch (( c = asp_getrequest( child, &buf, &buflen ))) {
	case ASPFUNC_CLOSE :
	    asp_close( child );
	    syslog( LOG_INFO, "close session" );
	    exit( 0 );
	    break;
	case ASPFUNC_CMD :
	    func = (u_char)buf[ 0 ];
	    if ( debug ) {
		syslog( LOG_DEBUG, "command: %d", func );
		bprint( buf, buflen );
	    }
	    if ( afp_switch[ func ] != NULL ) {
		/*
		 * The function called from afp_switch is expected to
		 * read it's parameters out of buf, put it's
		 * results in replybuf (updating rbuflen), and
		 * return an error code.
		 */
		rbuflen = sizeof( replybuf );
		c = (*afp_switch[ func ])( buf, buflen, replybuf, &rbuflen );
		if ( debug ) {
		    syslog( LOG_DEBUG, "reply: %d, child %x", c, child );
		    bprint( replybuf, rbuflen );
		}
		asp_cmdreply( child, htonl( c ), replybuf, rbuflen );
	    }
	    break;
	case ASPFUNC_WRITE :
	    func = (u_char)buf[ 0 ];
	    if ( debug ) {
		syslog( LOG_DEBUG, "(write) command: %d\n", func );
	    }
	    if ( afp_switch[ func ] != NULL ) {
		rbuflen = sizeof( replybuf );
		c = (*afp_switch[ func ])( child, buf, buflen, replybuf,
			    &rbuflen );
		if ( debug ) {
		    syslog( LOG_DEBUG, "(write) reply code: %d\n", c );
		}
		asp_wrtreply( child, htonl( c ), replybuf, rbuflen );
	    }
	    break;
	default:
	    syslog( LOG_ERR, "main: asp_getrequest: bad return %d", c );
	    break;
	}
    }
}

status_server( data, server )
    char	*data, *server;
{
    struct afp_status	*status;
    int			len;

    status = (struct afp_status *)data;
    data += sizeof( struct afp_status );
    len = strlen( server );
    *data++ = len;
    bcopy( server, data, len );
    data += len;
    status->as_machoff = htons( data - (char *)status );
}

status_machine( data )
    char	*data;
{
    struct afp_status	*status;
    int			len;
#ifdef AFS
    char		*machine = "afs";
#else !AFS
    char		*machine = "unix";
#endif

    status = (struct afp_status *)data;
    data += ntohs( status->as_machoff );
    len = strlen( machine );
    *data++ = len;
    bcopy( machine, data, len );
    data += len;
    status->as_versoff = htons( data - (char *)status );
}

status_icon( data )
    char	*data;
{
    struct afp_status	*status;
    int			ret;

    status = (struct afp_status *)data;
    if ( icon == NULL ) {
	ret = ntohs( status->as_iconoff );
	status->as_iconoff = 0;
	return( ret );
    } else {
	data += ntohs( status->as_iconoff );
	bcopy( icon, data, sizeof( icon ));
	data += sizeof( icon );
	return( data - (char *)status );
    }
}

status_flags( data )
    char	*data;
{
    struct afp_status	*status;

    status = (struct afp_status *)data;

    status->as_flags = AFPSRVRINFO_COPY;
#ifdef AFSCHANGEPW
    status->as_flags |= AFPSRVRINFO_PASSWD;
#endif AFSCHANEPW
    status->as_flags = htons( status->as_flags );
}

pdesc( f )
    FILE	*f;
{
    int		i, o, d;
    extern int	errno;

    d = getdtablesize();

    for ( i = 0; i < d; i++ ) {
	if ( ioctl( i, FIOGETOWN, &o ) < 0 ) {
	    if ( errno == EBADF ) {
		fputs( "0", f );
	    } else {
		fputs( "1", f );
	    }
	} else {
	    fputs( "1", f );
	}
    }
    fputs( "\n", f );
    fflush( stdout );
}
