/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <sys/param.h>
#include <strings.h>
#include <ctype.h>
#include <pwd.h>

static char	*pos;

initline( line )
    char	*line;
{
    pos = line;
}

parseline( token, user )
    char	*token, *user;
{
    char		*p = pos, *t = token, *u, *q, buf[ MAXPATHLEN ];
    struct passwd	*pwent;
    int			quoted = 0;

    while ( isspace( *p )) {
	p++;
    }

    /*
     * If we've reached the end of the line, or a comment,
     * don't return any more tokens.
     */
    if ( *p == '\0' || *p == '#' ) {
	*token = '\0';
	return;
    }

    if ( *p == '"' ) {
	p++;
	quoted = 1;
    }
    while ( *p != '\0' && ( quoted || !isspace( *p ))) {
	if ( *p == '"' ) {
	    if ( quoted ) {
		*t = '\0';
		break;
	    }
	    quoted = 1;
	    p++;
	} else {
	    *t++ = *p++;
	}
    }
    pos = p;
    *t = '\0';

    /*
     * We got to the end of the line without closing an open quote
     */
    if ( *p == '\0' && quoted ) {
	*token = '\0';
	return;
    }

    t = token;
    if ( *t == '~' ) {
	t++;
	if ( *t == '\0' || *t == '/' ) {
	    u = user;
	    if ( *t == '/' ) {
		t++;
	    }
	} else {
	    u = t;
	    if (( q = index( t, '/' )) == NULL ) {
		t = "";
	    } else {
		*q = '\0';
		t = q + 1;
	    }
	}
	if ( u == NULL || ( pwent = getpwnam( u )) == NULL ) {
	    *token = '\0';
	    return;
	}
	strcpy( buf, pwent->pw_dir );
	if ( *t != '\0' ) {
	    strcat( buf, "/" );
	    strcat( buf, t );
	}
	strcpy( token, buf );
    }
    return;
}
