/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

# ifndef _AFPD_CONF
#define _AFPD_CONF

/*
 * The UAMs (User Authentication Method) are used by the Chooser to log
 * you into your Unix machine to use the filesystem. If you support AFS
 * (Andrew File System), you need to include KRBUAM, and not include
 * CLRTXTUAM. If you're on standard Unix, you need CLRTXTUAM and not
 * KRBUAM. If you want to add your own UAM, look in auth.c.
 */
#ifdef AFS
#define KRBUAM		/* add AFS Kerberos authentication */
#else AFS
#define CLRTXTUAM	/* add clear text authentication */
#endif AFS

/*
 * Unix <-> Mac translations. If you define DOWNCASE, all Mac filenames
 * will be mapped to lowercase Unix filenames. This produces a case-
 * insensative filesystem. Unfortunately, it also means that Unix
 * filename that already have mixed case will be inaccessible.
 *
 * CRLF turns on carrage return <-> line feed translation. This means
 * that Mac files that are of type TEXT may be edited with vi on Unix,
 * and that Unix text file may be editted with "you favorite Mac editor".
 */
/* #define DOWNCASE	/* downcase all filenames (see Caveats) */
#define CRLF		/* do cr <-> lf translation of TEXT files */

/* 
 * If you want AFS, you must have KRBUAM and AFSACL turned on. There
 * is Mac side code available to exercise these options.
 */
#ifdef AFS		/* We should also undef CLRTXTUAM, since there's */
# ifndef AFSACL		/* no support for CLRTXTUAM under AFS (tho there */
#  define AFSACL	/* could be). */
# endif
# ifndef KRBUAM
#  define KRBUAM
# endif
# ifndef AFSCHANGEPW
#  define AFSCHANGEPW
# endif
#endif AFS

# endif _AFPD_CONF
