/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/syslog.h>
#include <netatalk/endian.h>
#include <atalk/afp.h>
#include <atalk/paths.h>
#include <strings.h>
#include <ctype.h>
#include <pwd.h>

#include "auth.h"
#include "globals.h"
#include "switch.h"
#include "conf.h"

int	afp_version = 11;
uid_t	uuid;
#ifdef sun
int	groups[ NGROUPS ];
#else sun
gid_t	groups[ NGROUPS ];
#endif sun
int	ngroups;
char	*username = NULL;
char	*mktemp();

/*
 * These numbers are scattered throughout the code.
 */
struct afp_versions	afp_versions[] = {
    { "AFPVersion 1.1",	11 },
    { "AFPVersion 2.0",	20 },
};

struct afp_uams		afp_uams[] = {
    { "No User Authent",	noauth_login,	NULL },
#ifdef KRBUAM
    { "AFS Kerberos",		krb_login,	krb_logincont },
#endif
#ifdef CLRTXTUAM
    { "Cleartxt passwrd",	clrtxt_login,	NULL },
#endif
};
struct afp_uams		*afp_uam = NULL;

status_versions( data )
    char	*data;
{
    struct afp_status	*status;
    int			len, num, i;

    status = (struct afp_status *)data;
    num = sizeof( afp_versions ) / sizeof( afp_versions[ 0 ] );
    data += ntohs( status->as_versoff );
    *data++ = num;
    for ( i = 0; i < num; i++ ) {
	len = strlen( afp_versions[ i ].av_name );
	*data++ = len;
	bcopy( afp_versions[ i ].av_name , data, len );
	data += len;
    }
    status->as_uamsoff = htons( data - (char *)status );
}

status_uams( data )
    char	*data;
{
    struct afp_status	*status;
    int			len, num, i;

    status = (struct afp_status *)data;
    num = sizeof( afp_uams ) / sizeof( afp_uams[ 0 ] );
    data += ntohs( status->as_uamsoff );
    *data++ = num;
    for ( i = 0; i < num; i++ ) {
	len = strlen( afp_uams[ i ].au_name );
	*data++ = len;
	bcopy( afp_uams[ i ].au_name, data, len );
	data += len;
    }
    status->as_iconoff = htons( data - (char *)status );
}

afp_login( ibuf, ibuflen, rbuf, rbuflen )
    char	*ibuf, *rbuf;
    int		ibuflen, *rbuflen;
{
    int		len, i, num;

    if ( nologin ) {
	*rbuflen = 0;
	return( AFPERR_SHUTDOWN );
    }

    ibuf++;
    ibuflen--;
    len = *ibuf++;
    ibuflen--;
    num = sizeof( afp_versions ) / sizeof( afp_versions[ 0 ]);
    for ( i = 0; i < num; i++ ) {
	if ( strncmp( ibuf, afp_versions[ i ].av_name , len ) == 0 ) {
	    afp_version = afp_versions[ i ].av_number;
	    break;
	}
    }
    if ( i == num ) {				/* An inappropo version */
	*rbuflen = 0;
	return( AFPERR_BADVERS );
    }
    ibuf += len;
    ibuflen -= len;

    len = *ibuf++;
    ibuflen--;
    num = sizeof( afp_uams ) / sizeof( afp_uams[ 0 ]);
    for ( i = 0; i < num; i++ ) {
	if ( strncmp( ibuf, afp_uams[ i ].au_name, len ) == 0 ) {
	    afp_uam = &afp_uams[ i ];
	    break;
	}
    }
    ibuf += len;
    ibuflen -= len;

    if ( i == num ) {
	*rbuflen = 0;
	return( AFPERR_BADUAM );
    }

    return( afp_uam->au_login( ibuf, ibuflen, rbuf, rbuflen ));
}

afp_logincont( ibuf, ibuflen, rbuf, rbuflen )
    char	*ibuf, *rbuf;
    int		ibuflen, *rbuflen;
{
    if ( afp_uam == NULL ) {
	*rbuflen = 0;
	return( AFPERR_NOTAUTH );
    }
    return( afp_uam->au_logincont( ibuf, ibuflen, rbuf, rbuflen ));
}

noauth_login( ibuf, ibuflen, rbuf, rbuflen )
    char	*ibuf, *rbuf;
    int		ibuflen, *rbuflen;
{
    struct passwd	*pwent;

    *rbuflen = 0;
    syslog( LOG_INFO, "login noauth" );

    if (( pwent = getpwnam( "nobody" )) == NULL ) {
	syslog( LOG_ERR, "noauth_login: getpwname( nobody ): %m" );
	return( AFPERR_BADUAM );
    }

    if ( setregid( pwent->pw_gid, pwent->pw_gid ) < 0 ||
	    setreuid( pwent->pw_uid, pwent->pw_uid ) < 0 ) {
	syslog( LOG_ERR, "noauth_login: setreugid: %m" );
	return( AFPERR_BADUAM );
    }

    uuid = pwent->pw_uid;
    ngroups = 0;

#ifdef AFS
    if ( setpag() < 0 ) {
	syslog( LOG_ERR, "noauth_login: setpag: %m" );
	return( AFPERR_BADUAM );
    }
#endif AFS
    afp_switch = postauth_switch;
    return( AFP_OK );
}

login( name, uid, gid )
    char	*name;
    uid_t	uid;
    gid_t	gid;
{
    syslog( LOG_INFO, "login %s (uid %d, gid %d)", name, uid, gid );
    if ( initgroups( name, gid ) < 0 ||
	    setregid( gid, gid ) < 0 ||
	    setreuid( uid, uid ) < 0 ) {
	syslog( LOG_ERR, "login: %m" );
	return( AFPERR_BADUAM );
    }

    if (( ngroups = getgroups( NGROUPS, groups )) < 0 ) {
	syslog( LOG_ERR, "login: getgroups: %m" );
	return( AFPERR_BADUAM );
    }
    uuid = uid;

    afp_switch = postauth_switch;
    return( AFP_OK );
}

#ifdef KRBUAM

#include <netinet/in.h>
#include <afs/afs.h>
#include <afs/venus.h>
#include <afs/afsint.h>
#include <krb.h>
#include <des.h>
#include <prot.h>

C_Block			seskey;
Key_schedule		seskeysched;
static int		validseskey = 0;
static int		logged = 0;
static char		name[ ANAME_SZ ], instance[ INST_SZ ];
static char		realm[ REALM_SZ ];
static char		*tktfile;

krb_login( ibuf, ibuflen, rbuf, rbuflen )
    char	*ibuf, *rbuf;
    int		ibuflen, *rbuflen;
{
    KTEXT_ST	authent, rpkt;
    CREDENTIALS	cr;
    char	*p, *q;
    int		len, rc, whoserealm;
    short	slen;

    len = *ibuf++;
    ibuf[ len ] = '\0';
    if (( p = index( ibuf, '@' )) != NULL ) {
	*p++ = '\0';
	strcpy( realm, p );
	ucase( realm );
	whoserealm = 0;
    } else {
	if ( krb_get_lrealm( realm, 1 ) != KSUCCESS ) {
	    *rbuflen = 0;
	    return( AFPERR_BADUAM );
	}
	whoserealm = 1;
    }
    if (( p = index( ibuf, '.' )) != NULL ) {
	*p++ = '\0';
	strcpy( instance, p );
    } else {
	*instance = '\0';
    }
    strcpy( name, ibuf );
    /*
     * We don't have the session key, yet. Get one.
     */
    p = rbuf;
    if ( validseskey == 0 ) {
	if ( setpag() < 0 ) {
	    syslog( LOG_ERR, "krb_login: setpag: %m" );
	    *rbuflen = 0;
	    return( AFPERR_BADUAM );
	}
	krb_set_tkt_string(( tktfile = mktemp( _PATH_AFPTKT )));
	if (( rc =  krb_get_svc_in_tkt( "afpserver", Obj, realm,
		TICKET_GRANTING_TICKET, realm, 255, KEYFILE )) != INTK_OK ) {
	    *rbuflen = 0;
	    syslog( LOG_ERR, "krb_login: can't get ticket-granting-ticket" );
	    return(( whoserealm ) ? AFPERR_BADUAM : AFPERR_PARAM );
	}
	if ( krb_mk_req( &authent, name, instance, realm, 0 ) != KSUCCESS ) {
	    *rbuflen = 0;
	    return( AFPERR_PARAM );
	}
	if ( krb_get_cred( name, instance, realm, &cr ) != KSUCCESS ) {
	    *rbuflen = 0;
	    return( AFPERR_BADUAM );
	}

	if ( unlink( tktfile ) < 0 ) {
	    syslog( LOG_ERR, "krb_login: unlink %s: %m", tktfile );
	    *rbuflen = 0;
	    return( AFPERR_BADUAM );
	}

	bcopy( cr.session, seskey, sizeof( C_Block ));
	key_sched( seskey, seskeysched );
	validseskey = 1;
	username = name;

	bcopy( authent.dat, p, authent.length );
	p += authent.length;
    }

    if ( kuam_get_in_tkt( name, instance, realm, TICKET_GRANTING_TICKET,
	    realm, 255, &rpkt ) != INTK_OK ) {
	*rbuflen = 0;
	return( AFPERR_PARAM );
    }


    q = (char *)rpkt.dat;
    *p++ = *q++;
    *p++ = *q++;
    while ( *q++ )
	;
    while ( *q++ )
	;
    while ( *q++ )
	;
    q += 10;

    len = strlen( realm );
    strcpy( p, realm );
    p += len + 1;
    bcopy( q, &slen, sizeof( short ));
    bcopy( &slen, p, sizeof( short ));
    p += sizeof( short );
    q += sizeof( short );
    bcopy( q, p, slen );
    p += slen;

    *rbuflen = p - rbuf;
    return( AFPERR_AUTHCONT );
}

struct ClearToken {
    long AuthHandle;
    char HandShakeKey[8];
    long ViceId;
    long BeginTimestamp;
    long EndTimestamp;
};

krb_logincont( ibuf, ibuflen, rbuf, rbuflen )
    char	*ibuf, *rbuf;
    int		ibuflen, *rbuflen;
{
    CREDENTIALS		cr;
    struct ViceIoctl	vi;
    struct ClearToken	ct;
    struct passwd	*pwd;
    char		buf[ 1024 ], *p;
    int			aint;
    short		clen;

    *rbuflen = 0;
    ibuf += 2;
    bcopy( ibuf, &clen, sizeof( short ));
    ibuf += sizeof( short );

    pcbc_encrypt((C_Block *)ibuf, (C_Block *)ibuf,
	    clen, seskeysched, seskey, DES_DECRYPT );
    if ( kuam_set_in_tkt( name, instance, realm, TICKET_GRANTING_TICKET,
	    realm, ibuf ) != INTK_OK ) {
	return( AFPERR_PARAM );
    }

    if ( get_ad_tkt( "afs", "", realm, 255 ) != KSUCCESS ) {
	return( AFPERR_PARAM );
    }
    if ( krb_get_cred( "afs", "", realm, &cr ) != KSUCCESS ) {
	return( AFPERR_PARAM );
    }

    p = buf;
    bcopy( &cr.ticket_st.length, p, sizeof( int ));
    p += sizeof( int );
    bcopy( cr.ticket_st.dat, p, cr.ticket_st.length );
    p += cr.ticket_st.length;

    ct.AuthHandle = cr.kvno;
    bcopy( cr.session, ct.HandShakeKey, sizeof( cr.session ));
    ct.ViceId = 0;
    ct.BeginTimestamp = cr.issue_date;
    ct.EndTimestamp = cr.issue_date + ( cr.lifetime * 5 * 60 );

    aint = sizeof( struct ClearToken );
    bcopy( &aint, p, sizeof( int ));
    p += sizeof( int );
    bcopy( &ct, p, sizeof( struct ClearToken ));
    p += sizeof( struct ClearToken );

    aint = 0;
    bcopy( &aint, p, sizeof( int ));
    p += sizeof( int );

    lcase( realm );
    strcpy( p, realm );
    p += strlen( realm ) + 1;

    vi.in = buf;
    vi.in_size = p - buf;
    vi.out = buf;
    vi.out_size = sizeof( buf );
    if ( pioctl( 0, VIOCSETTOK, &vi, 0 ) < 0 ) {
	syslog( LOG_ERR, "krb_logincont: pioctl: %m" );
	return( AFPERR_BADUAM );
    }

    if ( unlink( tktfile ) < 0 ) {
	syslog( LOG_ERR, "krb_logincont: %s: %m", tktfile );
	return( AFPERR_BADUAM );
    }

    if (( pwd = getpwnam( username )) == NULL ) {
	return( AFPERR_NOTAUTH );
    }
    if ( logged == 0 ) {
	logged = 1;
	syslog( LOG_INFO, "authenticated %s.%s@%s", name, instance, realm );
	return( login( pwd->pw_name, pwd->pw_uid, pwd->pw_gid ));
    }
    syslog( LOG_INFO, "re-authenticated %s.%s@%s", name, instance, realm );
    return( AFP_OK );
}

lcase( p )
    char	*p;
{
    for (; *p; p++ ) {
	if ( isupper( *p )) {
	    *p = tolower( *p );
	}
    }
    return;
}

ucase( p )
    char	*p;
{
    for (; *p; p++ ) {
	if ( islower( *p )) {
	    *p = toupper( *p );
	}
    }
    return;
}

#endif KRBUAM

#ifdef CLRTXTUAM

extern char	*crypt();

static char	clrtxtname[ 31 ];

clrtxt_login( ibuf, ibuflen, rbuf, rbuflen )
    char	*ibuf, *rbuf;
    int		ibuflen, *rbuflen;
{
    struct passwd	*pwd;
    int			len;
    char		*p, *getusershell();

    *rbuflen = 0;

    len = *ibuf++;
    if ( len > 31 ) {
	return( AFPERR_PARAM );
    }
    bcopy( ibuf, clrtxtname, len );
    ibuf += len;
    clrtxtname[ len ] = '\0';
    username = clrtxtname;
    if (( pwd = getpwnam( clrtxtname )) == NULL ) {
	return( AFPERR_NOTAUTH );
    }

    if ( pwd->pw_shell != NULL && pwd->pw_shell[ 0 ] != NULL ) {
	while (( p = getusershell()) != NULL ) {
	    if ( strcmp( p, pwd->pw_shell ) == 0 ) {
		break;
	    }
	}
	endusershell();
	if ( p == NULL ) {
	    syslog( LOG_INFO, "illegal shell %s for %s",
		    pwd->pw_shell, clrtxtname );
	    return( AFPERR_NOTAUTH );
	}
    }

    if ( pwd->pw_passwd != NULL ) {
	if ( *ibuf == '\0' ) {
	    ++ibuf;
	}
	ibuf[ 8 ] = '\0';
	p = crypt( ibuf, pwd->pw_passwd );
	if ( strcmp( p, pwd->pw_passwd ) != 0 ) {
	    return( AFPERR_NOTAUTH );
	}
    }

    return( login( pwd->pw_name, pwd->pw_uid, pwd->pw_gid ));
}
#endif CLRTXTUAM
