/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of The University
 * of Michigan not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. This software is supplied as is without expressed or
 * implied warranties of any kind.
 *
 *	Research Systems Unix Group
 *	The University of Michigan
 *	c/o Mike Clark
 *	535 W. William Street
 *	Ann Arbor, Michigan
 *	+1-313-763-0525
 *	netatalk@itd.umich.edu
 */

#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/syslog.h>
#include <netatalk/endian.h>
#include <sys/errno.h>
#include <atalk/afp.h>
#include <strings.h>

#include "volume.h"
#include "globals.h"
#include "directory.h"
#include "desktop.h"

extern int errno;
char *makemacpath();

struct savedt	sa = { { 0, 0, 0, 0 }, -1, 0 };

afp_addappl( ibuf, ibuflen, rbuf, rbuflen )
    char	*ibuf, *rbuf;
    int		ibuflen, *rbuflen;
{
    struct vol		*vol;
    struct dir		*dir;
    int			did, pathtype, tfd, cc;
    u_short		vid, len, mplen;
    char		*path, *dtf, *p, *mp;
    u_char		creator[ 4 ];
    u_char		appltag[ 4 ];
    char		mpath[ MAXPATHLEN ];
    char		tempfile[ MAXPATHLEN ];

    *rbuflen = 0;
    ibuf += 2;

    bcopy( ibuf, &vid, sizeof( u_short ));
    ibuf += sizeof( u_short );
    if (( vol = getvolbyvid( vid )) == NULL ) {
	return( AFPERR_PARAM );
    }

    bcopy( ibuf, &did, sizeof( int ));
    ibuf += sizeof( int );
    if (( dir = dirsearch( vol, did )) == NULL ) {
	return( AFPERR_NOOBJ );
    }

    bcopy( ibuf, creator, sizeof( creator ));
    ibuf += sizeof( creator );

    bcopy( ibuf, appltag, sizeof( appltag ));
    ibuf += sizeof( appltag );

    if (( pathtype = *ibuf++ ) != 2 ) {
	return( AFPERR_PARAM );
    }

    len = *ibuf++;
    if (( path = cname( vol, dir, &ibuf, len )) == NULL ) {
	return( AFPERR_NOOBJ );
    }
    if ( *path == '\0' ) {
	return( AFPERR_BADTYPE );
    }

    if ( applopen( vol, creator, O_RDWR|O_CREAT, 0666 ) != AFP_OK ) {
	return( AFPERR_PARAM );
    }
    if ( lseek( sa.sdt_fd, 0L, L_SET ) < 0 ) {
	return( AFPERR_PARAM );
    }
    dtf = dtfile( vol, creator, ".appl.temp" );
    strcpy( tempfile, dtf );
    if (( tfd = open( tempfile, O_RDWR|O_CREAT, 0666 )) < 0 ) {
	return( AFPERR_PARAM );
    }
    mp = makemacpath( mpath, sizeof( mpath ), dir, path );
    mplen =  mpath + sizeof( mpath ) - mp;

    /* write the new appl entry at start of temporary file */
    p = mp - sizeof( u_short );
    mplen = htons( mplen );
    bcopy( &mplen, p, sizeof( u_short ));
    mplen = ntohs( mplen );
    p -= sizeof( appltag );
    bcopy( appltag, p, sizeof( appltag ));
    cc = mpath + sizeof( mpath ) - p;
    if ( write( tfd, p, cc ) != cc ) {
	unlink( tempfile );
	return( AFPERR_PARAM );
    }
    cc = copyapplfile( sa.sdt_fd, tfd, mp, mplen );
    close( tfd );
    close( sa.sdt_fd );
    sa.sdt_fd = -1;

    if ( cc < 0 ) {
	unlink( tempfile );
	return( AFPERR_PARAM );
    }
    if ( rename( tempfile, dtfile( vol, creator, ".appl" )) < 0 ) {
	return( AFPERR_PARAM );
    }
    return( AFP_OK );
}


afp_rmvappl( ibuf, ibuflen, rbuf, rbuflen )
    char	*ibuf, *rbuf;
    int		ibuflen, *rbuflen;
{
    struct vol		*vol;
    struct dir		*dir;
    int			did, pathtype, tfd, cc;
    u_short		vid, len, mplen;
    char		*path, *dtf, *mp;
    u_char		creator[ 4 ];
    char		mpath[ MAXPATHLEN ];
    char		tempfile[ MAXPATHLEN ];

    *rbuflen = 0;
    ibuf += 2;

    bcopy( ibuf, &vid, sizeof( u_short ));
    ibuf += sizeof( u_short );
    if (( vol = getvolbyvid( vid )) == NULL ) {
	return( AFPERR_PARAM );
    }

    bcopy( ibuf, &did, sizeof( int ));
    ibuf += sizeof( int );
    if (( dir = dirsearch( vol, did )) == NULL ) {
	return( AFPERR_NOOBJ );
    }

    bcopy( ibuf, creator, sizeof( creator ));
    ibuf += sizeof( creator );

    if (( pathtype = *ibuf++ ) != 2 ) {
	return( AFPERR_PARAM );
    }

    len = *ibuf++;
    if (( path = cname( vol, dir, &ibuf, len )) == NULL ) {
	return( AFPERR_NOOBJ );
    }
    if ( *path == '.' ) {
	return( AFPERR_BADTYPE );
    }

    if ( applopen( vol, creator, O_RDWR, 0666 ) != AFP_OK ) {
	return( AFPERR_NOOBJ );
    }
    if ( lseek( sa.sdt_fd, 0L, L_SET ) < 0 ) {
	return( AFPERR_PARAM );
    }
    dtf = dtfile( vol, creator, ".appl.temp" );
    strcpy( tempfile, dtf );
    if (( tfd = open( tempfile, O_RDWR|O_CREAT, 0666 )) < 0 ) {
	return( AFPERR_PARAM );
    }
    mp = makemacpath( mpath, sizeof( mpath ), dir, path );
    mplen =  mpath + sizeof( mpath ) - mp;
    cc = copyapplfile( sa.sdt_fd, tfd, mp, mplen );
    close( tfd );
    close( sa.sdt_fd );
    sa.sdt_fd = -1;

    if ( cc < 0 ) {
	unlink( tempfile );
	return( AFPERR_PARAM );
    }
    if ( rename( tempfile, dtfile( vol, creator, ".appl" )) < 0 ) {
	return( AFPERR_PARAM );
    }
    return( AFP_OK );
}


afp_getappl( ibuf, ibuflen, rbuf, rbuflen )
    char	*ibuf, *rbuf;
    int		ibuflen, *rbuflen;
{
    struct stat		st;
    struct vol		*vol;
    char		*p;
    int			cc, buflen;
    u_short		vid, aindex, bitmap, len;
    u_char		creator[ 4 ];
    u_char		appltag[ 4 ];
    char		buf[ MAXPATHLEN ];

    ibuf += 2;

    bcopy( ibuf, &vid, sizeof( u_short ));
    ibuf += sizeof( u_short );
    if (( vol = getvolbyvid( vid )) == NULL ) {
	*rbuflen = 0;
	return( AFPERR_PARAM );
    }

    bcopy( ibuf, creator, sizeof( creator ));
    ibuf += sizeof( creator );

    bcopy( ibuf, &aindex, sizeof( aindex ));
    ibuf += sizeof( aindex );
    aindex = ntohs( aindex );
    if ( aindex != 0 ) {
	--aindex;
    }
    
    bcopy( ibuf, &bitmap, sizeof( bitmap ));
    bitmap = ntohs( bitmap );
    ibuf += sizeof( bitmap );

    if ( applopen( vol, creator, O_RDONLY, 0666 ) != AFP_OK ) {
	*rbuflen = 0;
	return( AFPERR_NOITEM );
    }
    if ( aindex < sa.sdt_index ) {
	if ( lseek( sa.sdt_fd, 0L, L_SET ) < 0 ) {
	    *rbuflen = 0;
	    return( AFPERR_PARAM );
	}
	sa.sdt_index = 0;
    }

    /* position to correct spot within appl file */
    while (( cc = read( sa.sdt_fd, buf, sizeof( appltag )
      + sizeof( u_short ))) > 0 ) {
	p = buf + sizeof( appltag );
	bcopy( p, &len, sizeof( u_short ));
	len = ntohs( len );
	p += sizeof( u_short );
	if (( cc = read( sa.sdt_fd, p, len )) < len ) {
	    break;
	}
	if ( sa.sdt_index == aindex ) {
	    break;
	}
	sa.sdt_index++;
    }
    if ( cc <= 0 || sa.sdt_index != aindex ) {
	*rbuflen = 0;
	return( AFPERR_NOITEM );
    }
    sa.sdt_index++;
    if (( p = cname( vol, vol->v_dir, &p, len )) == NULL ) {
	*rbuflen = 0;
	return( AFPERR_NOITEM );
    }

    if ( stat( mtoupath( p ), &st ) < 0 ) {
	*rbuflen = 0;
	return( AFPERR_NOITEM );
    }
    buflen = *rbuflen - sizeof( bitmap ) - sizeof( appltag );
    if ( getfilparams( bitmap, p, curdir, &st, rbuf + sizeof( bitmap ) +
	    sizeof( appltag ), &buflen ) != AFP_OK ) {
	*rbuflen = 0;
	return( AFPERR_BITMAP );
    }

    *rbuflen = buflen + sizeof( bitmap ) + sizeof( appltag );
    bitmap = htons( bitmap );
    bcopy( &bitmap, rbuf, sizeof( bitmap ));
    rbuf += sizeof( bitmap );
    bcopy( appltag, rbuf, sizeof( appltag ));
    rbuf += sizeof( appltag );
    return( AFP_OK );
}


applopen( vol, creator, flags, mode )
    struct vol	*vol;
    u_char	creator[ 4 ];
{
    char	*dtf, *adt, *adts;

    if ( sa.sdt_fd != -1 ) {
	if ( !(flags & ( O_RDWR | O_WRONLY )) &&
		bcmp( sa.sdt_creator, creator, sizeof( creator )) == 0 &&
		sa.sdt_vid == vol->v_vid ) {
	    return( AFP_OK );
	}
	close( sa.sdt_fd );
	sa.sdt_fd = -1;
    }

    dtf = dtfile( vol, creator, ".appl" );

    if (( sa.sdt_fd = open( dtf, flags, ad_mode( dtf, mode ))) < 0 ) {
	if ( errno == ENOENT && ( flags & O_CREAT )) {
	    if (( adts = rindex( dtf, '/' )) == NULL ) {
		return( AFPERR_PARAM );
	    }
	    *adts = '\0';
	    if (( adt = rindex( dtf, '/' )) == NULL ) {
		return( AFPERR_PARAM );
	    }
	    *adt = '\0';
	    (void) ad_mkdir( dtf, 0777 );
	    *adt = '/';
	    (void) ad_mkdir( dtf, 0777 );
	    *adts = '/';

	    if (( sa.sdt_fd = open( dtf, flags, ad_mode( dtf, mode ))) < 0 ) {
		return( AFPERR_PARAM );
	    }
	} else {
	    return( AFPERR_PARAM );
	}
    }
    bcopy( creator, sa.sdt_creator, sizeof( creator ));
    sa.sdt_vid = vol->v_vid;
    sa.sdt_index = 0;
    return( AFP_OK );
}


char *
makemacpath( mpath, mpathlen, dir, path )
    char	*mpath;
    int		mpathlen;
    struct dir	*dir;
    char	*path;
{
    char	*p, *s;
/*
 * build mac. path (backwards) by traversing the directory tree
 */
    p = mpath + mpathlen;
    s = mtoupath( path );
    p -= strlen( s ) + 1;
    strcpy( p, s );

    while ( dir->d_parent != NULL ) {
	s = mtoupath( dir->d_name );
	p -= strlen( s ) + 1;
	strcpy( p, s );
	dir = dir->d_parent;
    }
    return( p ); 
}


copyapplfile( sfd, dfd, mpath, mplen )
    int		sfd;
    int		dfd;
    char	*mpath;
    u_short	mplen;
{
    int		cc;
    char	*p;
    u_short	len;
    u_char	appltag[ 4 ];
    char	buf[ MAXPATHLEN ];
/*
 * copy appls to new file, deleting any matching (old) appl entries
*/
    while (( cc = read( sfd, buf, sizeof(appltag) + sizeof( u_short ))) > 0 ) {
	p = buf + sizeof(appltag);
	bcopy( p, &len, sizeof( u_short ));
	len = ntohs( len );
	p += sizeof( u_short );
	if (( cc = read( sa.sdt_fd, p, len )) < len ) {
	    break;
	}
	if ( pathcmp( mpath, mplen, p, len ) != 0 ) {
	    p += len;
	    if ( write( dfd, buf, p - buf ) != p - buf ) {
		cc = -1;
		break;
	    }
	}
    }
    return( cc );
}


pathcmp( p, plen, q, qlen )
    char	*p;
    u_short	plen;
    char	*q;
    u_short	qlen;
{
    return (( plen == qlen && bcmp( p, q, (int) plen ) == 0 ) ? 0 : 1 );
}
