/*
 * interface for pattern matchers
 */
#include "passwd.h"

/*
 * set up some things on a per-system basis here
 */
char *re_comp();	/* compile regular expression */

/*
 * global variables
 */
static char *pattern;		/* points to typed-in pattern */

/*
 * smatch -- set up the pattern to be matched; bomb on error
 */
int smatch(pat)
char *pat;			/* pattern to be matched */
{
	char buf[BUFSIZ];	/* buffer for error message */
	register char *p;	/* points to any error message */

	/*
	 * compile the pattern
	 */
	if ((p = re_comp(pat)) != NULL){
		SPRINTF(buf, "%s: %s", pat, p);
		paterr(buf);
		return(1);
	}
	return(0);
}

/*
 * match -- compare a string to the compiled pattern
 */
match(str)
char *str;			/* string to be compared */
{
	char buf[BUFSIZ];	/* buffer for error message */

	/*
	 * compare appropriately
	 */
	switch(re_exec(str)){
	case 1:			/* success */
		return(1);
	case 0:			/* failure */
		return(0);
	default:
		SPRINTF(buf, "Internal error comparing \"%s\" to \"%s\"\n",
					str, pattern);
		paterr(buf);
	}
	return(0);
}
