/*
 * Copyright (c) 1983, 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983, 1988 The Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)rlogind.c	5.22.1.6 (Berkeley) 2/7/89";
#endif /* not lint */

/*
 * remote login server:
 *	\0
 *	remuser\0
 *	locuser\0
 *	terminal_type/speed\0
 *	data
 *
 * Automatic login protocol is done here, using login -f upon success,
 * unless OLD_LOGIN is defined (then done in login, ala 4.2/4.3BSD).
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/file.h>

#include <netinet/in.h>

#include <errno.h>
#include <pwd.h>
#include <signal.h>
#ifdef USE_TERMIOS_H
#include <termios.h>
#else
#include <sgtty.h>
#endif
#include <stdio.h>
#include <netdb.h>
#include <syslog.h>
#ifdef USE_STRING_H
#include <string.h>
#define index		strchr
#define rindex		strrchr
#define bcopy(s,d,l)	memcpy(d,s,l)
#define bcmp(x,y,l)	memcmp(x,y,l)
#else
#include <strings.h>
#endif

#ifndef O_RDWR
#include <sys/fcntl.h>
#endif

#ifdef STREAM_PTY
#include <sys/stropts.h>
#include "../lib/tiocpkt.h"	/* for OOB control messages */
extern	char	*ptsname();
#define PTY_PKT_READ	pty_pkt_read
#else
#define PTY_PKT_READ	read
#endif

#ifndef FIONBIO
#include <sys/filio.h>
#endif

#ifndef NEW_LOGIN
#define OLD_LOGIN	/* use the -r option of /bin/login */
#endif

#ifndef TIOCPKT_WINDOW
#define TIOCPKT_WINDOW 0x80
#endif

char	*env[2];
#define	NMAX 30
char	lusername[NMAX+1], rusername[NMAX+1];
static	char term[64] = "TERM=";
#define	ENVSIZE	(sizeof("TERM=")-1)	/* skip null for concatenation */
int	keepalive = 1;

#define	SUPERUSER(pwd)	((pwd)->pw_uid == 0)

#if defined(sun) || defined(ultrix)
int _check_rhosts_file;
#endif

/* Ultrix syslog(3) has no facility stuff. */
#ifndef LOG_DAEMON
#define LOG_DAEMON      0
#define LOG_CONS        0
#define LOG_AUTH        0
#endif

extern	int errno;
int	reapchild();
struct	passwd *getpwnam(), *pwd;
char	*malloc();

char    *procname;

main(argc, argv)
	int argc;
	char **argv;
{
	extern int opterr, optind, _check_rhosts_file;
	int ch;
	int on = 1, fromlen;
	struct sockaddr_in from;

	umask(022);

	procname = argv[0];

	openlog(procname, LOG_PID | LOG_CONS, LOG_DAEMON);

	opterr = 0;
	while ((ch = getopt(argc, argv, "ln")) != EOF)
		switch (ch) {
		case 'l':
			_check_rhosts_file = 0;
			break;
		case 'n':
			keepalive = 0;
			break;
		case '?':
		default:
			syslog(LOG_ERR, "usage: rlogind [-l] [-n]");
			break;
		}
	argc -= optind;
	argv += optind;

	fromlen = sizeof (from);
	if (getpeername(0, &from, &fromlen) < 0) {
		syslog(LOG_ERR, "Couldn't get peer name of remote host: %m");
		fatalperror("Can't get peer name of host");
	}
	if (keepalive &&
	    setsockopt(0, SOL_SOCKET, SO_KEEPALIVE, &on, sizeof (on)) < 0)
		syslog(LOG_WARNING, "setsockopt (SO_KEEPALIVE): %m");
	doit(0, &from);
}

int	child;
int	cleanup();
int	netf;
char	*line;
extern	char	*inet_ntoa();

struct winsize win = { 0, 0, 0, 0 };


doit(f, fromp)
	int f;
	struct sockaddr_in *fromp;
{
	int i, p, t, pid, on = 1;
	int authenticated = 0, hostok = 0;
	char remotehost[2 * MAXHOSTNAMELEN + 1];
#ifdef OLD_LOGIN
#ifdef USE_TERMIOS_H
	struct termios termios;
#else
	struct sgttyb sgttyb;
#endif
#endif /* OLD_LOGIN */
	register struct hostent *hp;
	struct hostent hostent;
	char c;

	alarm(60);
	read(f, &c, 1);
	if (c != 0)
		exit(1);

	alarm(0);
	fromp->sin_port = ntohs((u_short)fromp->sin_port);
	hp = gethostbyaddr(&fromp->sin_addr, sizeof (struct in_addr),
		fromp->sin_family);
	if (hp == 0) {
		/*
		 * Only the name is used below.
		 */
		hp = &hostent;
		hp->h_name = inet_ntoa(fromp->sin_addr);
		hostok++;
	} else {
		/*
		 * If name returned by gethostbyaddr is in our domain,
		 * attempt to verify that we haven't been fooled by someone
		 * in a remote net; look up the name and check that this
		 * address corresponds to the name.
		 */
		strncpy(remotehost, hp->h_name, sizeof(remotehost) - 1);
		remotehost[sizeof(remotehost) - 1] = 0;
		hp = gethostbyname(remotehost);
		if (hp)
		    for (; hp->h_addr_list[0]; hp->h_addr_list++)
			if (!bcmp(hp->h_addr_list[0], (caddr_t)&fromp->sin_addr,
			    sizeof(fromp->sin_addr))) {
				hostok++;
				break;
			}
			if (hostok == 0)
				syslog(LOG_NOTICE, 
					"Host addr %s not listed for host %s", 
					inet_ntoa(fromp->sin_addr), remotehost);
		else {
		     hp = &hostent;
		}
		/* If host name verification fails use the address instead. */
		hp->h_name = hostok ? remotehost : inet_ntoa(fromp->sin_addr);
	}

	if (fromp->sin_family != AF_INET ||
	    fromp->sin_port >= IPPORT_RESERVED ||
	    fromp->sin_port < IPPORT_RESERVED/2) {
		syslog(LOG_NOTICE, "Connection from %s on illegal port",
			inet_ntoa(fromp->sin_addr));
		fatal(f, "Permission denied");
	}
#ifdef IP_OPTIONS
      {
	u_char optbuf[BUFSIZ/3], *cp;
	char lbuf[BUFSIZ], *lp;
	int optsize = sizeof(optbuf), ipproto;
	struct protoent *ip;

	if ((ip = getprotobyname("ip")) != NULL)
		ipproto = ip->p_proto;
	else
		ipproto = IPPROTO_IP;
	if (getsockopt(0, ipproto, IP_OPTIONS, (char *)optbuf, &optsize) == 0 &&
	    optsize != 0) {
		lp = lbuf;
		for (cp = optbuf; optsize > 0; cp++, optsize--, lp += 3)
			sprintf(lp, " %2.2x", *cp);
		syslog(LOG_NOTICE,
		    "Connection received using IP options (ignored):%s", lbuf);
		if (setsockopt(0, ipproto, IP_OPTIONS,
		    (char *)NULL, optsize) != 0) {
			syslog(LOG_ERR, "setsockopt IP_OPTIONS NULL: %m");
			exit(1);
		}
	}
      }
#endif
	write(f, "", 1);
#ifndef OLD_LOGIN
	if (do_rlogin(hp->h_name, inet_ntoa(fromp->sin_addr)) == 0) {
		if (hostok)
		    authenticated++;
		else
		    write(f, "rlogind: Host address mismatch.\r\n",
		     sizeof("rlogind: Host address mismatch.\r\n") - 1);
	}
#endif

#ifdef STREAM_PTY
	if ((p = open("/dev/ptmx", O_RDWR)) < 0)
		fatal(f, "All network ports in use");
	if (grantpt(p) < 0 || unlockpt(p) < 0)
		fatal(f, "Cannot initialize pty slave");
	if ((line = ptsname(p)) == 0 || (t = open(line, O_RDWR)) < 0)
		fatal(f, "Cannot find  pty slave");
	if (ioctl(t, I_PUSH, "ptem") < 0 || ioctl(t, I_PUSH, "ldterm") < 0 
	|| ioctl(t, I_PUSH, "ttcompat") < 0 || ioctl(p, I_PUSH, "pckt") < 0)
		fatal(f, "Cannot push streams modules onto pty");
	(void) ioctl(p, TIOCSWINSZ, &win);
	netf = f;
#else /* STREAM_PTY */
	for (c = 'p'; c <= 's'; c++) {
		struct stat stb;
		line = "/dev/ptyXX";
		line[strlen("/dev/pty")] = c;
		line[strlen("/dev/ptyp")] = '0';
		if (stat(line, &stb) < 0)
			break;
		for (i = 0; i < 16; i++) {
			line[sizeof("/dev/ptyp") - 1] = "0123456789abcdef"[i];
			close(open(line, O_RDWR));
			p = open(line, O_RDWR);
			if (p > 0)
				goto gotpty;
		}
	}
	fatal(f, "Out of ptys");
	/*NOTREACHED*/
gotpty:
	(void) ioctl(p, TIOCSWINSZ, &win);
	netf = f;
	line[strlen("/dev/")] = 't';
	t = open(line, O_RDWR);
	if (t < 0)
		fatalperror(f, line);
	if (fchmod(t, 0))
		fatalperror(f, line);
	(void)signal(SIGHUP, SIG_IGN);
	vhangup();
	(void)signal(SIGHUP, SIG_DFL);
#ifdef ultrix /* next open() should give us the ctty that vhangup() killed */
	setpgrp(0, 0);
#endif
	t = open(line, O_RDWR);
	if (t < 0)
		fatalperror(f, line);
#endif /* STREAM_PTY */
#ifdef OLD_LOGIN
	/* Do not echo the protocol startup data */
#ifdef USE_TERMIOS_H
	ioctl(t, TCGETS, &termios);
	termios.c_lflag &= ~(ECHO | ICANON);
	termios.c_cc[VMIN] = 1;
	termios.c_cc[VTIME] = 0;
	ioctl(t, TCSETS, &termios);
#else /* USE_TERMIOS_H */
	ioctl(t, TIOCGETP, &sgttyb);
	sgttyb.sg_flags = RAW;
	ioctl(t, TIOCSETP, &sgttyb);
#endif /* USE_TERMIOS_H */
#else /* OLD_LOGIN */
	setup_term(t);
#endif
#ifdef DEBUG
	{
		int tt = open("/dev/tty", O_RDWR);
		if (tt > 0) {
			(void)ioctl(tt, TIOCNOTTY, 0);
			(void)close(tt);
		}
	}
#endif
	pid = fork();
	if (pid < 0)
		fatalperror(f, "");
	if (pid == 0) {
#ifdef STREAM_PTY
		/* Acquire a controlling terminal. */
		int tt = t;
		setsid();
		if ((t = open(line, O_RDWR)) < 0)
			fatalperror(2, line);
		close(tt);
#endif
		close(f), close(p);
		dup2(t, 0), dup2(t, 1), dup2(t, 2);
		close(t);
#ifdef SYSV_UTMP
		{
		char *utmpx_ptsid(), *utmpx_id = utmpx_ptsid(line, "rl");
		utmpx_init(line + sizeof("/dev/") - 1, ".rlogin", utmpx_id);
		}
#endif
#ifdef OLD_LOGIN
		execl("/bin/login", "login", "-r", hp->h_name, 0);
#else /* OLD_LOGIN */
		if (authenticated) {
			execl("/usr/sbin/login", "login", "-p", "-h", hp->h_name,
			    "-f", lusername, 0);
			execl("/usr/etc/login", "login", "-p", "-h", hp->h_name,
			    "-f", lusername, 0);
			execl("/bin/login", "login", "-p", "-h", hp->h_name,
			    "-f", lusername, 0);
		} else {
			execl("/usr/sbin/login", "login", "-p", "-h", hp->h_name,
			    lusername, 0);
			execl("/usr/etc/login", "login", "-p", "-h", hp->h_name,
			    lusername, 0);
			execl("/bin/login", "login", "-p", "-h", hp->h_name,
			    lusername, 0);
		}
#endif /* OLD_LOGIN */
		fatalperror(2, "/bin/login");
		/*NOTREACHED*/
	}
	close(t);

	ioctl(f, FIONBIO, &on);
	ioctl(p, FIONBIO, &on);
#ifndef STREAM_PTY
	ioctl(p, TIOCPKT, &on);
#endif
	signal(SIGTSTP, SIG_IGN);
	signal(SIGCHLD, cleanup);
	setpgrp(0, 0);
#ifdef OLD_LOGIN
	protocol(f, p, hp->h_name, inet_ntoa(fromp->sin_addr));
#else
	protocol(f, p);
#endif
	signal(SIGCHLD, SIG_IGN);
	cleanup();
}

char	magic[2] = { 0377, 0377 };
char	oobdata[] = {TIOCPKT_WINDOW};

/*
 * Handle a "control" request (signaled by magic being present)
 * in the data stream.  For now, we are only willing to handle
 * window size changes.
 */
control(pty, cp, n)
	int pty;
	char *cp;
	int n;
{
	struct winsize w;

	if (n < 4+sizeof (w) || cp[2] != 's' || cp[3] != 's')
		return (0);
	oobdata[0] &= ~TIOCPKT_WINDOW;	/* we know he heard */
	bcopy(cp+4, (char *)&w, sizeof(w));
	w.ws_row = ntohs(w.ws_row);
	w.ws_col = ntohs(w.ws_col);
	w.ws_xpixel = ntohs(w.ws_xpixel);
	w.ws_ypixel = ntohs(w.ws_ypixel);
	(void)ioctl(pty, TIOCSWINSZ, &w);
	return (4+sizeof (w));
}

/*
 * rlogin "protocol" machine.
 */
#ifdef OLD_LOGIN
protocol(f, p, name, addr)
	char *name, *addr;
#else
protocol(f, p)
#endif
	int f, p;
{
	char pibuf[1024], fibuf[1024], *pbp, *fbp;
	register pcc = 0, fcc = 0;
	int cc, nfd, pmask, fmask;
#ifdef OLD_LOGIN
	/* Extract user name info from client<->login handshake */
	int check_rcmd = 1;
#endif
	char cntl;

	/*
	 * Must ignore SIGTTOU, otherwise we'll stop
	 * when we try and set slave pty's window shape
	 * (our controlling tty is the master pty).
	 */
	(void) signal(SIGTTOU, SIG_IGN);
	send(f, oobdata, 1, MSG_OOB);	/* indicate new rlogin */
	if (f > p)
		nfd = f + 1;
	else
		nfd = p + 1;
	fmask = 1 << f;
	pmask = 1 << p;
	for (;;) {
		int ibits, obits, ebits;

		ibits = 0;
		obits = 0;
		if (fcc)
			obits |= pmask;
		else
			ibits |= fmask;
		if (pcc >= 0)
			if (pcc)
				obits |= fmask;
			else
				ibits |= pmask;
		ebits = pmask;
		if (select(nfd, &ibits, obits ? &obits : (int *)NULL,
		    &ebits, 0) < 0) {
			if (errno == EINTR)
				continue;
			fatalperror(f, "select");
		}
		if (ibits == 0 && obits == 0 && ebits == 0) {
			/* shouldn't happen... */
			sleep(5);
			continue;
		}
#define	pkcontrol(c)	((c)&(TIOCPKT_FLUSHWRITE|TIOCPKT_NOSTOP|TIOCPKT_DOSTOP))
		if (ebits & pmask) {
			cc = PTY_PKT_READ(p, &cntl, 1);
			if (cc == 1 && pkcontrol(cntl)) {
				cntl |= oobdata[0];
				send(f, &cntl, 1, MSG_OOB);
				if (cntl & TIOCPKT_FLUSHWRITE) {
					pcc = 0;
					ibits &= ~pmask;
				}
			}
		}
		if (ibits & fmask) {
			fcc = read(f, fibuf, sizeof(fibuf));
			if (fcc < 0 && errno == EWOULDBLOCK)
				fcc = 0;
			else {
				register char *cp;
				int left, n;

				if (fcc <= 0)
					break;
				fbp = fibuf;

			top:
				for (cp = fibuf; cp < fibuf+fcc-1; cp++)
					if (cp[0] == magic[0] &&
					    cp[1] == magic[1]) {
						left = fcc - (cp-fibuf);
						n = control(p, cp, left);
						if (n) {
							left -= n;
							if (left > 0)
								bcopy(cp+n, cp, left);
							fcc -= n;
							goto top; /* n^2 */
						}
					}
#ifdef OLD_LOGIN
				/* watch the client<->login handshake */
				if (check_rcmd)
				    check_rcmd = in_rcmd(fbp, fcc, name, addr);
#endif
				obits |= pmask;		/* try write */
			}
		}

		if ((obits & pmask) && fcc > 0) {
			cc = write(p, fbp, fcc);
			if (cc > 0) {
				fcc -= cc;
				fbp += cc;
			}
		}

		if (ibits & pmask) {
			pcc = PTY_PKT_READ(p, pibuf, sizeof (pibuf));
			pbp = pibuf;
			if (pcc < 0 && errno == EWOULDBLOCK)
				pcc = 0;
			else if (pcc <= 0)
				break;
			else if (pibuf[0] == 0) {
				pbp++, pcc--;
				obits |= fmask;	/* try a write */
			} else {
				if (pkcontrol(pibuf[0])) {
					pibuf[0] |= oobdata[0];
					send(f, &pibuf[0], 1, MSG_OOB);
				}
				pcc = 0;
			}
		}
		if ((obits & fmask) && pcc > 0) {
			cc = write(f, pbp, pcc);
			if (cc < 0 && errno == EWOULDBLOCK) {
				/* also shouldn't happen */
				sleep(1);
				continue;
			}
			if (cc > 0) {
				pcc -= cc;
				pbp += cc;
			}
		}
	}
}

cleanup()
{
	char *p;

	p = line + sizeof("/dev/") - 1;
#ifdef SYSV_UTMP
	utmpx_logout(p);
	(void)chmod(line, 0644);
	(void)chown(line, 0, 0);
#else /* SYSV_UTMP */
	if (logout(p))
		logwtmp(p, "", "");
	(void)chmod(line, 0666);
	(void)chown(line, 0, 0);
	*p = 'p';
	(void)chmod(line, 0666);
	(void)chown(line, 0, 0);
#endif /* SYSV_UTMP */
	shutdown(netf, 2);
	exit(1);
}

fatal(f, msg)
	int f;
	char *msg;
{
	char buf[BUFSIZ];

	buf[0] = '\01';		/* error indicator */
	(void) sprintf(buf + 1, "rlogind: %s.\r\n", msg);
	(void) write(f, buf, strlen(buf));
	exit(1);
}

fatalperror(f, msg)
	int f;
	char *msg;
{
	char buf[BUFSIZ];
	extern int sys_nerr;
	extern char *sys_errlist[];

	if ((unsigned)errno < sys_nerr)
		(void) sprintf(buf, "%s: %s", msg, sys_errlist[errno]);
	else
		(void) sprintf(buf, "%s: Error %d", msg, errno);
	fatal(f, buf);
}

#ifndef OLD_LOGIN
do_rlogin(host, addr)
	char *host;
	char *addr;
{

	getstr(rusername, sizeof(rusername), "remuser too long");
	getstr(lusername, sizeof(lusername), "locuser too long");
	getstr(term+ENVSIZE, sizeof(term)-ENVSIZE, "Terminal type too long");
	do_access(procname, host, addr, rusername, lusername);

	if (getuid())
		return(-1);
	pwd = getpwnam(lusername);
	if (pwd == NULL)
		return(-1);
	return(ruserok(host, SUPERUSER(pwd), rusername, lusername));
}


getstr(buf, cnt, errmsg)
	char *buf;
	int cnt;
	char *errmsg;
{
	char c;

	do {
		if (read(0, &c, 1) != 1)
			exit(1);
		if (--cnt < 0)
			fatal(1, errmsg);
		*buf++ = c;
	} while (c != 0);
}

extern	char **environ;

char *speeds[] = {
	"0", "50", "75", "110", "134", "150", "200", "300", "600",
	"1200", "1800", "2400", "4800", "9600", "19200", "38400",
};
#define	NSPEEDS	(sizeof(speeds) / sizeof(speeds[0]))

setup_term(fd)
	int fd;
{
	register char *cp = index(term, '/'), **cpp;
#ifdef USE_TERMIOS_H
	struct termios termios;
#else
	struct sgttyb sgttyb;
#endif
	char *speed;

#ifdef USE_TERMIOS_H
	(void)ioctl(fd, TCGETS, &termios);
#else
	(void)ioctl(fd, TIOCGETP, &sgttyb);
#endif
	if (cp) {
		*cp++ = '\0';
		speed = cp;
		cp = index(speed, '/');
		if (cp)
			*cp++ = '\0';
		for (cpp = speeds; cpp < &speeds[NSPEEDS]; cpp++)
		    if (strcmp(*cpp, speed) == 0) {
#ifdef USE_TERMIOS_H
			termios.c_cflag &= ~CBAUD;
			termios.c_cflag |= (cpp - speeds);
#else
			sgttyb.sg_ispeed = sgttyb.sg_ospeed = cpp - speeds;
#endif
			break;
		    }
	}
#ifdef USE_TERMIOS_H
	/* XXX default settings are OK?? */
	(void)ioctl(fd, TCSETS, &termios);
#else
	sgttyb.sg_flags = ECHO|CRMOD|ANYP|XTABS;
	(void)ioctl(fd, TIOCSETP, &sgttyb);
#endif

	env[0] = term;
	env[1] = 0;
	environ = env;
}

/*
 * Check whether host h is in our local domain,
 * as determined by the part of the name following
 * the first '.' in its name and in ours.
 * If either name is unqualified (contains no '.'),
 * assume that the host is local, as it will be
 * interpreted as such.
 */
local_domain(h)
	char *h;
{
	char localhost[MAXHOSTNAMELEN];
	char *p1, *p2 = index(h, '.');

	(void) gethostname(localhost, sizeof(localhost));
	p1 = index(localhost, '.');
	if (p1 == NULL || p2 == NULL || !strcasecmp(p1, p2))
		return(1);
	return(0);
}

#endif /* OLD_LOGIN */

do_access(daemon, host, addr, ruser, luser)
char   *daemon;
char   *host;
char   *addr;
char   *ruser;
char   *luser;
{
    int     allow = hosts_ctl(daemon, strcmp(host, addr) ? host : "unknown",
			      addr, ruser) && (luser[0] != '-');
    char   *text = allow ? "" : "refused ";

    if (strcmp(ruser, luser) == 0)
	syslog(LOG_INFO, "%sconnect from %s@%s",
	       text, ruser, host);
    else
	syslog(LOG_INFO, "%sconnect from %s@%s to %s",
	       text, ruser, host, luser);
    if (!allow)
#ifdef SYSV_UTMP
	cleanup();
#else
	exit(0);
#endif
}

#ifdef OLD_LOGIN

#define IN_RCMD_RUSER 0
#define IN_RCMD_LUSER 1

/* in_rcmd - extract user name info from client<->login handshake */

in_rcmd(src, len, name, addr)
char	*src;
int	len;
char	*name;
char	*addr;
{
	static int state = IN_RCMD_RUSER;

	/*
	 * Kludge alert: peek while /bin/login and the client exchange
	 * the remote and local username information. Then perform TCP 
	 * WRAPPER style access control and logging.
	 */
	switch (state) {
	default:
		fatal(1, "internal error");
		/* NOTREACHED */
	case IN_RCMD_RUSER:
		if (string_complete(&src, &len, rusername, sizeof(rusername), 
				"remuser too long") == 0)
			return (1);
		state = IN_RCMD_LUSER;
	case IN_RCMD_LUSER:
		if (string_complete(&src, &len, lusername, sizeof(lusername), 
				"locuser too long") == 0)
			return (1);
		state = -1;
		do_access(procname, name, addr, rusername, lusername);
		return (0);
	}
}

/* string_complete - copy characters and watch for the end of string */

string_complete(src, src_len, buf, buf_len, errmsg)
char	**src;
int	*src_len;
char	*buf;
int	buf_len;
char	*errmsg;
{
	int	n = strlen(buf);

	buf += n;
	buf_len -= n;

	while (*src_len > 0 && buf_len > 0) {
		(*src_len)--;
		buf_len--;
		if ((*buf++ = *(*src)++) == 0)
			return (1);
	}
	if (buf_len == 0)
		fatal(1, errmsg);
	return (0);
}

#endif /* OLD_LOGIN */

