/*
   str_check: check a string value and make sure it is in the list of
   acceptable values.

   Kenneth Ingham

   Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"

str_check(value, acceptable, cmd, name, line)
char *value, **acceptable;
char *cmd, *name, *line;
{
	extern int line_ok;
	int ok, i;

	ok = False;

	for (i=0; acceptable[i]; i++) {
		if (strcmp(acceptable[i], value) == 0) {
			ok = True;
			break;
		}
	}

	if (!ok) {
		if (line_ok) {
			printf("%s has a string ", cmd);
			printf("value which is not valid:\n");
			printf("%s\n",line);
		}
		else {
			printf("Also, it has a string ");
			printf("value which is not valid:\n");
		}
		printf("where %s = '%s'; Should be '%s'", name, value,
			acceptable[0]);
		for (i=1; acceptable[i]; i++)
			printf(" or '%s'",acceptable[i]);
		printf("\n");
		line_ok = False;
	}
}
