/*
   pp_change: pretty print the change format.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

pp_change(cf)
struct change_fmt_st *cf;
{
	int i;

	while (cf != NULL) {
		switch(cf->fmt.type) {
			case PERCENT:
				printf("\t\t%s %5.2f %%", cf->name,
					cf->fmt.fmt.percent*100);
				break;
			case ABSOLUTE:
				printf("\t\t%s %6.2f", cf->name,
					cf->fmt.fmt.abs_amount);
				break;
			case MAX_MIN:
				printf("\t\t%s %6.2f %6.2f", cf->name,
					cf->fmt.fmt.max_min.min,
					cf->fmt.fmt.max_min.max);
				break;
			case STRING:
				printf("\t\t%s", cf->name);
				printf(" \"%s\"", cf->fmt.fmt.str_value[0]);
				for (i=1; cf->fmt.fmt.str_value[i]; i++)
					printf(", \"%s\"",
					cf->fmt.fmt.str_value[i]);
				break;
			case ANY:
				printf("\t\t%s", cf->name);
				break;
			default:
				printf("Impossible change format type: %d\n",
					cf->fmt.type);
				break;
		}
		if (cf->next != NULL)
			printf(" ;\n");
		else
			printf(" .\n");
		cf = cf->next;
	}
}
