/*
   main: main routine for the watcher program.

   read from a file describing commands (pipelines) to execute, formats of
   	the output, max changes allowed (% or absolute), and max & min
   	values for various fields.
   problems noticed are reported.
   as a side effect, be able to pretty print the description file
   	(originally used to verify parsing).

   outline of program:
	parse control file and build data structures.
	run each pipeline and compare output to previous output (only
		save relevant fields; save directory is either default
		or command line specified; no previous file or format
		changed (ie we are watching different or new fields) we
		create new file and next time we do compare).
	    differences that are not allowable are reported.
	
   Usage of program:
	watcher [-p] [-v] [-h histfile] [-f controlfile] [-n]

	-p : pretty print control file as a verification of parse
		(default no pretty print).  This option prevents
		processing of control file.
	-v : be verbose when doing work; useful for debugging.
		Shows what was read from processes, or if used in
		conjunction with -p shows what the lexical analyzer
		returned.
	-h : file in which to save output for future compare (default
		./watcher.history).
	-f : controlfile to use (default ./watcherfile or ./Watcherfile).
	-n : turn off 'history' stuff, if set.

   Note that the basic data structures are all linear linked lists, with
   many items in the list being heads of other lists.  When problems
   occur, get out the pencil and paper and start drawing the lists.  

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

main(argc, argv)
int argc;
char *argv[];
{
	extern int parse_error;
	extern struct cmd_st *clist;
	extern int pflag, nflag;
	extern char *myname, *histfilename;
	extern int errno;
	extern char *sys_errlist[];
	FILE *hf;

	do_args(argc, argv);
	init_sigs();
	open_cf();

	if (yyparse() == 1 || parse_error) {
		fprintf(stderr, "%s: parse error in control file.\n", myname);
		exit(1);
	}

	if (clist == NULL) {
		fprintf(stderr, "No command list to execute!\n");
		exit(1);
	}

	if (pflag)
		pp(clist);
	else {
		if (! nflag) {
			read_hist();
			hf = fopen(histfilename, "w");
			if (hf == NULL) {
				fprintf(stderr, "Unable to open '%s': %s\n",
					histfilename, sys_errlist[errno]);
				exit(1);
			}
		}
		doit(hf);
	}
}
