/* 
   baderr: A bad error has been caught.  Print an error message explaining
	why we are dying, then exit.

   Assumptions:
	the signal number in sig is an actual signal number and has an
	entry in sys_siglist (BSD ONLY).

   Arguments:
	sig: the number of the signal which brought us here.

   Author:
	Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

baderr(sig)
int sig;
{
#ifdef BSD
	extern char *sys_siglist[];

	printf(">> Unrecoverable error.  %s  Bye. <<\n",sys_siglist[sig]);
#else
	printf(">> Unrecoverable error.  Signal %d.  Bye. <<\n", sig);
#endif
	exit(1);
}
