/*
   to_string: convert a struct anything to a string, no matter what type
   it is currently.

   I'm not completely happy with this; should make better use of
   the info we are provided about the type of any instead of calling
   this routine.

   Note that we assume that a real or integer will fit in a string
   of length MAX_STR.

   Note also that we return a pointer to a static area.

   Kenneth Ingham
*/

#include "defs.h"
#include "y.tab.h"

char *
to_string(any)
struct everything *any;
{
	static char rvalue[MAX_STR];

	switch (any->type) {
		case STRING:
			return any->data.string;
		case FLOAT:
			sprintf(rvalue, "%f", any->data.real);
			return rvalue;
		case INTEGER:
			sprintf(rvalue, "%d", any->data.integer);
			return rvalue;
		default: 
			fprintf(stderr, "Unable to convert type %d",any->type);
			fprintf(stderr, " to string.\n");
			exit(1);
	}
	/*NOTREACHED*/
}
