/*
   read_hist: open the file containing the results of our last run.  If
   it is not there then we assume that this is a first run and set the
   head of the list to NULL.  Otherwise, we read the results of the previous
   run into a mess of a data structure for later use in comparisons.

   Assumed format of history file:

   command
   \tkey
   \t\tname type value

   with the following definitions:
	command: pipeline that was executed
	key: value of key on line
	name: output field name
	type: field type (same as defined in output format)
	value: what was in the field.

   We create a linked list of linked lists of linked lists.  An improvement
   would be to change to a tree of some sort to speed up searches.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"
#include <sys/errno.h>

read_hist()
{
	extern struct old_cmd_st *chead;
	extern int errno;
	extern char *sys_errlist[];
	extern char *histfilename;
	FILE *hf;
	char line[MAX_STR];
	struct old_cmd_st *cp;
	struct val_st *vp;
	struct key_st *kp;
	FILE *open_hf();

	if ((hf = open_hf()) == NULL)
		return; /* errors are dealt with in open_hf */

	chead = NULL;  cp = NULL;  kp = NULL;
	while (fgets(line, MAX_STR, hf) != NULL) {
		line[strlen(line)-1] = '\0'; /* kill trailing newline */

		if (line[0] != '\t') /* command */
			hist_cmd(line, &chead, &cp, &kp, &vp);
		else if (line[0] == '\t' && line[1] != '\t') { /* key */
			if (hist_key(line, &cp, &kp, &vp) == FAIL) {
				chead = NULL;
				return;
			}
		}
		else if (line[0] == '\t' && line[1] == '\t') { /* values */
			if (hist_value(line, &kp, &vp) == FAIL) {
				chead = NULL;
				return;
			}
		}
		errno = 0;
	}

	if (errno) {
		fprintf(stderr, "Warning: error reading %s: %s\n",
			histfilename, sys_errlist[errno]);
		fprintf(stderr, "Ignoring history file.\n\n");
		chead = NULL;
	}

	(void) fclose(hf);
}
