/*
   doit: here is where the real purpose of the program is actually
   carried out.  

	for each command, run it and look for problems.
	write info from this run to the history file.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

doit(hf)
FILE *hf;
{
	extern struct cmd_st *clist;
	extern int vflag, nflag;
	extern int cmd_ok;
	extern int errno;
	extern char *sys_errlist[];

	char line[MAX_STR];
	struct cmd_st *p;
	struct old_cmd_st *prev_results, *find_cmd_prev();
	FILE *ps, *popen();

	/* run commands */
	for (p=clist; p != NULL; p=p->next) {
		cmd_ok = True;
		if (vflag)
			printf("Executing: '%s'\n\n", p->pipeline);

		if ( ! nflag ) {
			/* dealing with the history file... */
			if (p->key != NULL && ! nflag)
				fprintf(hf, "%s\n", p->pipeline);
			/* get prev results for comparison */
			prev_results = find_cmd_prev(p->pipeline);
		}
		else
			prev_results = NULL;

		if ((ps = popen(p->pipeline, "r")) == NULL) {
			fprintf(stderr, "Unable to popen '%s': %s\n", 
				p->pipeline, sys_errlist[errno]);
			fprintf(stderr, "Going to next pipeline.\n");
			continue;
		}

		while (fgets(line, MAX_STR, ps) != NULL) {
			line[strlen(line)-1] = '\0'; /* remove newline */
			if (vflag)
				printf("  Read: '%s'\n",line);
			checkline(p, line, prev_results, hf);
			errno = 0;
		}

		if (errno)
			fprintf(stderr, "Error reading from '%s': %s\n",
				p->pipeline, sys_errlist[errno]);

		(void) pclose(ps);
		if (!cmd_ok)
			printf("\n");
	}
}
