/*
   the grammar describing the control file for watcher.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

%token PIPELINE FLOAT INTEGER STRING QUOTED_STRING
%start command

%{
#include "defs.h"
extern struct cmd_st *clist;
extern int control_line, parse_error;
int nslist = 0;
struct cmd_st *build_cmd();
struct rel_out_st *build_rel();
struct col_out_st *build_col();
struct change_fmt_st *build_pct(), *build_abs();
struct change_fmt_st *build_maxmin(), *build_str();
struct change_fmt_st *build_any();

#define add_end(type, start, what, assignto)	{\
				type *p; \
				for (p=(start); p->next != NULL; p = p->next)\
					;\
				p->next = (what);\
				assignto = start; }
%}

%union {
	struct cmd_st *cmd;
	struct col_out_st *cos;
	struct rel_out_st *ros;
	struct change_fmt_st *cfs;
	struct out_fmt_st *of;
	char **strarray;
	char *str;
	char chr;
	int integer;
	struct number *np;
	float real;
}

%type <str>		PIPELINE STRING QUOTED_STRING
%type <integer>		INTEGER
%type <real>		FLOAT
%type <cmd>		command	
%type <cmd>		one_command
%type <cfs>		change_fmt
%type <cfs>		one_change_fmt
%type <of>		out_fmt
%type <ros>		rel_out_fmt
%type <cos>		col_out_fmt
%type <ros>		one_rel_fmt
%type <cos>		one_col_fmt
%type <strarray>	string_list
%type <str>		alias	
%type <cfs>		max_min_fmt
%type <cfs>		str_change_fmt
%type <cfs>		pct_change_fmt
%type <cfs>		abs_change_fmt
%type <cfs>		any_change_fmt
%type <np>		number

%%
/*
   THE PARSER DESCRIPTION (read aloud to the beginning of
   Also Sprach Zarathustra (the theme from 2001))

   As things are discovered, they are put into the linked list structure
   detailed in defs.h.  
*/
   
command		: one_command
			{
				if (clist == NULL)
					clist = $1;
				else
					printf("Bad error in the parser.\n");
			}
		| command one_command
			{ 
				struct cmd_st *p;

				if (clist != NULL) {
					for (p=clist; p->next!=NULL; p=p->next)
						;
					p->next = $2;
				}
				else
					clist = $1;
			}
		| error '.'
			{
			fprintf(stderr, "Command error ");
			fprintf(stderr,"near line %d\n", control_line);
			parse_error = True;
			}
		;

one_command	: PIPELINE alias out_fmt ':' change_fmt '.'
			{ $$ = build_cmd($1, $2, $3, $5); }
		;

out_fmt		: rel_out_fmt
			{ 
				struct out_fmt_st *p;

				p = allocate(struct out_fmt_st);
				p->type = RELATIVE;
				p->out_fmt.rel_fmt = $1;
				$$ = p;
			}
		| col_out_fmt
			{
				struct out_fmt_st *p;

				p = allocate(struct out_fmt_st);
				p->type = COLUMN;
				p->out_fmt.col_fmt = $1;
				$$ = p;
			}
		| error '.'
			{
				fprintf(stderr,"Output format error ");
				fprintf(stderr,"near line %d\n",
					control_line);
				parse_error = True;
			}
		;

change_fmt	: one_change_fmt
		| change_fmt ';' one_change_fmt
			{
			add_end(struct change_fmt_st, $1, $3, $$);
			}
		| error ';'
			{
				fprintf(stderr,"Change format error ");
				fprintf(stderr,"near line %d\n",
					control_line);
				parse_error = True;
			}
		;

one_change_fmt	: pct_change_fmt
		| abs_change_fmt
		| max_min_fmt
		| str_change_fmt
		| any_change_fmt
		| error '.'
			{
			fprintf(stderr,"Unknown change format type ");
			fprintf(stderr,"near line %d\n", control_line);
			parse_error = True;
			}
		;

rel_out_fmt	: one_rel_fmt
		| rel_out_fmt  one_rel_fmt
			{
				add_end(struct rel_out_st, $1, $2, $$);
			}
		;

col_out_fmt	: one_col_fmt
		| col_out_fmt  one_col_fmt
			{
				add_end(struct col_out_st, $1, $2, $$);
			}
		;

one_rel_fmt	: INTEGER STRING '%' STRING
			{ $$ = build_rel($1, $2, $4); }
		;

one_col_fmt	: INTEGER '-' INTEGER STRING '%' STRING
			{ $$ = build_col($1, $3, $4, $6); }
		;

pct_change_fmt	: STRING number '%'
			{ $$ = build_pct($1, $2); }
		;

abs_change_fmt	: STRING number
			{ $$ = build_abs($1, $2); }
		;

max_min_fmt	: STRING number number
			{ $$ = build_maxmin($1, $2, $3); }
		;

str_change_fmt	: STRING string_list
			{ $$ = build_str($1, $2); nslist = 0; }
		;

any_change_fmt	: STRING
			{ $$ = build_any($1); }
		;

string_list	: QUOTED_STRING
			{
			  nslist = 2;
			  $$ = (char **)xmalloc((unsigned)
				   (nslist * sizeof(char *)));
			  $$[0] = $1;
			  $$[1] = NULL;
			}
		| QUOTED_STRING ',' string_list
			{
			  $3 = (char **)realloc((char *)$3, (unsigned)
			  	   (++nslist * sizeof(char *)));
			  if ($3 == NULL) {
				fprintf(stderr, "realloc failed.\n");
				exit(1);
			  }
			  $3[nslist-2] = $1;
			  $3[nslist-1] = NULL;
			  $$ = $3;
			}
		;

number		: INTEGER
			{
			struct number *np;

			np = allocate(struct number);
			np->type = INTEGER;
			np->value.integer = $1;
			$$ = np;
			}
		| FLOAT
			{
			struct number *np;

			np = allocate(struct number);
			np->type = FLOAT;
			np->value.real = $1;
			$$ = np;
			}
		;

alias		: '{' STRING '}'
			{
				$$ = $2;
			}
		| empty 
			{ $$ = NULL; }
		;

empty		: ;
