/*
   maxmin_check: verify that the value is between min and max.

   Kenneth Ingham

   Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

maxmin_check(current, max, min, cmd, name, line)
char *current;
double max, min;
char *cmd, *name, *line;
{
	extern int line_ok, cmd_ok;
	double value;

	value = atof(current);

	if (value > max || value < min) {
		if (line_ok) {
			printf("%s has a ", cmd);
			printf("max/min value out of range:\n");
			printf("%s\n",line);
		}
		else {
			printf("Also, it has a ");
			printf("max/min value out of range:\n");
		}
		printf("where %s = %.2f; ", name, value);
		printf("valid range %.2f to %.2f.\n", min, max);
		line_ok = False;
	}
}
