/*
   get_col_field: we have a column output format and want a certain
   part of it.  Place the it in 'value' if it exists and return a
   pointer to the string.  If there are problems place a null terminated
   zero length string in 'value' and return NULL as an error condition.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

char *
get_col_field(line, start, end, value)
char *line, *value;
int start, end;
{
	int len;

	value[0] = '\0';
	len = strlen(line);

	/* error checking */
	if (start > len || end > len) {
		fprintf(stderr,"'%s' has %d columns. Specified were %d to %d\n",
			line, len, start, start);
		return NULL;
	}
	len = end - start + 1;
	strncpy(value, &line[start-1], len)[len] = '\0';

	return value;
}
