/*
   check_item: given a value and a change format structure, make sure
   that the value is in range.

   Basically, this routine is a large switch statement on the type of
   change that grabs the necessary info, and checks to see if the item
   is worth mentioning.

   Note that what we print out depends on whether or not something else
   has been found wrong on this line.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

check_item(cf, value, cmd, line, prev_val)
char *value, *cmd, *line;
struct change_fmt_st *cf;
struct everything *prev_val;
{
	extern int line_ok, cmd_ok;

	switch(cf->fmt.type) {
		case PERCENT:
			if (prev_val == NULL) /* nothing to compare with */
				return;
			pct_check(value, prev_val, cf->fmt.fmt.percent,
				cmd, cf->name, line);
			break;
		case ABSOLUTE:
			if (prev_val == NULL) /* nothing to compare with */
				return;
			abs_check(value, prev_val, cf->fmt.fmt.abs_amount,
				cmd, cf->name, line);
			break;
		case MAX_MIN:
			maxmin_check(value, cf->fmt.fmt.max_min.max,
				cf->fmt.fmt.max_min.min, cmd, cf->name, line);
			break;
		case STRING:
			str_check(value, cf->fmt.fmt.str_value, cmd,
				cf->name, line);
			break;
		case ANY:
			if (prev_val == NULL) /* nothing to compare with */
				return;
			any_check(value, prev_val, cmd, cf->name, line);
			break;
		default:
			printf("check_item: impossible condition\n");
			break;
	}
	cmd_ok = line_ok;
}
