/**************************************************************************/
/*       Copyright(c) 1987, 1992 by BBN Systems and Technologies,         */
/*         A Division of Bolt Beranek and Newman Inc.                     */
/*                                                                        */
/*       RDP implementation for 4.2/4.3bsd by Craig Partridge             */
/*                                                                        */
/*  Permission to use, copy, modify, distribute, and sell this software   */
/*  and its documentation for any purpose is hereby granted without fee,  */
/*  provided that the above copyright notice and this permission appear   */
/*  in all copies and in supporting documentation, and that the name of   */
/*  Bolt Beranek and Newman Inc.  not be used in advertising or           */
/*  publicity pertaining to distribution of the software without          */
/*  specific, written prior permission. BBN makes no representations      */
/*  about the suitability of this software for any purposes.  It is       */
/*  provided "AS IS" without express or implied warranties.               */
/**************************************************************************/

#ifndef IPPROTO_RDP
#define IPPROTO_RDP 27		/* check this! */
#endif

/*
 * header size and variable size
 */

#define R_HDRSIZE	18
#define R_VARSIZE	6

/*
 * RDP header per RFC 908
 */

struct rdphdr {
    u_char  rh_flags;	/* ack, eack, etc */

#define RH_SYN  0x80
#define RH_ACK	0x40
#define RH_EACK 0x20
#define RH_RST  0x10
#define RH_NULL 0x08

#define RH_VERBITS     0x3

#define R_VERSION	0x2	/* version #1 */


    u_char  rh_hlen;	/* header length */
    u_short  rh_sp;	/* source port */
    u_short  rh_dp;	/* dest port */
    u_short rh_len;	/* data length */
    u_long  rh_sn;	/* sequence number */
    u_long  rh_an;	/* ack number */
    u_short  rh_sum;	/* checksum */
    /* optional data follows */
};

#define R_ALLOC_PORT	63	/* allocable boundary */

/*
 *  syn stuff
 */

struct rdpsyn {
    u_short	rs_mos;		/* max outstanding segments */
    u_short	rs_mss;		/* max segment size */
    u_short	rs_ff;		/* options flag field */
} ;

#define RS_SDM		0x1	 /* syn options field */

/*
 * macros to compare acks
 */

/* a < b */
#define seq_lt(a,b)		((int)((a)-(b)) < 0)
/* a <= b */
#define seq_le(a,b)		((int)((a)-(b)) <= 0)
/* a > b */
#define seq_gt(a,b)		((int)((a)-(b)) > 0)
/* a >= b */
#define seq_ge(a,b)		((int)((a)-(b)) >= 0)

