************************************************************************
* Que Using Visual FoxPro FOXISAPI example classes
************************************************************************
***  Modified: 09/14/96
***  Function: Includes FoxISAPI base class
***                     QueVFP implementation sample class
***            Create OLE server by compiling wwQUE.pjx to wwQUE.EXE/DLL
***
***            The OLE server builds as:  wwQue.QueVFP
***                
***            MAKE SURE YOU SET THE DATAPATH EXPLICITLY IN THE LOAD
***            METHOD OR BY SETTING THE #DEFINE DATAPATH IN THE 
***            SITELOCATION BLOCK BELOW. THIS MAKES SURE FOXISAPI CAN
***            THE OLE SERVER CAN FIND THE DATA AT RUNTIME. DO NOT
***            USE RELATIVE PATHS AS THE SERVER'S PATH CAN VARY!
***
***            For configuration instructions of IIS and NT 4.0 
***            see the FOXISAPI.HTM page.
***
***            Note: FoxISAPI requires an ISAPI compliant Web server:
***                  MS Internet Information Server
***                  Commerce Builder (Internet Factory)
***                  Purveyor (Process Software)
*************************************************************************

*** Use this code to test the server in VFP
CLEAR
o=CREATE("QueVFP")

*** Sample classes and sample 'parameters'
*? o.TestMethod("Test=Hello+World","h:\http\cgi-win\fox203.ini")
*? o.ReleaseServer()
? o.CustomerLookup()

RETURN


*** System Defines
#DEFINE CR CHR(13)+CHR(10)

*** Application DEFINEs - change for your application
#DEFINE SITELOCATION 1

#IF SITELOCATION=1
   #DEFINE DATAPATH "H:\QUE5\CODE\DATA\"
   #DEFINE HTMLPAGEPATH "H:\QUE5\HTML\"
#ENDIF   


*************************************************************
DEFINE CLASS QueVFP AS FoxISAPI OLEPUBLIC
*************************************************************
***    Author: Rick Strahl
***            (c) West Wind Technologies, 1996
***   Contact: (541) 386-2087  / rstrahl@west-wind.com
***  Modified: 09/11/96
***  Function: Example Class for the Que book. This class 
***            subclasses the FoxISAPI class and builds the
***            sample implementations on top of it.
***
***            Use RightClick/Procedures & Functions to view
***            the class methods of the QueVFP and FoxISAPI
***            classes.
***
*************************************************************

************************************************************************
* QueVFP :: FoxISAPI
*********************************
***  Function: Minimal response method for handling FoxISAPI call.
************************************************************************
FUNCTION FoxISAPI
LPARAMETER lcFormVars, lcIniFile, lnReleaseFlag
LOCAL lcOutput

*** HTTP header - REQUIRED on each request!
lcOutput="HTTP/1.0 200 OK"+CR+;
         "Content-type: text/html"+CR+CR

lcOutput=lcOutput+;
"<HTML><BODY>"+CR+;
"<H1>Hello World from Visual FoxPro</H1>"+CR+;
"<HR>"+CR+;
"This page was generated by Visual FoxPro...<HR>"+CR+;
"</HTML></BODY>"

RETURN lcOutput
* FoxISAPI

************************************************************************
* QueVFP :: TestMethod
*********************************
***  Function: Simple example to show how FoxISAPI works
***      Pass: All direct hits from the Web require the following
***            lcFormVars  -  Encoded HTML form variables
***            lcIniFile   -  Path to INI file that contains server
***                           and browser vars
***            lnReleaseFlag- numeric (0/1) flag that determines
***                           whether the OLE server is released by
***                           FOXISAPI.DLL. Passed by reference.
***                           0 - don't release
***                           1 - release OLE server
***    Return: HTTP compliant output (HTML page mostly)
************************************************************************
FUNCTION TestMethod
LPARAMETER lcFormVars, lcIniFile, lnReleaseFlag
LOCAL lcOutput

*** Decode the Form Vars and assign INI file to global var
THIS.StartRequest(lcFormVars,lcIniFile)

*** Release the server 
lnReleaseFlag=0       && 0 - Don't release (default)  1 - Release

*** Must always add a content Type Header
THIS.ContentTypeHeader()

lcUserId=THIS.GetFormVar("UserId")
lcName=THIS.GetFormVar("UserName")

THIS.SendLn([<HTML><HEAD><TITLE>Hello from FoxISAPI</TITLE><HEAD><BODY BGCOLOR="#FFFFFF">])
THIS.SendLn("<H1><FONT=Arial COLOR=#800000>Hello World from Visual FoxPro</FONT></H1><hr>")
*THIS.SendLn("This page was generated by Visual FoxPro using FOXISAPI. ")
*THIS.SendLn("The current time is: "+time()+"<p>")

THIS.SendLn("<b>Encoded Form/URL variables:</b> "+lcFormVars+"<BR>")
THIS.SendLn("<b>Decoded UserId:</b> "+ THIS.GetFormVar("UserId")+"<br>")
THIS.SendLn("<b>Decoded UserName:</b> " +THIS.GetFormVar("UserName")+"<P>")

*** Show the content of the FOXISAPI INI server/browser vars
IF !EMPTY(lcIniFile) AND FILE(lcIniFile)
   CREATE CURSOR TMemo (TFile M )
   APPEND BLANK
   APPEND MEMO TFile from (lcIniFile)
   THIS.SendLn("Here's the content of: <i>"+lcIniFile+"</i>. You can retrieve any of these with <i>THIS.GetCGIVar(cVarname,cSection)</i>:<p>")
   THIS.SendLn([THIS.GetCGIVar("HTTP_USER_AGENT","ALL_HTTP"): ]+THIS.GetCGIVar("HTTP_USER_AGENT","ALL_HTTP"))
  
   THIS.Send("<PRE>")
   THIS.SendLn(Tmemo.Tfile)
   THIS.SendLn("</PRE>")
   USE in TMemo
ENDIF

THIS.SendLn("<HR></HTML></BODY>")

RETURN THIS.cOutput


************************************************************************
* QueVFP :: CustomerLookup
*********************************
FUNCTION CustomerLookup
LPARAMETER lcFormVars, lcIniFile, lnReleaseFlag

*** Release the server 
lnReleaseFlag=0       && 0 - Don't release (default)  1 - Release

*** Decode the Form Vars and assign INI file to global var
THIS.StartRequest(lcFormVars,lcIniFile)

lcName=THIS.GetFormVar("Name")
lcCompany=THIS.GetFormVar("Company")
lcWhere=""
IF !EMPTY(lcName)
   lcWhere="UPPER(Careof)='"+UPPER(lcName)+"'"
ENDIF
IF !EMPTY(lcCompany)
   IF !EMPTY(lcWhere)
      lcWhere=lcWhere+" AND "
    ENDIF
    lcWhere=lcWhere+"UPPER(Client)='"+UPPER(lcCompany)+"'"
ENDIF
IF !EMPTY(lcWhere)
   lcWhere="WHERE "+lcWhere
ENDIF
       
SELECT Careof, Company, Address, Phone ;
   FROM (DATAPATH+"TT_CUST") ;
   &lcWhere ;
   INTO Cursor TQuery

IF _Tally <1
   THIS.StandardPage("No matching records found",;
                     "Please enter another name or use a shorter search string...")
    USE IN Tquery
    USE IN TT_Cust
    RETURN THIS.cOutput                     
ENDIF

THIS.ContentTypeHeader()

THIS.SendLn([<HTML><BODY BGCOLOR="#FFFFFF">])
THIS.SendLn([<H1>Customer Lookup</H1><HR>])

This.SendLn([Matching customers found: ]+STR(_Tally)+[<p>])

THIS.Send([<TABLE BGCOLOR=#EEEEEE CELLPADDING=4 BORDER=1 WIDTH=100%>]+CR+;
          [<TR BGCOLOR=#FFFFCC><TH>Name</TH><TH>Company</TH><TH>Phone Number</TH></TR>]+CR)

SCAN
   THIS.Send(;
          [<TR><TD>]+;
          TRIM(IIF(EMPTY(TQUery.Careof),"<BR>",Tquery.CareOf))+[</TD><TD>]+;
          TRIM(IIF(EMPTY(Tquery.Company),"<BR>",Tquery.Company))+[Company</TD><TD>]+;
          TRIM(IIF(EMPTY(Tquery.Phone),"<BR>",TQuery.Phone))+[</TD></TR>]+CR)
ENDSCAN          

THIS.SendLn([</TABLE><HR>])
THIS.SendLn([</BODY></HTML>])

USE IN Tquery
USE IN TT_Cust

RETURN THIS.cOutput
* CustomerLookup

ENDDEFINE
*EOC QueVFP



*** FoxISAPI base class


*************************************************************
DEFINE CLASS FoxISAPI AS Custom
*************************************************************
***    Author: Rick Strahl
***            (c) West Wind Technologies, 1996
***   Contact: (541) 386-2087  / rstrahl@west-wind.com
***  Modified: 09/09/96
***  Function: This is a simplified FOXISAPI class that
***            provides basic utility functions required
***            to work with the FoxISAPI input and generate
***            the HTML output.
***
***            For a more complete framework installation
***            check out West Wind Web Connection's OLE
***            connector or the FOXIS example provided
***            in Microsoft's Examples.
*************************************************************

*** Custom Properties
cOutput=""            && Contains Output String built cumulatively
cFormVars=""          && Contains all Form variables 
cContentFile=""       && Name of the INI file 

*** Sets up the environment when the server is first loaded

************************************************************************
* FoxISAPI :: Load
*********************************
***  Function: Load event - should set up the environment for the
***                         class: Any SET and ON commands etc.
***            NOTE: This event only occurs when the server is loaded!
***                  Since FoxISAPI keeps a reference, only the first
***                  hit on the server fires the load. Use the Init
***                  for repeated hits.
************************************************************************
FUNCTION Load

SET SAFETY OFF
SET CPDIALOG OFF
SET EXCLUSIVE OFF

*** You have to set a physical path as the OLE Server
*** runs in the System or scripts directory!
SET PATH TO DATAPATH

ENDPROC

************************************************************************
* FoxISAPI :: Init
*********************************
***  Function: 
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION Init

THIS.cOutput=""

ENDFUNC
* Init

************************************************************************
* FoxISAPI :: ReleaseServer
*********************************
***  Function: Use this routine to release the OLE server reference
***            by setting the lnReleaseFlag Parameter to 1
***    Assume: This routine might not reliably release the server
***            from memory since quick requests can reload the server
***            immediately.
***      Pass: Standard FoxISAPI process parms
***    Return: Result HTML Output
************************************************************************
FUNCTION ReleaseServer
LPARAMETER lcFormVars, lcIniFile, lnReleaseFlag
LOCAL lcOutput

*** Release the server
lnReleaseFlag=1

*** Must always add a content Type Header
THIS.StandardPage("The Server has been released",;
                  "The OLE reference to the server has been released...")

RETURN THIS.cOutput


************************************************************************
* FoxISAPI :: Send
*********************************
***  Function: Low Level Output routine that builds output to the 
***            output source (in this case a string).
***      Pass: lcString   -   String to output
***            llNoOutput -   Return string as is but don't output
***                           to output source. Use to when nesting
***                           commands.
***    Return: "" or lcString if llNoOutput .T.
************************************************************************
FUNCTION Send
LPARAMETER lcString, llNoOutput

IF !llNoOutput
   THIS.cOutput=THIS.cOutput+lcString
ENDIF

RETURN IIF(llNoOutput,lcString,"")

************************************************************************
* FoxISAPI :: SendLn
*********************************
***  Function: Low Level Output routine that builds output to the 
***            output source (in this case a string).
***            Adds Carriage Return at the end of the string.
***      Pass: lcString   -   String to output
***            llNoOutput -   Return string as is but don't output
***                           to output source. Use to when nesting
***                           commands.
***    Return: "" or lcString if llNoOutput .T.
************************************************************************
FUNCTION SendLn
LPARAMETER lcString, llNoOutput
RETURN THIS.Send(lcString+CR,llNoOutput)


************************************************************************
* FoxISAPI :: ContentTypeHeader
*********************************
***  Function: Creates a content type header for standard HTML
***            document. Every HTML document requires this header.
***    Return:
************************************************************************
FUNCTION ContentTypeHeader
LPARAMETER lcContentType, llNoOutput

RETURN THIS.Send("HTTP/1.0 200 OK"+CR+;
                 "Content-type: text/html"+;
                 CR+CR,llNoOutput)
                 
************************************************************************
* FoxISAPI :: StartRequest
*********************************
***  Function: This sets up the basics of the Request by assigning
***            various settings. Sets and decodes form variables,
***            and assigns the INI file to a class property
***    Assume: Should be called at the top of each request
***      Pass: lcFormVars   -   The form vars passed to the request
***                             by FOXISAPI.DLL.
***            lcIniFile    -   The INI file that contains the server
***                             vars.
***    Return: nothing
************************************************************************
FUNCTION StartRequest
LPARAMETERS lcFormVars, lcIniFile

lcFormVars=IIF(type("lcFormVars")="C",lcFormVars,"")
lcIniFile=IIF(type("lcIniFile")="C",lcIniFile,"")

THIS.cFormVars=THIS.DecodeUrl(lcFormVars)
THIS.cContentFile=lcIniFile
THIS.cOutput=""

ENDFUNC
* StartRequest


************************************************************************
* FoxISAPI :: StandardPage
*********************************
***  Function: Simple routine to display a page with a header and
***            body.
***      Pass: lcHeader  -   Header Text
***            lcBody    -   Body of a document
***    Return: "" or 
************************************************************************
FUNCTION StandardPage
LPARAMETERS lcHeader, lcBody, lcFooter, llNoOutput
LOCAL lcOutText

lcFooter=IIF(type("lcFooter")="C",lcFooter,"")

THIS.cOutput=""

lcOutText=THIS.ContentTypeHeader(.t.)

lcOutText=lcOutText+;
   "<HTML>"+CR+"<HEAD><TITLE>"+;
   lcHeader+[</TITLE></HEAD>]+CR+[<BODY BGCOLOR="#FFFFFF">]+CR

*** Print Header Text or Graphic
IF ATC("<",lcHeader)=1 AND ATC(">",lcHeader)=1
   lcOutText=lcOutText+THIS.sendln(lcHeader,.T.)
ELSE
   IF !EMPTY(lcHeader)
      lcOutText=lcOutText+"<H1>"+lcHeader+"</H1><HR>"
   ENDIF
ENDIF

lcOutText=lcOutText+lcBody+CR+;
   IIF(EMPTY(lcFooter),"<HR>",lcFooter)+CR+;
   "</BODY></HTML>"

RETURN THIS.send(lcOutText+CR,llNoOutput)
* StandardPage



************************************************************************
* FoxISAPI :: GetFormVar
*********************************
***  Function: Retrieves a Form variable from a HTML form or passed on 
***            query string of the URL.
***    Assume: Based on FOXIS code example shipped with VFP 5.0
***      Pass: lcVal   -   Form Variable to retrieve
***    Return: Value or ""
************************************************************************
FUNCTION GetFormVar
LPARAMETERS cVal
LOCAL n1,c2, cStr

lcFormVars=THIS.cFormVars
cVal=cVal+"="

n1 = AT(cVal,lcFormVars)
IF n1 = 0
	return ""
ENDIF

*** Blank passed
IF n1 + LEN(cVal) => LEN(lcFormVars)
   RETURN ""
ENDIF   
   
c2 = ALLTRIM(SUBSTR(lcFormVars,n1 + LEN(cVal)))
IF "&"$c2
	RETURN ALLTRIM(LEFT(c2,AT('&',c2)-1))
ELSE
	RETURN ALLTRIM(c2)
ENDIF

************************************************************************
* FoxISAPI :: DecodeURL
*********************************
***  Function: This function must be called before using GetFormVar
***            to retrieve HTML form variables.
***    Assume: Taken from FOXIS example of VFP 5.0 (FixURL)
***      Pass: lcEncodedString -  Encoded URL string that
***                               contains the form variables.
***    Return: Decoded string
************************************************************************
FUNCTION DecodeURL
LPARAMETERS  lcFormVars
LOCAL n1,rv
lcFormVars=STRTRAN(lcFormVars,"+"," ")
rv = ""
DO WHILE .T.
	IF "%" $ lcFormVars
		n1 = AT('%',lcFormVars)
		IF n1 > LEN(lcFormVars) - 2
			rv = rv + lcFormVars
			EXIT
		ENDIF
		IF !ISDIGIT(SUBSTR(lcFormVars,n1+1))
			rv = rv + LEFT(lcFormVars,n1)
			lcFormVars = SUBSTR(lcFormVars,n1+1)
			LOOP
		ENDIF
		rv = rv + LEFT(lcFormVars,n1-1) + ;
			CHR(EVAL("0x"+SUBSTR(lcFormVars,n1+1,2)))
		IF LEN(lcFormVars) > n1 + 2
			lcFormVars = SUBSTR(lcFormVars,n1+3)
		ELSE
			EXIT
		ENDIF
	ELSE
		rv = rv + lcFormVars
		EXIT
	ENDIF
ENDDO
lcFormVars = rv
RETURN rv


************************************************************************
* wwCGI :: GetCGIVar
*********************************
***  Function: Generic CGI access routine that allows retrieving a value
***            from the CGI ContentFile.
***      Pass: lcVariable  -   Variable to return value for
***            lcSection   -   Section in the INI file (default: 'CGI')
***            llForceNull -   When .T. returns .NULL. if the entry
***                            can't be found. Otherwise "" is returned.
***    Return: .NULL. if not found or string otherwise
************************************************************************
FUNCTION GetCGIVar
LPARAMETERS lcVariable, lcSection, llForceNull
LOCAL lcResult
lcSection=IIF(TYPE("lcSection")="C",lcSection,"CGI")

lcResult=THIS.GetProfileString(THIS.cContentfile,;
                               lcSection,lcVariable)
IF !llForceNull AND ISNULL(lcResult)
   lcResult=""
ENDIF

RETURN lcResult
* GetCGIVar


************************************************************************
FUNCTION GetProfileString
*************************
***  Modified: 09/26/95
***  Function: Read Profile String information from a given
***            text file using Windows INI formatting conventions
***      Pass: pcFileName   -    Name of INI file
***            pcSection    -    [Section] in the INI file ("Drivers")
***            pcEntry      -    Entry to retrieve ("Wave")
***                              If this value is a null string
***                              all values for the section are
***                              retrieved seperated by CHR(13)s
***    Return: Value(s) or .NULL. if not found
************************************************************************
LPARAMETERS pcFileName,pcSection,pcEntry
LOCAL lcIniValue

pcFileName=IIF(TYPE("pcFileName")="C",pcFileName,"")
pcSection=IIF(TYPE("pcSection")="C",pcSection,"")

*** Default to 0, which means all entries!
pcEntry=IIF(TYPE("pcEntry")="C",pcEntry,0)

*** Initialize buffer for result
lcIniValue=SPACE(256)

DECLARE INTEGER GetPrivateProfileString ;
   IN WIN32API ;
   STRING cSection,;
   STRING cEntry,;
   STRING cDefault,;
   STRING @cRetVal,;
   INTEGER nSize,;
   STRING cFileName

=GetPrivateProfileString(pcSection,pcEntry,"*None*",;
   @lcIniValue,LEN(lcIniValue),pcFileName)

*** Strip out Nulls
IF TYPE("pcEntry")="N" AND pcEntry=0
   *** 0 was passed to get all entry labels
   *** Seperate all of the values with a Carriage Return
   lcIniValue=TRIM(STRTRAN(lcIniValue,CHR(0),CHR(13)) )
ELSE
   *** Individual Entry
   lcIniValue=TRIM(STRTRAN(lcIniValue,CHR(0),""))
ENDIF

*** On error the result contains "*None"
IF lcIniValue="*None*"
   lcIniValue=.NULL.
ENDIF

RETURN lcIniValue
* GetProfileString


ENDDEFINE
* FoxISAPI
