/*+-------------------------------------------------------------------------
	lstat.c - SCO 3.2v4OS with 3.2v2DS interim hack
	wht@n4hgf.Mt-Park.GA.US

Using 3.2v2 DS with 3.2v4 is wrought with troubles, but some
ain't ready to go the trip yet, so here is a piece of projectile vomitus
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:09-09-1992-06:05-wht@n4hgf-creation */

#include <sys/types.h>
#include <sys/stat.h>

#if defined(M_UNIX) && defined(S_IFLNK) && !defined(SCO32v4) && !defined(LINUX)

#include <errno.h>

/*+-------------------------------------------------------------------------
	lstat(path,statptr)
--------------------------------------------------------------------------*/
int
lstat(path,statptr)
char *path;
struct stat *statptr;
{
	int err = EINVAL;
	/*
	 * try lstat system call first 
	 * if it fails with EINVAL, we are not on 3.2v4
	 */
	if(err = syscall(0x5b,path,statptr) && (err == EINVAL))
		err = stat(path,statptr);
	return(err);

}	/* end of lstat */

#endif /* if defined(M_UNIX) && defined(S_IFLNK) && !defined(SCO32v4) */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of lstat.c */
