/* #define TRICKY_SEGV */
/* #ifdef DEBUG_SRP */
/*+-----------------------------------------------------------------------
	ecusighdl.c - xmtr/rcvr individual process signal handlers
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	_start_rcvr_process(notify_flag)
	_start_rcvr_process(notify_flag,fname,fline)
	child_signals()
	kill_rcvr_process(sig)
	rcvr_SIGHUP_handler()
	rcvr_SIGINT_handler()
	rcvr_SIGTERM_handler()
	rcvr_SIGUSR1_handler()
	rcvr_SIGUSR2_handler()
	rcvr_common_signal_handler()
	rcvr_death_handler(sig)
	rcvr_signals()
	termecu(code)
	termecu_code_text(code)
	xmtr_SIGCLD_handler()
	xmtr_SIGHUP_handler(sig)
	xmtr_SIGINT_handler()
	xmtr_SIGTERM_handler(sig)
	xmtr_SIGUSR2_handler()
	xmtr_death_handler(sig)
	xmtr_signals()

------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:10-18-1992-14:11-wht@n4hgf-FAS 2.10 users getting SIGUSR1 on xmtr */
/*:09-16-1992-13:29-wht@n4hgf-add TERMECU_UNRECOVERABLE text */
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:08-17-1992-04:55-wht@n4hgf-keep rcvr pid in shm for friend code */
/*:08-16-1992-03:08-wht@n4hgf-head off another POSIX plot */
/*:08-16-1992-01:54-wht@n4hgf-job control signals get SIG_IGN */
/*:04-29-1992-19:04-wht@n4hgf-make a pass at handling job control signals */
/*:04-29-1992-13:46-wht@n4hgf-ignore SIGQUIT */
/*:04-23-1992-16:20-wht@n4hgf-disable mysterious rcvr SIGCLD events */
/*:02-16-1992-01:42-wht@n4hgf-turn off xterm_title + add _terminate.ep */
/*:08-25-1991-23:56-wht@n4hgf2-handle xmtr core dump gracefully */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:07-17-1991-07:04-wht@n4hgf-avoid SCO UNIX nap bug */
/*:06-29-1991-15:42-wht@n4hgf-if WHT and xterm, play with title bar */
/*:01-29-1991-12:57-wht@n4hgf-on exit, restore setcolor colors if possible */
/*:12-18-1990-20:02-wht@n4hgf-add rcvr_death_handler */
/*:09-19-1990-19:36-wht@n4hgf-ecu_log_event now gets pid for log from caller */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecu.h"
#include "ecufork.h"

extern int windows_active;
extern int current_ttymode;
extern int ttymode_termecu_on_sigint;
extern char lopen_err_str[];
extern int rcvr_log;
extern FILE *rcvr_log_fp;
extern char rcvr_log_file[];	/* if rcvr_log!= 0,log filename */
extern int rcvr_log_append;

int sigint = 0;			/* interrupt indicator */
int proc_interrupt = 0;		/* procedure interrupt indicator */
int last_child_wait_status = 0;
int last_child_wait_pid = 0;
int xmtr_killed_rcvr = 0;

char *signal_name_text();

void termecu();
void xmtr_signals();
void rcvr_signals();
void child_signals();

SIGTYPE rcvr_SIGTERM_handler();
SIGTYPE rcvr_SIGINT_handler();
SIGTYPE rcvr_SIGUSR1_handler();
SIGTYPE rcvr_SIGUSR2_handler();
SIGTYPE rcvr_SIGHUP_handler();
SIGTYPE xmtr_SIGINT_handler();
SIGTYPE xmtr_SIGHUP_handler();
SIGTYPE xmtr_SIGTERM_handler();
SIGTYPE xmtr_SIGCLD_handler();
SIGTYPE xmtr_death_handler();
SIGTYPE rcvr_common_signal_handler();
SIGTYPE rcvr_death_handler();

/*+-----------------------------------------------------------------------
	_start_rcvr_process(notify_flag) - start RCVR process if not extant
------------------------------------------------------------------------*/
#ifndef BUILDING_PROTOTYPES
SIGTYPE
#ifdef DEBUG_SRP
_start_rcvr_process(notify_flag,fname,fline)
int notify_flag;
char *fname;
int fline;
#else
_start_rcvr_process(notify_flag)
int notify_flag;
#endif
{
	extern ulong colors_current;
	ulong colors_at_entry = colors_current;
#if defined(FORK_DEBUG)
	char s40[40];
#endif
#ifdef DEBUG_SRP
	char s80[80];
		sprintf(s80,"start_rcvr_process (%d) file: %s line=%d",
			rcvr_pid,fname,fline);
		ecu_log_event((int)xmtr_pid,s80);
#endif

	fflush(so);
	fflush(se);

	if(rcvr_pid > 0)			/* if process already active,just ... */
		return;

	if(rcvr_log && rcvr_log_file[0] && rcvr_log_fp)
	{
		fclose(rcvr_log_fp);
		rcvr_log_fp = (FILE *)0;
	}

	xmtr_killed_rcvr = 0;
	shm->rcvr_pid = rcvr_pid = smart_fork();
	if(rcvr_pid == 0)		/* if we are the (spawned) rcvr process */
	{
		if(notify_flag)
		{
			setcolor(colors_notify);
			fputs("[interactive mode]",se);
			setcolor(colors_at_entry);
			fputs("\r\n",se);
		}

		rcvr();	/* run until killed */
		/*NOTREACHED*/
	}
	else if(rcvr_pid > 0) 	/* we are the father (xmtr) process */
	{
#if defined(FORK_DEBUG)
		sprintf(s40,"DEBUG rcvr pid %d",rcvr_pid);
		ecu_log_event(getpid(),s40);		/* rcvr */
#endif
		if(rcvr_log)
			rcvr_log_append = 1;	/* until next %log -s */
		xmtr_signals();
		return;
	}

	shm->rcvr_pid = rcvr_pid = -1;		/* no receiver active */

	ff(se,"\r\n\ncould not fork for receive\r\n");
	termecu(TERMECU_NO_FORK_FOR_RCVR);
	/*NOTREACHED*/

}	/* end of _start_rcvr_process */
#endif /* BUILDING_PROTOTYPES */

/*+-----------------------------------------------------------------------
	kill_rcvr_process(sig) -- kill rcvr process with signal 'sig'
------------------------------------------------------------------------*/
SIGTYPE
kill_rcvr_process(sig)
int sig;
{
	int wait_count = 70;

	if(rcvr_pid > 0)		/* if we have forked a rcvr process */
	{
		xmtr_killed_rcvr = 1;
		rcvr_log_fp = (FILE *)0;
		xmtr_signals();
		kill(rcvr_pid,sig);
		if(sig != SIGUSR2)	/* rcvr does not die on SIGUSR2 */
		{
			errno = 0;
			while(wait_count)
			{
				if(kill(rcvr_pid,0) && (errno == ESRCH))
					break;
				errno = 0;
				Nap(40L);
				wait_count--;
			}
			if(!wait_count)
			{
				while(!kill(rcvr_pid,SIGKILL))
				{
					wait((int *)0);
					Nap(40L);
				}
			}
			shm->rcvr_pid = rcvr_pid = -1;		/* no receiver active */
			if(rcvr_log && rcvr_log_file[0])
				rcvr_log_fp = fopen(rcvr_log_file,"a");

			rcvrdisp_actual();	/* write any buffered screen data */
		}
	}

}	/* end of kill_rcvr_process */

/*+-------------------------------------------------------------------------
	termecu_code_text(code)
--------------------------------------------------------------------------*/
char *
termecu_code_text(code)
int code;
{
	static char errant[16];
	char *signal_name_text();

	if((code >= TERMECU_SIG1) && (code <= TERMECU_SIGN))
		return(signal_name_text(code));

	switch(code)
	{
		case TERMECU_BSD4_IOCTL: return("BSD4 ioctl error");
		case TERMECU_CONFIG_ERROR: return("configuration error");
		case TERMECU_CURSES_ERROR: return("error in curses use");
		case TERMECU_GEOMETRY: return("unsupported screen geometry");
		case TERMECU_INIT_PROC_ERROR: return("error during initial procedure");
		case TERMECU_IPC_ERROR: return("IPC (shm/sem) init failed");
		case TERMECU_LINE_OPEN_ERROR: return("line open error");
		case TERMECU_LINE_READ_ERROR: return("line read error");
		case TERMECU_LOGIC_ERROR: return("internal logic error");
		case TERMECU_MALLOC: return("critical memory allocation failure");
		case TERMECU_NO_FORK_FOR_RCVR: return("can't fork for RCVR");
		case TERMECU_PWENT_ERROR: return("password entry error");
		case TERMECU_RCVR_FATAL_ERROR: return("detected RCVR FATAL ERROR");
		case TERMECU_SHM_ABL: return("SHM ABL error");
		case TERMECU_SHM_RTL: return("SHM RTL error");
		case TERMECU_TTYIN_READ_ERROR: return("keyboard read error");
		case TERMECU_UNRECOVERABLE: return("unrecoverable error");
		case TERMECU_USAGE: return("usage");
		case TERMECU_XMTR_FATAL_ERROR: return("detected XMTR FATAL ERROR");
		default:
			sprintf(errant,"code %u?",code);
			return(errant);
	}

}	/* end of termecu_code_text */

/*+-----------------------------------------------------------------------
	termecu(code) -- terminate program (with cleanup)

  see termecu.h for a list of codes

  Separate processing for rcvr and xmtr processes;  rcvr entry
  is only upon some kind of serious error and it more less just dies,
  causing xmtr process to wake up with SIGCLD and come in here.

  Upon entry by xmtr process:
    close comm line
    run any _terminate.ep procedure
    return any ungetty'd line
    return user's console to normal status
    remove shm segment
    terminate program

------------------------------------------------------------------------*/
SIGTYPE
termecu(code)
int code;
{
	int isig;
	int save_errno = errno;
	extern char initial_procedure[];
	shm->terminating = 1;			/* tell friends goodbye */
	if(xmtr_pid == getpid())		/* if we are xmtr */
	{
		for(isig = 1; isig < NSIG; isig++)
			signal(isig,SIG_IGN);
		kill_rcvr_process(SIGUSR1);
		if(windows_active)
			windows_end_signal();
		tcap_curbotleft();
		tcap_eeod();
		if(shm && shm->Lconnected)
			DCE_hangup();
#if defined(WHT2) || defined(XTERM_FRIEND)
		/*
		 * if xterm, remove ecu from the title bar
		 * but this really should be done in _terminate.ep
		 */
		xterm_title("xterm",0);
#endif
		if(find_procedure("_terminate"))
		{
		char code_str[16];
		char *_doproc_args[2];
			_doproc_args[0] = "_terminate";	/* _terminate.ep */
			sprintf(code_str,"%d",code);
			_doproc_args[1] = code_str;
			(void)do_proc(2,_doproc_args);
		}
		if(shm && (shm->Liofd != -1))
			lclose();
		/* make SURE we release any line(s) acquired from getty */
		ungetty_return_line((char *)0);	/* lclose() calls this via unlock_tty(),
										 * but ok to make sure
										 */

		ttymode(0);			/* normal tty status */
		shm_done();
		if(code > NSIG)
		{
			char s64[64];
			setcolor(colors_error);
			if(code == TERMECU_INIT_PROC_ERROR)
				pprintf("initial procedure '%s' failed\n",initial_procedure);
			else if((code > TERMECU_INIT_PROC_ERROR) &&
					(code <= TERMECU_INIT_PROC_ERROR + 32))
			{
				pprintf("procedure command: exit %d\n",
					code - TERMECU_INIT_PROC_ERROR);
			}
			else
			{
				sprintf(s64,"## XMTR %s, errno = %d",termecu_code_text(code),
					save_errno);
				pputs(s64);
				pputs("\n");
				if(lopen_err_str[0])
				{
					pputs(lopen_err_str);
					pputs("\n");
				}
				ecu_log_event(getpid(),s64);
				errno = save_errno;
				if(errno)
					pperror("errno may not apply, but");
			}
		}
		restore_initial_colors();
	}
	else							/* we are rcvr */
	{
		if(code > NSIG)
		{
		char s64[64];
			sprintf(s64,"## RCVR %s, errno = %d",termecu_code_text(code),
				save_errno);
			setcolor(colors_error);
			pputs(s64);
			pputs("\n");
			ecu_log_event(getpid(),s64);
			errno = save_errno;
			if(errno)
				pperror("errno may not apply, but");
		}
		restore_initial_colors();
		kill(xmtr_pid,SIGHUP);
	}
	exit(code);
	/*NOTREACHED*/

}	/* end of termecu */

SIGTYPE
rcvr_common_signal_handler()
{
	extern int rcvr_log;
	extern int rcvr_log_raw;
	extern FILE *rcvr_log_fp;

	if(rcvr_log)
	{
		if(!rcvr_log_raw)
			fputs("\n",rcvr_log_fp);
		fclose(rcvr_log_fp);
	}

	exit(0);
}
SIGTYPE
rcvr_SIGTERM_handler()
{
	rcvr_common_signal_handler();
}
SIGTYPE
rcvr_SIGINT_handler()
{
	signal(SIGINT,rcvr_SIGINT_handler);
}
SIGTYPE
rcvr_SIGUSR1_handler()
{
	rcvr_common_signal_handler();
}
SIGTYPE
rcvr_SIGUSR2_handler()
{
	signal(SIGUSR2,rcvr_SIGUSR2_handler);
	shmr_process_rcvr_SIGUSR2();
}
SIGTYPE
rcvr_SIGHUP_handler()
{
	rcvr_common_signal_handler();
}

/*+-------------------------------------------------------------------------
	rcvr_death_handler(sig) - unexpected signal; try to dump core
--------------------------------------------------------------------------*/
SIGTYPE
rcvr_death_handler(sig)
int sig;
{
	int itmp;
#ifdef TRICKY_SEGV
	int *open_elevator_shaft = (int *)(shm - 1);
#endif

	ttymode(0);
	ff(se,"\nreceiver process caught signal %s\r\n",
	    signal_name_text(sig));
	ff(se,"screen cursor (y,x) = (%u,%u)\r\n",shm->cursor_y,shm->cursor_x);
	for(itmp = 1; itmp < NSIG; itmp++)
		signal(itmp,SIG_DFL);
#ifdef TRICKY_SEGV
	signal(SIGSEGV,SIG_DFL);
	printf("oes=%08lx\n",open_elevator_shaft);
	itmp = *open_elevator_shaft;
#else
	kill((PID_T)getpid(),SIGIOT);
#endif
	_exit(-1);
}	/* end of rcvr_death_handler */

/*+-------------------------------------------------------------------------
	xmtr_SIGINT_handler()
--------------------------------------------------------------------------*/
SIGTYPE
xmtr_SIGINT_handler()
{
	if(ttymode_termecu_on_sigint)
		termecu(SIGINT);

	signal(SIGINT,xmtr_SIGINT_handler);
	sigint = 1;
	proc_interrupt = 1;
}	/* end of xmtr_SIGINT_handler */

SIGTYPE
xmtr_SIGHUP_handler(sig)
int sig;
{
	termecu(sig);
}
SIGTYPE
xmtr_SIGTERM_handler(sig)
int sig;
{
	termecu(sig);
}

SIGTYPE
xmtr_SIGUSR2_handler()
{
	SIGTYPE xmtr_SIGUSR2_handler();
	signal(SIGUSR2,xmtr_SIGUSR2_handler);
	shmx_process_xmtr_SIGUSR2();
}

/*+-------------------------------------------------------------------------
	xmtr_death_handler(sig) - unexpected signal; try to dump core
--------------------------------------------------------------------------*/
SIGTYPE
xmtr_death_handler(sig)
int sig;
{
	int itmp;
#ifdef TRICKY_SEGV
	int *open_elevator_shaft = (int *)(shm - 1);
#endif

	ttymode(0);
	ff(se,"\ntransmitter process caught signal %s\n",
		signal_name_text(sig));
	kill_rcvr_process(SIGUSR1);
	for(itmp = 1; itmp < NSIG; itmp++)
		signal(itmp,SIG_DFL);
#ifdef TRICKY_SEGV
	signal(SIGSEGV,SIG_DFL);
	printf("oes=%08lx\n",open_elevator_shaft);
	fflush(stdout);
	itmp = *open_elevator_shaft;
#else
	kill((PID_T)getpid(),SIGIOT);
#endif
	termecu(sig);
}	/* end of xmtr_death_handler */

/*+-------------------------------------------------------------------------
	xmtr_SIGCLD_handler()
--------------------------------------------------------------------------*/
SIGTYPE
xmtr_SIGCLD_handler()
{

WAIT:
	errno = 0;
	if((last_child_wait_pid = wait(&last_child_wait_status)) < 0)
	{
		if(errno == EINTR)
			goto WAIT;
	}

#if defined(FORK_DEBUG)
	sprintf(s40,"DEBUG fork SIGCLD pid %d term %x",
		last_child_wait_pid,last_child_wait_status);
	ecu_log_event(getpid(),s40);		/* xmtr_SIGCLD_handler() */
#endif

	if((last_child_wait_pid == rcvr_pid) && !xmtr_killed_rcvr)
	{
		ff(se,"\r\nECU receiver process died unexpectedly\r\n");
		termecu(TERMECU_RCVR_FATAL_ERROR);
	}
	signal(SIGCLD,xmtr_SIGCLD_handler);

}	/* end of xmtr_SIGCLD_handler */

/*+-------------------------------------------------------------------------
	child_signals() - signal() calls for children processes
--------------------------------------------------------------------------*/
void
child_signals()
{
	int isig;

	for(isig = 0; isig < NSIG; isig++)
		signal(isig,SIG_DFL);

}	/* end of child_signals */

/*+-------------------------------------------------------------------------
	xmtr_signals()
--------------------------------------------------------------------------*/
void
xmtr_signals()
{
	int sig;

	for(sig = 1; sig < NSIG; sig++)
	{
		switch(sig)
		{

			case SIGHUP:
				signal(sig,xmtr_SIGHUP_handler);
				break;
#if	defined(SIGSTOP)
			/*
			 * call Roto-Rooter on POSIX plots
			 */
			case SIGSTOP:
			case SIGTSTP:
			case SIGCONT:
			case SIGTTIN:
			case SIGTTOU:
				signal(sig,SIG_IGN);
				break;
#endif

#ifdef SIGWINCH
			case SIGWINCH:
				signal(sig,SIG_DFL);
				break;
#endif
			case SIGQUIT:
				signal(sig,SIG_IGN);
				break;
			case SIGINT:
				signal(sig,xmtr_SIGINT_handler);
				break;
			case SIGTERM:
				signal(sig,xmtr_SIGTERM_handler);
				break;
			case SIGCLD:
				signal(sig,xmtr_SIGCLD_handler);
				break;
			case SIGUSR1:
				signal(sig,SIG_IGN);
				break;
			case SIGUSR2:
				signal(sig,xmtr_SIGUSR2_handler);
				break;
			default:
				signal(sig,xmtr_death_handler);
				break;
		}
	}

}	/* end of xmtr_signals */

/*+-------------------------------------------------------------------------
	rcvr_signals()
--------------------------------------------------------------------------*/
void
rcvr_signals()
{
	int sig;

	for(sig = 1; sig < NSIG; sig++)
	{
		switch(sig)
		{

			case SIGHUP:
				signal(sig,rcvr_SIGHUP_handler);
				break;

#if	defined(SIGSTOP)
			case SIGSTOP:
			case SIGTSTP:
			case SIGCONT:
			case SIGTTIN:
			case SIGTTOU:
				signal(sig,SIG_IGN);
				break;
#endif

#ifdef SIGWINCH
			case SIGWINCH:
#endif
			case SIGCLD:
				signal(sig,SIG_DFL);
				break;
			case SIGQUIT:
				signal(sig,SIG_IGN);
				break;
			case SIGINT:
				signal(sig,rcvr_SIGINT_handler);
				break;
			case SIGTERM:
				signal(sig,rcvr_SIGTERM_handler);
				break;
			case SIGUSR1:
				signal(sig,rcvr_SIGUSR1_handler);
				break;
			case SIGUSR2:
				signal(sig,rcvr_SIGUSR2_handler);
				break;
			default:
				signal(sig,rcvr_death_handler);
		}
	}
}	/* end of rcvr_signals */

/* vi: set tabstop=4 shiftwidth=4: */
