#define SHM_REV	0x0ECEC000DL	/* high 16-bits unique, low=revision */
/*+-------------------------------------------------------------------------
	ecushm.h -- ecu shared data segment
	wht@n4hgf.Mt-Park.GA.US
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:59-wht@n4hgf-ECU release 3.20 */
/*:09-10-1992-04:34-wht@n4hgf-add rcvrdisp semaphore */
/*:09-06-1992-13:29-wht@n4hgf-add receiver process buffered screen write */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:08-17-1992-04:55-wht@n4hgf-keep rcvr pid in shm for friend code */
/*:07-19-1992-07:44-wht@n4hgf-85 lines too expensive to keep updated */
/*:07-19-1992-07:42-wht@n4hgf-ttyinit_param -> ttyuse */
/*:05-08-1992-03:36-wht@n4hgf-bumped rev: max screen geometry now 85x80 */
/*:03-27-1992-16:21-wht@n4hgf-re-include protection for all .h files */
/*:12-15-1991-14:22-wht@n4hgf-autorz and zmodem_asterisk_count added */
/*:12-13-1991-04:16-wht@n4hgf-move bell_notify_state to shm */
/*:11-11-1991-22:25-wht@n4hgf-add Ldcdwatch and Ltiobuf */
/*:08-21-1991-01:34-wht@n4hgf-FAR depends only on M_I286 */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:12-19-1990-17:09-wht@n4hgf-make cursor variables unsigned */
/*:11-30-1990-19:01-wht@n4hgf-add ttyinit_param */
/*:11-28-1990-17:43-wht@n4hgf-move cursor_y, cursor_x to right after revision */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#ifndef _ecushm_h
#define _ecushm_h

#if defined(M_I286)
#define FAR far
#else
#define FAR
#endif

#if !defined(ushort)
#define ushort unsigned short
#endif
#if !defined(uchar)
#define uchar unsigned char
#endif
#if !defined(uint)
#define uint unsigned int
#endif
#if !defined(ulong)
#define ulong unsigned long
#endif

/* tty usage parameter (ttyuse) */
#define TTYUSE_NORMAL			0	/* must be zero */
#define TTYUSE_FORCE_SIMPLE		1

/*
 * max length of a logical name or  telephone number string
 * this the actual number of characters: arrays are defined
 * DESTREF_LEN + 1 in length to provide for null
 *
 * (in revisions prior to ALPHA-3.19.16, this was named TELNO_LEN)
 */
#define DESTREF_LEN			40

#define SCREEN_LINES_MAX	43
#define SCREEN_COLS_MAX		80
#define SHM_STRLEN			256
#define TO_SCREEN_BUFSZ		128

typedef struct ecu_sds
{
	uchar screen[SCREEN_LINES_MAX][SCREEN_COLS_MAX];
	ulong shm_revision;
	uint cursor_y;			/* program-maintained receive cursor */
	uint cursor_x;			/* program-maintained receive cursor */
	ushort scr_lines;		/* lines in use */
	ushort scr_cols;		/* columns in use */
	ushort scr_size;		/* screen size (lines * cols) */
	ushort terminating;		/* made one when ECU terminating */
	/* xmtr to rcvr communication area */
	int xcmd;				/* signal from xmtr to rcvr SIGUSR2 */
	int xi1;
	int xi2;
	int xi3;
	char xs1[SHM_STRLEN];
	/* rcvr to xmtr communication area */
	int rcmd;				/* signal from rcvr to xmtr SIGUSR2 */
	int ri1;
	int ri2;
	char rs1[SHM_STRLEN];
	ulong rcvd_chars;		/* rcvr char count */
	ulong rcvd_chars_this_connect;	/* count since last connect */
	ulong xmit_chars;		/* xmit char count */
	ulong xmit_chars_this_connect;	/* count since last connect */
	int Ladd_nl_incoming;	/* when in ksr mode, add nl to cr on receive */
	int Ladd_nl_outgoing;	/* when in ksr mode, add nl to cr on xmit */
	int Lfull_duplex;		/* if non-zero, full duplex else half */
	int Liofd;				/* file descriptor for line */
	int Lmodem_already_init;/* true if modem already initialized */
	int Lconnected;	/* we try to keep accurate */
	int Lparity;			/* 0==NONE, 'e' == even, 'o' == odd */
	uint Lbaud;				/* baud rate */
	char Ldescr[64];		/* description of remote */
	char Lline[64];			/* /dev/ttyname for outgoing line */
	char Llogical[64];		/* logical name of remote (from dial dir) */
	char Lrname[64];		/* logical name of remote (settable) */
	long Loff_hook_time;	/* time() at connect */
	char Ltelno[DESTREF_LEN+1]; /* telephone number for remote or null */
	int Ldcdwatch;			/* state of line DCD watcher */
	ushort Lxonxoff;		/* status of line IXON and IXOFF */
	/*
	 * this is a projectile vomit hack, but you don't need termio.h
	 * to use ecushm.h this way
	 */
#define TIOBUF_SIZE		40	/* big enough for all systems I know about */
	long Ltiobuf[(TIOBUF_SIZE / sizeof(long)) + 1]; /* buffer for termio */
	PID_T xmtr_pid;			/* transmitter process pid */
	PID_T xmtr_ppid;		/* transmitter process' parent's pid */
	PID_T xmtr_pgrp;		/* transmitter process group */
	PID_T rcvr_pid;			/* receiver pid (or -1 if inactive) */
	char tty_name[64];		/* comm line name (not console) */
	uchar ttyuse;			/* see TTYUSE_... above and ecuxfer.c */
	int bell_notify_state;	/* bell/text-event to annunciator mapping state */
	int autorz;				/* if true, automatic rz on rcvd zmodem prefix */
	int autorz_pos;			/* position in autorz match sequence */
	ulong friend_space[128];/* space for friend programs */
	/*
	 * receiver process buffered screen write
	 */
	unsigned char rcvrdisp_buffer[TO_SCREEN_BUFSZ];
	unsigned char *rcvrdisp_ptr;
	int rcvrdisp_count;
	int rcvrdisp_semid;
} ECU_SDS;

extern ECU_SDS FAR *shm;		/* shared segment pointer */

#endif /* _ecushm_h */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of ecushm.h */
