/*+-------------------------------------------------------------------------
	ecusetup.c -- ecu visual "argv"
	wht@n4hgf.Mt-Park.GA.US

  0000000000111111111122222222223333333333444444444455555555556666
  0123456789012345678901234567890123456789012345678901234567890123
00.--[ ecu rev ]-------------------------------------------------.
01|                                                              |
02|  Destination   .......................................       |
03|    Telephone     ....................                        |
04|    Description   ........................................    |
05|                                                              |
06|  tty: /dev/........   (opened)                               | 
07|                                                              |
08|  duplex: .  baud: .....  parity: . (data bits .)             |
09|  add NL to transmitted CR: .                                 |
10|  add NL to received CR:    .                                 |
11|                                                              |
12|                                                              |
13|   TAB:next ^B:prev END:proceed ^D:phone dir  ESC:quit ecu    |
14`--------------------------------------------------------------'

  Defined functions:
	setup_display_baud()
	setup_display_name()
	setup_display_screen(write_lits)
	setup_display_single_char()
	setup_display_tty()
	setup_line_open()
	setup_screen(argv_logical)
	setw_bot_msg(msg)
	setw_err_msg(msg)
	setw_get_single(nondelim_list)
	setw_msg(msg,y,fillch,last_msglen)

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:09-05-1992-14:49-wht@n4hgf-parity field was one to the left of proper pos */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:04-28-1992-01:34-wht@n4hgf-default tty in tty prompt had slash */
/*:04-24-1992-21:59-wht@n4hgf-more SCO tty name normalizing */
/*:08-28-1991-14:07-wht@n4hgf2-SVR4 cleanup by aega84!lh */
/*:08-25-1991-14:39-wht@n4hgf-SVR4 port thanks to aega84!lh */
/*:08-12-1991-00:58-wht@n4hgf-ISC tty names */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:07-17-1991-07:04-wht@n4hgf-avoid SCO UNIX nap bug */
/*:06-05-1991-18:07-wht@n4hgf-rework */
/*:04-27-1991-01:52-wht@n4hgf-overhaul revision numbers */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#include "ecucurses.h"

#define STDIO_H_INCLUDED
#define OMIT_TERMIO_REFERENCES
#include "ecu.h"
#include "ecukey.h"
#include "ecuxkey.h"
#include "ecupde.h"
#include "pc_scr.h"

PDE *logical_telno_to_pde();

#define SETW_LINES	15
#define SETW_COLS	64
#define SETW_TLY	1
#define SETW_TLX	((80 - SETW_COLS) / 2)

#define NAME_Y		2
#define NAME_X		17
#define NAME_LEN	DESTREF_LEN
#define NAME_LX		3

#define PHNUM_Y		3
#define PHNUM_X		19
#define PHNUM_LEN	DESTREF_LEN
#define PHNUM_LX	5

#define DESCR_Y		4
#define DESCR_X		19
#define DESCR_LEN	PDE_DESCR_LEN
#define DESCR_LX	5

#define TTY_Y		6
#define TTY_X		13
#define TTY_LEN		8
#define TTY_LX		3

#define TTYOPN_LY	6
#define TTYOPN_LX	24

#define DPX_Y		8
#define DPX_X		11
#define DPX_LX		3

#define BAUD_Y		8
#define BAUD_X		20
#define BAUD_LEN	5
#define BAUD_LX		14

#define PAR_Y		8
#define PAR_X		35
#define PAR_LX		27

#define DB_Y		8
#define DB_X		48
#define DB_LX		37
#define DB_LX2		49

#define XADDNL_Y	9
#define XADDNL_X	29
#define XADDNL_LX	3

#define RADDNL_Y	10
#define RADDNL_X	29
#define RADDNL_LX	3

extern char *revstr;	/* ecunumrev.c */
extern char errmsg[];

WINDOW *setw;

#define SETW_MSG_LEFTX 2
#define SETW_MSG_MAXLEN	(SETW_COLS - SETW_MSG_LEFTX - 8)
#define SETW_MSG_BOT_Y  (SETW_LINES - 1)
#define SETW_MSG_ERR_Y  (SETW_LINES - 3)

/*+-------------------------------------------------------------------------
	setw_msg(msg,y,fillch)
--------------------------------------------------------------------------*/
void
setw_msg(msg,y,fillch,last_msglen)
char *msg;
int y;
#ifdef LINUX
chtype fillch;
#else
char fillch;
#endif
int *last_msglen;
{
	register itmp;
	register itmp2;
	char msg2[80];

	if(!*last_msglen && !strlen(msg))
		return;

	wmove(setw,y,SETW_MSG_LEFTX);

	if((itmp = strlen(msg)) == 0)
	{
		itmp2 = *last_msglen + 2;
#if defined(SVR4)
		whline(setw, (unsigned long)(fillch & 0x00ff), itmp2);
#else
#if defined(LINUX)
		whline(setw, fillch, itmp2);
#else
  		for(itmp = 0; itmp < itmp2; itmp++)
			waddch(setw,fillch & 0xFF); 
#endif
#endif
		*last_msglen = 0;
	}
	else
	{
		waddch(setw,' ');
		if(itmp > SETW_MSG_MAXLEN)
		{
			strncpy(msg2,msg,SETW_MSG_MAXLEN);
			msg2[SETW_MSG_MAXLEN + 1] = 0;
			waddstr(setw,msg2);
			itmp = strlen(msg2);
		}
		else
		{
			waddstr(setw,msg);
			itmp = strlen(msg);
		}
		waddch(setw,' ');
		if((itmp2 = *last_msglen - itmp) > 0)
		{
#if defined(SVR4)
			whline(setw, (unsigned long)(fillch & 0x00ff), itmp2);
#else
#if defined(LINUX)
			whline(setw, fillch, itmp2);
#else
			while(itmp2--)
  				waddch(setw,fillch & 0xFF); 
#endif
#endif
		}
		*last_msglen = itmp;		/* remember last message length */
	}
	wrefresh(setw);
}	/* end of setw_msg */

/*+-------------------------------------------------------------------------
	setw_bot_msg(msg)
--------------------------------------------------------------------------*/
void
setw_bot_msg(msg)
char *msg;
{
	static int last_msglen = 0;
	setw_msg(msg,SETW_MSG_BOT_Y,sHR,&last_msglen);
}	/* end of setw_bot_msg */

/*+-------------------------------------------------------------------------
	setw_err_msg(msg)
--------------------------------------------------------------------------*/
void
setw_err_msg(msg)
char *msg;
{
	static int last_msglen = 0;

	setw_msg(msg,SETW_MSG_ERR_Y,' ',&last_msglen);
}	/* end of setw_err_msg */

/*+-------------------------------------------------------------------------
	setup_display_name()
--------------------------------------------------------------------------*/
void
setup_display_name()
{
	clear_area(setw,NAME_Y,NAME_X,NAME_LEN);
	waddstr(setw,shm->Llogical);

#if 0
	if(!shm->Llogical[0] && (shm->Liofd < 0))
	{
		clear_area(setw,PHNUM_Y,PHNUM_X,PHNUM_LEN);
		clear_area(setw,DESCR_Y,DESCR_X,DESCR_LEN);
		return;
	}
#endif


	wmove(setw,PHNUM_Y,PHNUM_LX);
	if(shm->Ltelno[0])
		waddstr(setw,"Telephone");
	else
		waddstr(setw,"         ");
	clear_area(setw,PHNUM_Y,PHNUM_X,PHNUM_LEN);
#if 0
	if(!shm->Ltelno[0])
	{
		if(!isdigit(shm->Llogical[0]) && find_procedure(shm->Llogical))
			waddstr(setw,"<procedure connect>");
		else
			waddstr(setw,"<direct connect>");
	}
	else
#endif
		waddstr(setw,shm->Ltelno);

	wmove(setw,DESCR_Y,DESCR_LX);
	if(shm->Ldescr[0])
		waddstr(setw,"Description");
	else
		waddstr(setw,"           ");
	clear_area(setw,DESCR_Y,DESCR_X,DESCR_LEN);
	waddstr(setw,shm->Ldescr);

}	/* end of setup_display_name */

/*+-------------------------------------------------------------------------
	setup_display_tty()
     00000000
     01234567
/dev/........
--------------------------------------------------------------------------*/
void
setup_display_tty()
{
	char s[TTY_LEN + 1];

	strncpy(s,shm->Lline + 5,TTY_LEN);
	s[TTY_LEN] = 0;
	clear_area(setw,TTY_Y,TTY_X,TTY_LEN);
	waddstr(setw,s);
	wmove(setw,TTYOPN_LY,TTYOPN_LX);
	if(shm->Liofd >= 0)
		waddstr(setw,"(opened)");
	else
		waddstr(setw,"        ");
	wrefresh(setw);

}	/* end of setup_display_tty */

/*+-------------------------------------------------------------------------
	setup_display_single_char()
--------------------------------------------------------------------------*/
void
setup_display_single_char()
{
	wmove(setw,DPX_Y,DPX_X);
	waddch(setw,(shm->Lfull_duplex) ? 'F' : 'E');
	wmove(setw,PAR_Y,PAR_X);
	waddch(setw,(shm->Lparity) ? to_upper(shm->Lparity) : 'N');
	wmove(setw,DB_Y,DB_X);
	waddch(setw,(shm->Lparity) ? '7' : '8');
	wmove(setw,XADDNL_Y,XADDNL_X);
	waddch(setw,(shm->Ladd_nl_outgoing) ? 'Y' : 'N');
	wmove(setw,RADDNL_Y,RADDNL_X);
	waddch(setw,(shm->Ladd_nl_incoming) ? 'Y' : 'N');

 }	/* end of setup_display_single_char */

/*+-------------------------------------------------------------------------
	setup_display_baud()
--------------------------------------------------------------------------*/
void
setup_display_baud()
{
	char s8[8];
	clear_area(setw,BAUD_Y,BAUD_X,BAUD_LEN);
	sprintf(s8,"%u",shm->Lbaud);
	waddstr(setw,s8);

}	/* end of setup_display_baud */

/*+-------------------------------------------------------------------------
	setup_display_screen(write_lits)
--------------------------------------------------------------------------*/
void
setup_display_screen(write_lits)
int write_lits;
{

	if(write_lits)
	{
		wmove(setw,NAME_Y,NAME_LX);
		waddstr(setw,"Destination");
		wmove(setw,TTY_Y,TTY_LX);
		waddstr(setw,"tty: /dev/");
		wmove(setw,DPX_Y,DPX_LX);
		waddstr(setw,"duplex:");
		wmove(setw,BAUD_Y,BAUD_LX);
		waddstr(setw,"baud:");
		wmove(setw,PAR_Y,PAR_LX);
		waddstr(setw,"parity:");
		wmove(setw,DB_Y,DB_LX);
		waddstr(setw,"(data bits");
		wmove(setw,DB_Y,DB_LX2);
		waddch(setw,')');
		wmove(setw,XADDNL_Y,XADDNL_LX);
		waddstr(setw,"add NL to transmitted CR:");
		wmove(setw,RADDNL_Y,RADDNL_LX);
		waddstr(setw,"add NL to received CR:");
		wmove(setw,SETW_LINES - 2,1);
		wstandout(setw);
		waddstr(setw,		/* kludge -- must change if setw width does */
			"   TAB:next ^B:prev END:proceed ^D:phone dir  ESC:quit ecu    ");
		wstandend(setw);
	}
	setup_display_name();
	setup_display_tty();
	setup_display_single_char();
	setup_display_baud();
	wrefresh(setw);
}	/* end of setup_display_screen */

/*+-------------------------------------------------------------------------
	setup_line_open()
--------------------------------------------------------------------------*/
int
setup_line_open()
{
	register itmp;
	register retries = 8;
	char *linst_err_text();
	char *cptr;
	char msg[80];
	long wait_msec;
	int displayed_single_char_exit = 0;

	while(itmp = lopen())
	{
		if(retries)
		{
			if(	(itmp != LINST_ENABLED_IN_USE) &&
				(itmp != LINST_DIALOUT_IN_USE) && (itmp < 0))
			{
				goto FAIL;
			}
			sprintf(msg,"%s - waiting %d sec",linst_err_text(itmp),retries);
			cptr = msg;
			if(!displayed_single_char_exit)
			{
				setw_bot_msg("Press any key to skip retries");
				displayed_single_char_exit = 1;
			}
		}
		else
		{
FAIL:
			retries = 0;
			cptr = linst_err_text(itmp);
			ring_bell();
		}
		setw_err_msg(cptr);
		if(!retries--)
			break;
		wait_msec = 1000L;
		while(wait_msec > 0)
		{
			if(ttyrdchk())
			{
				(void)ttygetc(1);
				goto FAIL;
			}
			wait_msec -= Nap(100L);
		}
		setw_err_msg("");
	}
	setup_display_tty();
	return(itmp);

}	/* end of setup_line_open */

/*+-------------------------------------------------------------------------
	setw_get_single(nondelim_list)
assumes cursor is already positioned
--------------------------------------------------------------------------*/
int
setw_get_single(nondelim_list)
register char *nondelim_list;
{
	register uint itmp;
	static uchar setw_nondelim_list[] =
	{
		CRET,NL,CTL_B,CTL_D,TAB,ESC,CTL_L,CTL_R,XFend,XFcurup,XFcurdn
	};

	itmp = winget_single(setw,nondelim_list,setw_nondelim_list);
	if((itmp & 0xFF) == CRET)
		itmp = NL | 0x1000;
	return(itmp);
}	/* end of setw_get_single */

/*+-------------------------------------------------------------------------
	setup_screen(argv_logical)
--------------------------------------------------------------------------*/
void
setup_screen(argv_logical)
char *argv_logical;
{
	register itmp;
	register input_state = 0;
	char s80[80];
	char *cptr;
	char logical[NAME_LEN + 1];
	int done = 0;
	uint baud;
	uchar delim;	/* important to be unsigned to avoid sign extension */
	PDE *tpde;
	WINDOW *window_create();
	static uchar use_input_delim[] =
		{TAB,NL,XFcurdn,XFcurup,XFend,CTL_D,(uchar)0};

	windows_start();
	sprintf(s80,"ecu %s",revstr);
	setw = window_create(s80,-3,SETW_TLY,SETW_TLX,SETW_LINES,SETW_COLS);
	shm->Llogical[0] = 0;
	logical[0] = 0;
	setup_display_screen(1);

REENTER_INPUT_LOOP:
	while(!done)
	{
		wrefresh(setw);
		switch(input_state)
		{
			case 0:
				if(argv_logical)
				{
					itmp = 0;	/* 'ecu -' means dont dial */
					if(strcmp(argv_logical,"-"))	/* if not "-" */
					{
						strncpy(s80,argv_logical,NAME_LEN + 1);
						s80[NAME_LEN + 1] = 0;
						itmp = strlen(s80);
					}
					argv_logical = (char *)0;
					delim = XFend;
				}
				else
				{
					if(logical[0])
						strcpy(s80,logical);
					setw_bot_msg(
						"logical phone directory entry, phone number or empty");
 					itmp = wingets(setw,NAME_Y,NAME_X,s80,NAME_LEN + 1,&delim,
						(logical[0] != 0),(int *)0);
					setw_err_msg("");
				}
				if(strchr((char *)use_input_delim,(char)delim))
				{
					strcpy(logical,s80);
					if((tpde = logical_telno_to_pde(logical)) &&
						!copy_pde_to_Lvariables(tpde,1))
					{
						strcpy(logical,tpde->logical);
						setup_display_screen(0);
						break;
					}
					else
					{
						setw_err_msg(errmsg);
						setup_display_screen(0);
						ring_bell();
						argv_logical = (char *)0;
						continue;
					}
				}
				setup_display_name();
				break;

			case 1:
				cptr = strrchr(DEFAULT_TTY,'/'); /* there will be a /, right? */
				cptr++;
				sprintf(s80,"comm line: i.e., %s",cptr);
				setw_bot_msg(s80);
				setup_display_tty();
				strcpy(s80,"/dev/");
				strcpy(s80,&shm->Lline[5]);
 				itmp = wingets(setw,TTY_Y,TTY_X,s80,TTY_LEN + 1,&delim,
					1,(int *)0);
				setw_err_msg("");
				if(strchr((char *)use_input_delim,(char)delim))
				{
					strcpy(shm->Lline,"/dev/");
					strcpy(&shm->Lline[5],s80);
				}
				setup_display_tty();
				break;

			case 2:
				setw_bot_msg("duplex F:full H:half");
				wmove(setw,DPX_Y,DPX_X);
				wrefresh(setw);
				delim = NL;
				switch(itmp = setw_get_single("fh"))
				{
					case 0:
					case 1:
						shm->Lfull_duplex = itmp;
						break;
					default:
						delim = itmp & 0xFF;
						break;
				}
				break;

			case 3:		/* baud */
				setw_bot_msg(
				"rates: 110,300,600,1200,2400,4800,9600,19200,38400");
CASE_3:
				sprintf(s80,"%u",shm->Lbaud);
 				itmp = wingets(setw,BAUD_Y,BAUD_X,s80,BAUD_LEN + 1,&delim,
					1,(int *)0);
				if(strchr((char *)use_input_delim,(char)delim))
				{
					if(valid_baud_rate(baud = atoi(s80)) < 0)
					{
						setup_display_baud();
						ring_bell();
						goto CASE_3;
					}
					shm->Lbaud = baud;
				}
				setup_display_baud();
				break;

			case 4:
				setw_bot_msg("parity: N:none E:even O:odd");
				wmove(setw,PAR_Y,PAR_X);
				wrefresh(setw);
				delim = NL;
				switch(itmp = setw_get_single("neo"))
				{
					case 0:	shm->Lparity = 0;   break;
					case 1: shm->Lparity = 'e'; break;
					case 2: shm->Lparity = 'o'; break;
					default:
						delim = itmp & 0xFF;
						break;
				}
				wmove(setw,DB_Y,DB_X);
				waddch(setw,(shm->Lparity) ? '7' : '8');
				break;

			case 5:
				setw_bot_msg("");
				wmove(setw,XADDNL_Y,XADDNL_X);
				wrefresh(setw);
				delim = NL;
				switch(itmp = setw_get_single("ny"))
				{
					case 0:
					case 1: shm->Ladd_nl_outgoing = itmp; break;
					default: delim = itmp & 0xFF;
				}
				break;

			case 6:
				setw_bot_msg("");
				wmove(setw,RADDNL_Y,RADDNL_X);
				wrefresh(setw);
				delim = NL;
				switch(itmp = setw_get_single("ny"))
				{
					case 0:
					case 1: shm->Ladd_nl_incoming = itmp; break;
					default: delim = itmp & 0xFF; break;
				}
				break;
		}

		if(argv_logical)
			break;

		switch(delim)
		{
			case XFcurup:
			case CTL_B:
				if(input_state)
					input_state--;
				else
					input_state = 6;
				break;

			case XFcurdn:
			case TAB:
			case NL:
				input_state++;
				input_state %= 7;
				break;

			case ESC:
				if(shm->Liofd >= 0)
					lclose();
				setw_bot_msg("");
				setup_display_tty();
				termecu(0);
				break;

			case CTL_L:
			case CTL_R:
				tcap_clear_screen();
				touchwin(stdscr);
				wrefresh(stdscr);
				setup_display_screen(1);
				touchwin(setw);
				wrefresh(setw);
				break;

			case XFend:
			case CTL_D:
				done = 1;
				break;
		}
	}

	if(shm->Liofd < 0)
	{
		wmove(setw,TTY_Y,TTY_X);
		wrefresh(setw);
		if(setup_line_open())
		{
			done = 0;
			input_state = 1;
			argv_logical = (char *)0;
			goto REENTER_INPUT_LOOP;
		}
	}

	wmove(setw,SETW_LINES - 2,1);
	wstandout(setw);
	waddstr(setw,		/* kludge -- must change if setw width does */
		"------- Press HOME then 'help' for further assistance --------");
	wstandend(setw);
	setw_bot_msg("");
	wrefresh(setw);
	delwin(setw);
	windows_end(0);
	ttymode(1);
	tcap_cursor(SETW_TLY + SETW_LINES + 2,0);
	rcvr_pid = -2;
	if(delim == CTL_D)
		phdir_manager();
	else if(logical[0])
	{
		tpde = logical_telno_to_pde(logical); /* error return not likely now */
		pde_dial(tpde);
	}
	else 
		start_rcvr_process(1);

}	/* end of setup_screen */

/* vi: set tabstop=4 shiftwidth=4: */
