#define MULTISCREEN_DUMP_BUG
/*+-------------------------------------------------------------------------
	ecuscrdump.c - screen dump
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	screen_dump(scrfile)

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:05-29-1992-13:28-wht@n4hgf-no banner - phone numbers are security risk */
/*:07-25-1991-12:56-wht@n4hgf-ECU release 3.10 */
/*:07-17-1991-07:04-wht@n4hgf-avoid SCO UNIX nap bug */
/*:12-21-1990-17:27-wht@n4hgf-non-ansi considerations */
/*:08-14-1990-20:40-wht@n4hgf-ecu3.00-flush old edit history */

#ifdef LINUX
#include <ncurses.h>
#endif
#include "ecu.h"
#include "ecukey.h"
#include "pc_scr.h"

extern char curr_dir[CURR_DIRSIZ];		/* current working directory */
extern uint tcap_LINES;
extern uint tcap_COLS;
extern struct termio tty_termio_at_entry;
extern int tty_not_char_special;
extern int tty_is_multiscreen;

char screen_dump_file_name[256];

/*+-------------------------------------------------------------------------
	screen_dump(scrfile) - dump physical display contents
unless stdin is non-multiscreen and/or /dev/null, in which case,
dump rcvr virtual screen
if scrfile == NULL, default to ~/.ecu/screen.dump
--------------------------------------------------------------------------*/
void
screen_dump(scrfile)
char *scrfile;
{
	uchar schar;
	uchar s256[256];
	register uchar *cptr = s256;
	uchar *sptr = (uchar *)shm->screen;
	int srow = 0;
	int scol = 0;
	FILE *fp;
	struct termio dump_tty_termio_at_entry;
	struct termio dump_tty_termio_current;
	int restart_rcvr = need_rcvr_restart();
	int use_ansi_MC = !(!tty_is_multiscreen || tty_not_char_special);
	uint lines_left = tcap_LINES;

	kill_rcvr_process(SIGUSR1);

	if(use_ansi_MC)
	{
		/* save keyboard termio at entry */
		ioctl(TTYIN,TCGETA,(char *)&dump_tty_termio_at_entry);

		/* set keyboard to termio status at staart of execution of program 
		 * plus a few mods
		 */

		dump_tty_termio_current = tty_termio_at_entry;
		dump_tty_termio_current.c_cflag &= ~(PARENB | PARODD);
		dump_tty_termio_current.c_cflag |= CS8;
		dump_tty_termio_current.c_iflag &= ~(ISTRIP);
		dump_tty_termio_current.c_lflag &= ~(ICANON | ISIG | ECHO);
		ioctl(TTYIN,TCSETAW,(char *) &dump_tty_termio_current);
		ttyflush(2);
	}

	if(scrfile)
		fp = fopen(scrfile,"a");
	else
	{
		get_home_dir(s256);
		strcat((char *)s256,"/.ecu/screen.dump");
		fp = fopen((char *)s256,"a");
	}
	if(!fp)
	{
#if defined(MORSE)
		xbell(XBELL_DONE,1);
#else
		ring_bell();
		Nap(50L);
		ring_bell();
#endif
		return;
	}

#if 0 /* decommitted - security risk */
	get_tod(2,s256);
	fprintf(fp,"==> %s: %s (phone %s)\n",
		s256,shm->Ldescr,(shm->Ltelno[0]) ? shm->Ltelno : "NONE");
#endif

	if(use_ansi_MC)
		write(1,"\033[2i",4);	/* spill your guts, screen */

	while(1)
	{
		if(use_ansi_MC)
		{
			if(!ttyrdchk())
			{
				Nap(hzmsec * 3);
				if(!ttyrdchk())
					break;
			}
			read(0,(char *)&schar,1);
			if(!lines_left)
				continue;
		}
		else
		{
			if(srow == tcap_LINES)
				break;
			if(scol == tcap_COLS)
			{
				scol = 0;
				srow++;
				schar = NL;
			}
			else
			{
				schar = *sptr++;
				scol++;
			}
		}

		if((schar > 0x7E) || (schar < 0x20))
		{
			switch(schar)
			{
			case NL:
				while((cptr > s256) && (*(cptr - 1) == ' '))
					cptr--;
				*cptr++ = 0x0A;
				*cptr = 0;
				fputs((char *)s256,fp);
				cptr = s256;
				*cptr = 0;
				--lines_left;
				continue;

			case at_TL:		
				schar = vanilla_TL;
				break;
			case at_TR:
				schar = vanilla_TR;
				break;
			case at_BL:		
				schar = vanilla_BL;
				break;
			case at_BR:		
				schar = vanilla_BR;
				break;
			case at_LT:			/* left hand T */
				schar = vanilla_LT;
				break;
			case at_RT:			/* right hand T */
				schar = vanilla_RT;
				break;
			case at_VR:			/* vertical rule */
				schar = vanilla_VR;
				break;
			case at_HR:			/* horizontal rule */
				schar = vanilla_HR;
				break;
			default:
				schar = ' ';
			}
		}
		*cptr++ = schar;
	}

	if(use_ansi_MC)
	{
		/* restore keyboard termio at entry */
		ioctl(TTYIN,TCSETAW,(char *)&dump_tty_termio_at_entry);
		ttyflush(2);
#if defined(MULTISCREEN_DUMP_BUG)
		/*
		 * bug in 2.3.1 sco video driver leaves "ESC[2" active;
		 * use "l" (unlock tty) a noop
		 */
		write(TTYOUT,"l",1);
#endif /* MULTISCREEN_DUMP_BUG */
	}

	fclose(fp);

#if defined(MORSE)
	xbell(XBELL_DONE,1);
#else
	ring_bell();
#endif

	if(restart_rcvr)
		start_rcvr_process(0);

}	/* end of screen_dump */
