/*+-------------------------------------------------------------------------
	ecupde.c - various PDE-related functions
	wht@n4hgf.Mt-Park.GA.US

  Defined functions:
	call_logical_telno(logical)
	choose_tty_for_pde(tpde)
	copy_pde_to_Lvariables(tpde,trial)
	logical_telno_to_pde(logical)
	pde_dial(tpde)
	pdetty_to_devtty(pdetty,devtty)
	phdir_list_read()

--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-10-1992-13:58-wht@n4hgf-ECU release 3.20 */
/*:09-05-1992-14:17-wht@n4hgf-was starting rcvr process too early on connect */
/*:08-22-1992-15:38-wht@n4hgf-ECU release 3.20 BETA */
/*:05-13-1992-13:27-wht@n4hgf-active_pde use */
/*:04-24-1992-21:59-wht@n4hgf-more SCO tty name normalizing */
/*:12-02-1991-20:58-wht@n4hgf-breakout into separate module */

#include "ecu.h"
#include "esd.h"
#include "var.h"
#include "ecupde.h"
#include "dvent.h"
#include "termecu.h"
#include "ecuerror.h"
#include "utmpstatus.h"

DVE *hdb_choose_Any();
DVE *hdb_choose_Device();
PDE *phdir_list_search();
char *linst_err_text();

extern char errmsg[];
extern char *default_tty;
extern int windows_active;

char phonedir_name[PHONEDIR_NAME_SIZE];
char *phonedir_trigger = "#ECUPHONE\n";

/*+-----------------------------------------------------------------------
	phdir_list_read()

return 0 if entire list read, else 1 if error (error msg in errmsg)

if file does not exist, create it, asking confirm only if in
interactive (curses) mode
------------------------------------------------------------------------*/
int
phdir_list_read()
{
	register token_number;
	register char *cptr;
	register char *token;
	int itmp;
	char readpde_buf[128];
	FILE *fp_phone;
	PDE *tpde;
	char *str_token();

	if(!phonedir_name[0])
	{
		get_home_dir(phonedir_name);
		strcat(phonedir_name,"/.ecu/phone");
	}

TRY_OPEN:
	if(!(fp_phone = fopen(phonedir_name,"r")))
	{
		if(errno == ENOENT)
		{
			if(!want_pd_create(phonedir_name))
			{
				strcpy(errmsg,"non-existent file not created");
				return(1);
			}
			if((itmp = open(phonedir_name,
				O_RDWR | O_CREAT | O_TRUNC,0600)) >= 0)
			{
				write(itmp,phonedir_trigger,strlen(phonedir_trigger));
				close(itmp);
				if(windows_active)	/* if called under curses */
				{
					dirw_bot_msg("created new (empty) directory file");
					ring_bell();
					Nap(1000L);
				}
				goto TRY_OPEN;
			}
			if(errno == ENOENT)
			{
				strcpy(errmsg,"~/.ecu directory nonexistent!");
				ring_bell();
				return(1);
			}
		}
		strcpy(errmsg,errno_text(errno));
		return(1);
	}

/* we have an open directory file */
	if(!fgets(readpde_buf,sizeof(readpde_buf),fp_phone) ||
		strcmp(readpde_buf,phonedir_trigger))
	{
		fclose(fp_phone);
		strcpy(errmsg,"not an ECU phone directory (or is pre-rev-3)");
		ring_bell();
		return(1);
	}

	dirw_display_phonedir_name();
	phdir_list_erase();		/* clear any previous directory */
	while(fgets(readpde_buf,sizeof(readpde_buf),fp_phone))
	{
		if(readpde_buf[0] == '#')		/* comment? */
			continue;
		if(itmp = strlen(readpde_buf))	/* itmp = len; if > 0 ... */
		{
			itmp--;
			readpde_buf[itmp] = 0;		/* ... strip trailing NL */
		}
		cptr = readpde_buf;				/* first call to str_token, -> buff */
		while((*cptr == 0x20) || (*cptr == 0x09))
			cptr++;						/* strip leading spaces */
		if(*cptr == 0)					/* if line all blank, skip it */
			continue;

		if(!(tpde = (PDE *)malloc(sizeof(PDE ))))
		{
			fclose(fp_phone);
			strcpy(errmsg,"Out of memory reading phone list");
			return(1);
		}

		tpde->descr[0] = 0;
		tpde->logical[0] = 0;
		tpde->telno[0] = 0;
		tpde->tty[0] = 0;
		tpde->parity = 0;
		tpde->baud = 2400;
		tpde->redial = 0;
		tpde->prev = (PDE *)0;
		tpde->next = (PDE *)0;
		tpde->debug_level = 0;
		tpde->dcdwatch = 'n';		/* do not modify shm->Ldcdwatch */

		token_number = 0;
		while((token = str_token(cptr,":")))
		{
			cptr = (char *)0;	/* further calls to str_token need NULL */
			switch(token_number)
			{
				case 0:		/* first field is logical name */
					strncpy(tpde->logical,token,sizeof(tpde->logical));
					tpde->logical[sizeof(tpde->logical) - 1] = 0;
					break;
				case 1:		/* second field is tpde->telno phone number */
					strncpy(tpde->telno,token,sizeof(tpde->telno));
					tpde->telno[sizeof(tpde->telno) - 1] = 0;
					break;
				case 2:		/* third field is line */
					strncpy(tpde->tty,token,sizeof(tpde->tty));
					tpde->tty[sizeof(tpde->tty) - 1] = 0;
					break;
				case 3:		/* fourth field is baud rate */
					tpde->baud = atoi(token);
					break;
				case 4:		/* fifth field is parity */
					switch(itmp = to_lower(token[0]))
					{
						case 'o':
						case 'e':
						case 'm':
						case 's':
							tpde->parity = itmp;
							break;
						default:
						case 'n':
							tpde->parity = 0;
							break;
					}
					break;
				case 5:
					strncpy(tpde->descr,token,sizeof(tpde->descr));
					tpde->descr[sizeof(tpde->descr) - 1] = 0;
					break;
				case 6:
					if((tpde->debug_level = (uchar)atoi(token)) > 9)
						tpde->debug_level = 9;
					break;
				case 7:
					tpde->dcdwatch = to_lower(token[0]);
					break;
			}	/* end of switch(token_number) */
			token_number++;
		}		/* end while not end of record */

		phdir_list_add(tpde);

	}			/* while records left to ready */

	fclose(fp_phone);
	return(0);
}	/* end of phdir_list_read */

/*+-------------------------------------------------------------------------
	pde_dial(tpde) - dial using a pde (using procedure if configured)

If the tpde->logical points to a valid procedure, use it,
otherwise call DCE_dial()

returns proc error code
        $i0 value ($s0 is also set, BTW)

assumes rcvr process dead (rcvr_pid == -1)
--------------------------------------------------------------------------*/
int
pde_dial(tpde)
register PDE *tpde;
{
	int status = 0;
	int restart_rcvr = need_rcvr_restart();
	char *cptr;
	extern int dcdwatch_set;	/* see ldcdwatch() in eculine.c */

	dcdwatch_set = 0;

	kill_rcvr_process(SIGUSR1);

	if(proc_level || !find_procedure(tpde->logical))
	{
		if(copy_pde_to_Lvariables(tpde,0))
		{
			pprintf("%s: %s\n",tpde->logical,errmsg);
			pprintf("Current line is %s (%s)\n",
				shm->Lline,(shm->Liofd < 0) ? "closed" : "open");
			status = eFATAL_ALREADY;
		}
		else
			status = DCE_dial();
	}
	else
	{
		char *pargv[2];
		pargv[0] = tpde->logical;
		pargv[1] = "!MENU";
		iv[0] = 0;
		if(do_proc(2,pargv))
			status = eFATAL_ALREADY;
		else
			status = (iv[0]) ? eConnectFailed : 0;
	}

	/*
	 * if we connected and a procedure did not change the DCD watcher,
	 * then use the dialing directory choice
	 */
	if(!status && !dcdwatch_set)
	{
		cptr = (char *)0;
		switch(tpde->dcdwatch)
		{
			case '0':	
				ldcdwatch(DCDW_OFF); 
				cptr = "OFF (ignore DCD loss)";
				break;
			case '1':	
				ldcdwatch(DCDW_ON); 
				cptr = "ON (detect DCD loss)";
				break;
			case 't':	
				ldcdwatch(DCDW_TERMINATE); 
				cptr = "TERMINATE (terminate ecu on DCD loss)";
				break;
			case 'n':	
			default:	
				break;
		}
		if(cptr)
		{
			ulong colors_save;
			colors_save = colors_current;
			setcolor(colors_notify);
			pprintf("[DCD watcher set to %s]",cptr);
			setcolor(colors_save);
			fputs("\r\n",se);
			pputs("\n");
		}
	}

	if(restart_rcvr)
		start_rcvr_process(1);

	return(status);

}	/* end of pde_dial */

/*+-------------------------------------------------------------------------
	pdetty_to_devtty(pdetty,devtty) -> pde tty field to complete pathname
--------------------------------------------------------------------------*/
void
pdetty_to_devtty(pdetty,devtty)
char *pdetty;
char *devtty;
{
	strcpy(devtty,"/dev/");
#ifdef M_SYSV
	if(strncmp(pdetty,"tty",3))
		strcat(devtty,"tty");
#endif
	strcat(devtty,pdetty);

}	/* end of pdetty_to_devtty */

/*+-------------------------------------------------------------------------
	choose_tty_for_pde(tpde) - new pde might mandate switching line

Returns 1 if new line open needed
        0 if no new line open needed
       -1 if request cannot be satisfied
--------------------------------------------------------------------------*/
int
choose_tty_for_pde(tpde)
register PDE *tpde;
{
	int itmp = 0;
	int rtn = 0;
	DVE *tdve;
	char newtty[64];

#ifdef CHOOSE_DEBUG
	char s256[256];
	sprintf(s256,"choose_tty_for_pde '%s' %u",tpde->tty,tpde->baud);
	ecu_log_event((int)xmtr_pid,s256);
	errmsg[0] = 0;
#endif

	/*
	 * if desired line is Devices type 
	 */
	if((tpde->tty[0] == '=') || (tpde->tty[0] == '/')) /* Devices device type */
	{
		if(!(tdve = hdb_choose_Device(tpde->tty,tpde->baud)))
		{
			sprintf(errmsg,"no idle line matches type '%s' at %u baud",
				*tpde->tty ? tpde->tty : "Any",tpde->baud);
			rtn = -1;
			goto RETURN;
		}
		sprintf(newtty,"/dev/%s",tdve->line);
		if((itmp = lock_tty(newtty)) && (itmp != LINST_WEGOTIT))
		{
			sprintf(errmsg,"%s (%s): %s",
			    tpde->tty,tdve->line,linst_err_text(itmp));
			rtn = -1;
			goto RETURN;
		}
		if((itmp = reserve_line(newtty)) && (itmp != LINST_WEGOTIT))
		{
			sprintf(errmsg,"%s: %s",newtty,linst_err_text(itmp));
			rtn = -1;
			goto RETURN;
		}
	}
	/*
	 * if desired line is a specific tty
	 */
	else if(tpde->tty[0])
	{
		pdetty_to_devtty(tpde->tty,newtty);
		if((shm->Liofd > 0) && !strcmp(newtty,shm->Lline))
		{
			rtn = 0;	/* requesting line we already have */
			goto RETURN;
		}
		if((itmp = lock_tty(newtty)) && (itmp != LINST_WEGOTIT))
		{
			sprintf(errmsg,"%s: %s",newtty,linst_err_text(itmp));
			rtn = -1;
			goto RETURN;
		}
		if((itmp = reserve_line(newtty)) && (itmp != LINST_WEGOTIT))
		{
			sprintf(errmsg,"%s: %s",newtty,linst_err_text(itmp));
			rtn = -1;
			goto RETURN;
		}
	}
	/*
	 * if desired line is "Any" (any Devices type beginning with ACU)
	 */
	else	/* "Any" */
	{
		tdve = hdb_choose_Any(tpde->baud);
		if(!tdve)
		{
			sprintf(errmsg,"no idle ACU line at %u baud",tpde->baud);
			rtn = -1;
			goto RETURN;
		}
		sprintf(newtty,"/dev/%s",tdve->line);
		if((itmp = lock_tty(newtty)) && (itmp != LINST_WEGOTIT))
		{
			sprintf(errmsg,"%s: %s",newtty,linst_err_text(itmp));
			rtn = -1;
			goto RETURN;
		}
		if((itmp = reserve_line(newtty)) && (itmp != LINST_WEGOTIT))
		{
			sprintf(errmsg,"%s: %s",newtty,linst_err_text(itmp));
			rtn = -1;
			goto RETURN;
		}
	}

	rtn = !(!strcmp(newtty,shm->Lline) && (shm->Liofd != -1));
	if(rtn)
	{
		lclose();
		strcpy(shm->Lline,newtty);
	}


RETURN:

#ifdef CHOOSE_DEBUG
	sprintf(s256,"choose_tty_for_pde rtn=%d line='%s' errmsg='%s' itmp=%d",
		rtn,shm->Lline,errmsg,itmp);
	ecu_log_event((int)xmtr_pid,s256);
#endif

	return(rtn);

}	/* end of choose_tty_for_pde */

/*+-------------------------------------------------------------------------
	copy_pde_to_Lvariables(tpde,trial)

'trial' controls whether this is a dry run (setup) or a live request
if changing line, close old line and open new one
if cannot change line, return -1, else 0
--------------------------------------------------------------------------*/
int
copy_pde_to_Lvariables(tpde,trial)
register PDE *tpde;
int trial;
{
	int reopen = 0;
	int lerr;
	DVE *tdve;

#ifdef CHOOSE_DEBUG
	char s80[80];
	sprintf(s80,"copy_pde trial=%d Lline='%s' pdetty='%s'",
		trial,shm->Lline,tpde->tty);
	ecu_log_event((int)xmtr_pid,s80);
#endif

	enddvent();	/* krock safety */

	if(!trial)
	{
		if((reopen = choose_tty_for_pde(tpde)) < 0)
			return(-1);		/* errmsg[] updated */
	}
	else if((!tpde->tty[0]) || (!strcmp(tpde->tty,"Any")))
	{
		if(!(tdve = hdb_choose_Any(tpde->baud)))
		{
			strcpy(errmsg,"no idle line matches type 'Any'");
			return(-1);
		}
		strcpy(shm->Lline,"/dev/");
		strncat(shm->Lline,tdve->line,sizeof(shm->Lline) - 5);
		shm->Lline[sizeof(shm->Lline) - 1] = 0;
	}
	else if((tpde->tty[0] == '/') || (tpde->tty[0] == '='))
	{
		if(!(tdve = hdb_choose_Device(tpde->tty,tpde->baud)))
		{
			sprintf(errmsg,"no idle line matches type '%s' at %u baud",
				*tpde->tty ? tpde->tty : "Any",tpde->baud);
			return(-1);
		}
		strcpy(shm->Lline,"/dev/");
		strncat(shm->Lline,tdve->line,sizeof(shm->Lline) - 5);
		shm->Lline[sizeof(shm->Lline) - 1] = 0;
	}
	else
		pdetty_to_devtty(tpde->tty,shm->Lline);

#ifdef CHOOSE_DEBUG
	sprintf(s80,"copy_pde 2  Lline='%s' reopen=%d",shm->Lline,reopen);
	ecu_log_event((int)xmtr_pid,s80);
#endif

	shm->Lbaud = tpde->baud;	
	strcpy(shm->Llogical,tpde->logical);
	strcpy(shm->Ldescr,tpde->descr);
	strcpy(shm->Ltelno,tpde->telno);
	if(!shm->Ldescr[0])
		strcpy(shm->Ldescr,shm->Llogical);
	shm->Lparity = tpde->parity;
	if(shm->Lbaud != tpde->baud)
		shm->Lmodem_already_init = 0;
	Ldial_debug_level = tpde->debug_level;
	/* tpde->dcdwatch is explicitly unused here; must defer until connect  */

	if(!trial)
	{
		if(reopen)
		{
			if(lerr = lopen())
			{
				tcap_curbotleft();
				pprintf("%s: %s\n",shm->Lline,linst_err_text(lerr));
				termecu(TERMECU_LINE_OPEN_ERROR);
			}
		}
		else
		{
			lset_baud_rate(1);
			lset_parity(1);
		}
	}
	return(0);

}	/* end of copy_pde_to_Lvariables */

/*+-----------------------------------------------------------------------
	logical_telno_to_pde() - logical dial string to dialing info (PDE)

	NOT USED BY THE CURSES DIRECTORY MANAGER

A logical telephone number is one of:
1. null,
2. a symbolic identifer, or
3. an actual telephone number.  

A symbolic identifer is a string whose initial character is a
letter.  An actual telephone number begins with a numeral.

This function converts a logical telephone number to a dialing
entry (PDE) from the directory or a constructed static one.  It
is called by command line processing when 'ecu logical-name' is
specified or in response to a %dial logical-name.

The function returns one of the following:

  directory or static PDE		if no error occurs
  (PDE *)0						if not numeric phone number
								and logical string not found in directory;
								global char[] errmsg has been plugged with
								error message

------------------------------------------------------------------------*/
PDE *
logical_telno_to_pde(logical)
char *logical;
{
	static PDE literal_number_pde;
	register PDE *tpde = 0;
	extern int phdir_list_quan;

#ifdef CHOOSE_DEBUG
	char s80[80];
	sprintf(s80,"logical_telno_to_pde(logical='%s')",logical);
	ecu_log_event((int)xmtr_pid,s80);
#endif

/*
 * if literal phone number, return homemade, static "PDE"
 * with most stuff dummied up with the status quo
 */
	if(isdigit(*logical))
	{
		tpde = &literal_number_pde;
		memset((char *)tpde,0,sizeof(PDE));
		tpde->baud = shm->Lbaud;
		tpde->parity = shm->Lparity;
		strncpy(tpde->logical,logical,DESTREF_LEN);
		tpde->logical[DESTREF_LEN] = 0;
		strncpy(tpde->telno,logical,DESTREF_LEN);
		tpde->telno[DESTREF_LEN] = 0;
		strncpy(tpde->tty,shm->Lline + 5,PDE_TTY_LEN);
		tpde->tty[PDE_TTY_LEN] = 0;
		if((strlen(logical) + 8) <= PDE_DESCR_LEN)
			sprintf(tpde->descr,"<telno %s>",logical);
		else
			strcpy(tpde->descr,"<telno>");
		tpde->dcdwatch = 'n';
		goto RETURN;
	}

/*
 * if empty phone number, return homemade, static "PDE"
 * with most stuff dummied up with the status quo
 */
	if(!*logical)
	{
		tpde = &literal_number_pde;
		memset((char *)tpde,0,sizeof(PDE));
		tpde->baud = shm->Lbaud;
		tpde->parity = shm->Lparity;
		strcpy(tpde->tty,shm->Lline + 5);
		if(!tpde->tty[0])
			strcpy(tpde->tty,default_tty + 5);
		strcpy(tpde->descr,"<direct connect>");
		tpde->dcdwatch = 'n';
		goto RETURN;
	}

	/*
	 * read directory if necessary
	 */
	if(!phdir_list_quan)
	{
		if(phdir_list_read() && !phdir_list_quan)
		{	/* if still no good, ... */
			strcpy(errmsg,"phone directory empty");
			tpde = 0;
			goto RETURN;
		}
	}

	/*
	 * now, look up the entry
	 */
	if(tpde = phdir_list_search(logical,0))
		goto RETURN;

	/*
	 * whoops ... not found
	 */
	shm->Lrname[0] = 0;
	shm->Ltelno[0] = 0;
	shm->Ldescr[0] = 0;
	strcpy(errmsg,"entry not found in directory");
	tpde = 0;

RETURN:

#ifdef CHOOSE_DEBUG
	sprintf(s80,"logical_telno_to_pde %s%s",
		(tpde) ? "chosen tty=" : "no tty chosen",
		(tpde) ? tpde->tty : "");
	ecu_log_event((int)xmtr_pid,s80);
#endif

	return(tpde);

}	/* end of logical_telno_to_pde */

/*+-------------------------------------------------------------------------
	call_logical_telno(logical) - call a logical or literal telephone number

-1 if no such entry or pde_dial() status
--------------------------------------------------------------------------*/
int
call_logical_telno(logical)
char *logical;
{
	int ret;
	PDE *tpde;

	if(tpde = logical_telno_to_pde(logical))
		ret = pde_dial(tpde);
	else
	{
		pprintf("%s: %s\n",logical,errmsg);
		ret = eFATAL_ALREADY;
	}

	return(ret);

}	/* end of call_logical_telno */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of ecupde.c */
